#include <Window.h>
#include <ListView.h>
#include <ListItem.h>
#include <Message.h>
#include <ScrollBar.h>
#include <Archivable.h>

#include "property.h"

#ifndef INSPECTOR_H
#define INSPECTOR_H

#define CMD_SELECTED 'SLCT'
#define CMD_INVOKED  'INVK'

class InspectorWindow : public BWindow {
private:
	BArchivable			*fTarget;
	BMessage			*msg;
	int	 				nameWidth;
	
	CPropertyEditView*	fCurrentEditor;
	
	void				DoPropertySelected();
	void				DoPropertyInvoked();
public:
	BListView			*properties;
	BScrollBar			*scrollbar;

						InspectorWindow(BRect frame);
						~InspectorWindow();
					
	virtual	void 		MessageReceived(BMessage* message);
	virtual void 		DispatchMessage(BMessage *message, BHandler *target);

	void				SetTarget(BArchivable *aTarget);
	BArchivable*		Target();

	void				SetNameWidth(int newWidth);
	int					GetNameWidth();
	void				RefreshProperties();
	
	CPropertyEditView*	GetCurrentEditor();
	void				SetCurrentEditor(CPropertyEditView* aEditView);
};

class PropertyItem : public BListItem {
private:
	BMessage	*fMsg;
	int			fIndex;
	CProperty	*fProperty;
public:
				PropertyItem(BMessage *aMsg, int aIndex, CProperty* aProperty);
				~PropertyItem();
						
				void DrawItem(BView *owner, BRect itemRect, bool complete = false);
				CProperty* Property();
};
#endif