#include <View.h>
#include <Message.h>
#include <Handler.h>
#include <TextControl.h>
#include <Archivable.h>
#include <Looper.h>

#ifndef _PROPERTY_H_
#define _PROPERTY_H_

#define DEFAULT_EDITOR "Default_Editor"

class CPropertyEditor;

CPropertyEditor* RegisterPropertyEditor(CPropertyEditor* editor);

class CProperty {
private:
	BArchivable*	fHandler;
	BLooper*		fLooper;
	char*			fName;
	int				fIndex;
	int32			fType;
public:
					CProperty(BLooper* aLooper, BArchivable* aHandler, char* aName, int aIndex, int32 aType);

	BLooper*		Looper();	
	BArchivable*	Handler();
	char*			Name();
	int				Index();
	int32			Type();
};

class CPropertyEditor {
private:
	CPropertyEditor*			next;

	friend CPropertyEditor* RegPropertyEditor(CPropertyEditor* editor);
protected:	
	virtual	bool CanHandle(BArchivable* object, char* name, int32 type);
	virtual void GetAsString(BMessage* message, CProperty* property, char* buf, int bufSize);
	virtual void SetAsString(BMessage* message, CProperty* property, char* buf);	
	virtual const char* ClassName();
public:
	
    CPropertyEditor();
    
    static	CPropertyEditor*	Find(BArchivable* object, char* name, int32 type);
	virtual	void Draw(BMessage* message, CProperty* property, BView* view, BRect rect, bool complete = false);
	virtual void Edit(BMessage* message, CProperty* property, BView* view, BRect rect);
	virtual void Edited(CProperty* property, char* value);
};

class CStringEditor : public CPropertyEditor {
protected:
	virtual bool CanHandle(BArchivable* object, char* name, int32 type);
	virtual void GetAsString(BMessage* message, CProperty* property, char* buf, int bufSize);
	virtual void SetAsString(BMessage* message, CProperty* property, char* buf);
public:
};

class CIntEditor : public CPropertyEditor {
protected:
	virtual bool CanHandle(BArchivable* object, char* name, int32 type);
	virtual void GetAsString(BMessage* message, CProperty* property, char* buf, int bufSize);
	virtual void SetAsString(BMessage* message, CProperty* property, char* buf);
public:
};

class CFloatEditor : public CPropertyEditor {
protected:
	virtual bool CanHandle(BArchivable* object, char* name, int32 type);
	virtual void GetAsString(BMessage* message, CProperty* property, char* buf, int bufSize);
	virtual void SetAsString(BMessage* message, CProperty* property, char* buf);
public:
};

class CRectEditor : public CPropertyEditor {
protected:
	virtual bool CanHandle(BArchivable* object, char* name, int32 type);
	virtual void GetAsString(BMessage* message, CProperty* property, char* buf, int bufSize);
public:
};

class CPropertyEditView {
public:
	CPropertyEditView();
	virtual void Edit(BMessage* message, CProperty* property, CPropertyEditor* editor, BView* view, BRect rect, const char* value);
	virtual void Done();
	virtual void Cancel();
};

class CPropertyTextView : public BTextControl, public CPropertyEditView {
private:
	CProperty*			fProperty;
	CPropertyEditor*	fEditor;
public:
	CPropertyTextView(BRect rect, char* name);
	
	virtual void Edit(BMessage* message, CProperty* property, CPropertyEditor* editor, BView* view, BRect rect, const char* value);
	virtual void Done();
	virtual void Cancel();
		
	virtual void WindowActivated(bool active);
	virtual void MakeFocus(bool flag = true);	
};

#endif
