#include <View.h>

#ifndef _view_h
#define _view_h
#include <View.h>

class ZBackgroundView : public BView {
	public:
						ZBackgroundView(BRect );
		virtual void	Draw(BRect );
				void	PaintBackground(BRect original, BRect source);
		virtual void	MouseDown(BPoint point); 
};

class BitmapView : public BView
{
	public:
		BitmapView(BBitmap* bitmap, BRect frame, const char* name,
				uint32 resizingMode = B_FOLLOW_LEFT | B_FOLLOW_TOP,
				uint32 flags = B_WILL_DRAW);
		~BitmapView();
		
		virtual void AttachedToWindow();
		void 	Draw(BRect);
		void 	Zoom();
		void 	AnimatedZoom(int zoom_direction);
		void 	ResizeView();
		virtual void KeyDown(const char *bytes, int32 numbytes);
		void 	BlurImage();
		void	AdjustZoom(float);
			
	private:
		BBitmap*	image;
		float		zoom_factor;
		BPoint		center;
};

#endif
