// Linked list, written by Zenja Solaja, December 2000

#include <stdlib.h>
#include <StorageKit.h>
#include <InterfaceKit.h>

#include "linked_list.h"
#include "main.h"

//============================
void add_to_list(const char *buffer)
{
	LINKED_LIST *member = new LINKED_LIST;
	
	if (!member) {
		delete_list();
		exit(0);
	}
	strcpy(member->contents, buffer); 
	member->next = NULL;
	member->prev = list_navigation->tail;
	if (member->prev == NULL) //first element in list?
		list_navigation->head = member;
	else
		list_navigation->tail->next = member;
	list_navigation->tail = member;
	
	BPath aPath(buffer, NULL, false);
	member->bstring = new BStringItem(aPath.Leaf(), 0, true);
}

//=============================
void delete_list(void)
{
	LINKED_LIST *where = list_navigation->tail;
	if (where == NULL) //sanity check, nothing to delete
		return; 
	while (where != list_navigation->head)
	{
		where = where->prev;
		delete where->next;
	}	 	
	delete where;
	list_navigation->head = list_navigation->tail = NULL;
}

		