// Z-Viewer, written by Zenja Solaja, December 2000
// Z-Viewer is a zoomable image viewer.

#include <AppKit.h>
#include <StorageKit.h>
#include <string.h>

#include "main.h"
#include "ZWindow.h"
#include "ZFileAccess.h" 
#include "linked_list.h"
#include "ZScrollView.h"

// now what would an app be without a global or two?
LIST_NAVIGATION *list_navigation;
BitmapView		*bitmap_view;
ZWindow			*zv_window;
ZBackgroundView *zv_backview;
bool 			fullscreen;
bool			animation; 


//===================================
int main(void)
{
	bitmap_view = NULL;
	fullscreen = false;
	animation = false;
	ZViewerApp *zv = new ZViewerApp;
			
	list_navigation = new LIST_NAVIGATION;
	list_navigation->head = list_navigation->tail = list_navigation-> position = NULL;
	
	be_app->PostMessage(SELECT_DIR_MSG);
	zv->Run();
		
	delete_list();
	delete list_navigation;
	delete zv;
}

//======================
ZViewerApp::ZViewerApp()
	:BApplication("application/x-vnd.ZS-ZViewer")
{
	//zviewer window
	BRect aRect(220, 50, 640, 480);
	zv_window = new ZWindow(aRect);
	zv_window->Show();
	
	//file open window
	filepanel = new ZFilePanel();
		
	//listview window
	aRect.Set(50, 100, 195, 400);
	zv_listwindow = new ZListWindow(aRect);
}

//===========================
void ZViewerApp::MessageReceived(BMessage *message)
{
	switch(message->what){
		case SELECT_DIR_MSG: {
			filepanel->Show();
			break;
		}
		case OPEN_FILE_MSG: {
			filepanel->ImageSelected();
			filepanel->Hide();
			zv_window->PrepareBitmap(list_navigation->position->contents);
			break;
		}
		default:
			BApplication::MessageReceived(message);
	}
}

//==============================================
void ZViewerApp::RefsReceived(BMessage *message)
{
	uint32 type; 
	int32 count;
	entry_ref ref;
	BPath path;

	message->GetInfo("refs", &type, &count); 
	if ( type != B_REF_TYPE ) return; //sanity check
	if ( message->FindRef("refs", 0, &ref) == B_OK ) { 
		BEntry entry(&ref, true);
		if ( entry.IsDirectory() && entry.GetPath(&path)==B_OK)
		{
			if (drill_through_directory(path.Path()))
				zv_window->PrepareBitmap(list_navigation->position->contents);
			else
			{
				BAlert *alert = new BAlert("", "Search here, search there.\
												Hard disk search everywhere.\
												No images found.", "Oops");
				alert->Go();
			}
		}
	}
}