#include <StorageKit.h>
#include <InterfaceKit.h>
#include <string.h>

#include "main.h"
#include "ZFileAccess.h"
#include "linked_list.h"
#include "ZScrollView.h"
#include "ZWindow.h"

//============================================
bool drill_through_directory(const char *path) 
{ 
	BDirectory dir(path);
	status_t err = B_OK;
	char *tstr = new char[B_MIME_TYPE_LENGTH];
	BPath workpath;
	BEntry item;
	bool image_found = false;
		
	if (dir.InitCheck() == B_OK) {
		while(dir.GetNextEntry(&item) == B_OK)
		{ 
			item.GetPath(&workpath);
			if (!item.IsDirectory())
			{
				BNode *node = new BNode(workpath.Path());
				if((err = node->InitCheck())==B_OK)
				{
					BNodeInfo *ninfo = new BNodeInfo(node);
					if((err = ninfo->InitCheck())==B_OK)
					{
						if((err = ninfo->GetType(tstr))==B_OK)
						{
							if(!strncmp(tstr,"image/",6)) {
								if (!image_found) { // only delete list if first image
									delete_list();
									zv_listwindow->EmptyList();
									image_found = true;
								}
								add_to_list(workpath.Path()); //Store in linked list
								zv_listwindow->AddItem(list_navigation->tail->bstring); 
							}
						}
					}
					delete ninfo;
				}
				delete node; 
			}
		}
	}
	delete tstr;
	if (image_found)
		list_navigation->position = list_navigation->head;  //start from top
	return (image_found);
} 

//============================================
ZFilePanel::ZFilePanel()
	: BFilePanel(B_OPEN_PANEL, NULL, NULL, B_DIRECTORY_NODE, false, NULL, NULL, false, true)
{
	BView* aview;

	if (Window()->Lock())
	{
		BView* cancel = Window()->FindView("cancel button");
		
		if (cancel) //make sure cancel button exists
		{
			// add Open File button
			aview = Window()->ChildAt(0); // get the background view
			if (aview)
			{
				BRect arect(cancel->Frame());
				arect.OffsetBy(-(arect.left - aview->Bounds().left - 10),0); // position button to left of window
				
				single_file_button = new BButton(arect,"openbutton","Show Image ", 
												new BMessage(OPEN_FILE_MSG),B_FOLLOW_LEFT|B_FOLLOW_BOTTOM);
				single_file_button->SetTarget(be_app); 
				single_file_button->SetEnabled(false);
				aview->AddChild(single_file_button);
			}
		}

		Window()->Unlock();
	}

	SetButtonLabel(B_DEFAULT_BUTTON,"Select Directory");
	Window()->SetTitle("Select an Image or a Directory with images");
}

//==========================================
ZFilePanel::~ZFilePanel(void)
{
}

//===========================================
// High-light open button when image selected
void ZFilePanel::SelectionChanged(void)
{
	status_t err;
	char *tstr = new char[B_MIME_TYPE_LENGTH];
	bool image_found=false;
	
	Rewind();
	err = GetNextSelectedRef(&zv_ref);
	if (err == B_OK) {
		BNode node(&zv_ref);
		if (!node.IsDirectory())
		{
			if((err = node.InitCheck())==B_OK)
			{
				BNodeInfo *ninfo = new BNodeInfo(&node);
				if((err = ninfo->InitCheck())==B_OK)
					if((err = ninfo->GetType(tstr))==B_OK)
						if(!strncmp(tstr,"image/",6))
							image_found = true;	
				delete ninfo;
			}
		}
	}	
	single_file_button->SetEnabled(image_found);
	delete tstr;
}

//==============================
void ZFilePanel::ImageSelected()
{
	BPath path(&zv_ref);
	
	delete_list();
	zv_listwindow->EmptyList();
	
	add_to_list(path.Path()); 
	zv_listwindow->AddItem(list_navigation->tail->bstring);
	list_navigation->position = list_navigation->head;
}	 