/*#############################################
  #  ASIM : Simulateur Apple ][               #
  #                            Header général #
  #############################################
*/

#include <SupportDefs.h>
#include <stdio.h>
#include <OS.h> 	//<KernelKit.h>
//----------------------------------------------------------
// CPU.CPP

extern thread_id ThreadCPU;

const int INTER_RESET=1;
const int INTER_IRQ  =2;
const int INTER_NMI  =4;

extern vuint8  GrA,GrX,GrY;	// Registers
extern vuint8  GrSP;
extern vuint16 GrPC;
extern vuint8  GrP;

extern volatile bool StopReq;	// Start/stop CPU
extern volatile bool StopAck;	// Handshake
extern volatile bool StopCPU;	// Final END

extern int64 SimCycles;	// Cycles simulation
extern int64 TimCycles; // Cycles temporisation
extern int   FasCycles; // Cycles intermédiaires
extern vint64 StartTime;
extern volatile bool LockCPU;

extern void InitCPU();
extern void InterCPU(int Type);
extern int SwitchCPU(bool State);
extern volatile bool StopCPU;
extern int32 CPUTask(void *);

//----------------------------------------------------------
// BUS.CPP
typedef void  (*TIOWriteFct)(uint8 ,uint8);
typedef uint8 (*TIOReadFct )(uint8 );
extern TIOWriteFct  IOWriteBase[16];
extern TIOReadFct  IOReadBase[16];
//------------------------------------------
extern uint8 MEM[];  // Mémoire
extern uint8 ROM[];  // Mémo. ROM
extern uint8 RAMLan[]; // Carte mémoire 16ko
extern vuint8 RefMem[]; // Mémorisation écriture

extern int IOLanPage; // Page mémoire
extern bool IOLanWrite;
extern bool IOLanRead;
extern bool IOLanWriteBis; // Kesako ?

extern uint8 Busr(uint16); // Lecture bus
extern uint8 Busw(uint16,uint8); // Ecriture bus
extern void InitBus();
extern void InitMem();

extern void SetPROM(int Slot,char *Data);
extern void SetROM(int Slot,char *Data);
extern void SetIOHooks(int Slot,TIOWriteFct WriteFct,TIOReadFct ReadFct);

extern int mouseX,mouseY,mouseB;

//----------------------------------------------------------
// KEYBOARD
extern volatile uint8 KeyCode; // Code clavier
extern void InitKeyboard(); // Config. clavier
extern int KeyPressed(const char* bytes, int32 numBytes); // Presse bouton

extern int mouseX,mouseY,mouseB; // Position souris

//----------------------------------------------------------
// GRAPHIC
const int DISPLAY_OFF=0;		// Unplugged
const int DISPLAY_WHITE=1;		// White monochrome
const int DISPLAY_GREEN=2;		// Green monochrome
const int DISPLAY_AMBER=3;		// Amber phosphorus
const int DISPLAY_COLOR=4;		// Standard colour display
const int DISPLAY_COLORLOW=5;	// Color with black dots on white backgrounds

extern volatile bool Graph_Text; // Text=false Graphic=true
extern volatile bool All_4Lines; // All =false 4Lines=true
extern volatile bool PageSwitch; // Page1=false Page2=true
extern volatile bool Lo_HiGraph; // LoRes=false HiRes=true

extern void GraphicModeUpdate();

extern void VideoUpdate();
extern void InitGraphic();
extern void ClearGraphic();
extern void InitDisplay();

//----------------------------------------------------------
// DISK
// dans disk.h

//----------------------------------------------------------
// SPEAKER
extern void InitSon(); // Config. speaker
extern void ClearSon(); // Libère speaker

extern void Speak();
extern void SpeakLoop(int64 SpkCycles);
//extern int Fech;

//----------------------------------------------------------
