/*#############################################
  #  ASIM : Simulateur Apple ][               #
  #                         Header classes Be #
  #############################################
*/

const int Gran=1;

//#include <AppKit.h>
#include "disk.h"
#include "config.h"


const int PULSE_RATE=10*1000; // 20ms=50Hz


/*++++++++++++++++++++++++++++++++++++++++++*/

extern BBitmap *bbEcran;
extern BView   *bvEcran;
extern BBitmap *bbChar;

/*++++++++++++++++++++++++++++++++++++++++++*/

#define msgConf	 'baco'
#define msgZoom  'bazo'
#define msgReset 'bare'
#define msgInit  'bain'

#define msgStop  'bast'
#define msgCont  'bati'

#define msgDump  'badu'
#define msgNoDump 'badp'

#define msgDisk1 'bad1'
#define msgDisk2 'bad2'
#define msgFileDisk 'bafd'
#define msgFileBar 'bafb'
#define msgRefresh 'bafr'

#define msgGel 'bage'
#define msgDegel 'bade'
#define msgFileGel 'bagf'
#define msgFileDegel 'badf'


/*++++++++++++++++++++++++++++++++++++++++++
  +  AsimApplication                       +
  ++++++++++++++++++++++++++++++++++++++++++*/
class AsimApplication : public BApplication
{
 public:
				AsimApplication(); // Construx
		void	AboutRequested();
		void	MessageReceived(BMessage *msg);
		void	RefsReceived(BMessage *msg);
};

/*++++++++++++++++++++++++++++++++++++++++++
  +  AsimView                              +
  ++++++++++++++++++++++++++++++++++++++++++*/
class AsimView : public BView
{
 public:
			AsimView(BRect frame,const char *name);
		void	KeyDown(const char* bytes, int32 numBytes);
		void	MouseDown(BPoint point);
		void	MouseMoved(BPoint point,uint32 transit,const BMessage *message);
		void	Draw(BRect brUp);
		void	Pulse();
};


/*++++++++++++++++++++++++++++++++++++++++++
  +  AboutWindow                           +
  ++++++++++++++++++++++++++++++++++++++++++*/
class AboutWindow : public BWindow
{
 public:
				AboutWindow();
		bool	QuitRequested();
 private:
	BTextView	*tvApropos;
	BButton     *btOK;
};

/*++++++++++++++++++++++++++++++++++++++++++
  +  AsimWindow                            +
  ++++++++++++++++++++++++++++++++++++++++++*/

class AsimWindow : public BWindow
{
 public:
				AsimWindow(); // construx
		bool	QuitRequested();
		void	MessageReceived(BMessage *msg);
	AsimView	*avAsim;
	DiskView	*dvDisk1,*dvDisk2;
	BButton		*bbConfig,*bbReset,*bbInit;
	BMenuBar	*mebAsim;
	BMenuItem	*meiDisk1,*meiDisk2;
 private:
		BView	*bvEcran;
};

extern BFilePanel *fpDisk;
extern BFilePanel *fpGel,*fpDegel;

extern AsimWindow *winAsim;
extern AboutWindow *winAbout;
extern ConfigWindow *winConfig;
