/*#############################################
  #  ASIM : Simulateur Apple ][               #
  #                                           #
  #                  BUS : Accès mémoire & IO # 
  #############################################
*/

#include "asim.h"
#include "asimbe.h"
#include <stdio.h>
#include <alloc.h>
#include <StorageKit.h>

extern bool Sniff;

// CONFIG VARIABLES ---------
bool JoyControl=false;	// false=Iteration true=Time
float JoyMaximum=256;

// MEMORY CORE --------------
uint8 MEM[64*1024];  // Mémoire
uint8 ROM[16*1024];  // Mémo. ROM
uint8 RAMLan[16*1024]; // Carte mémoire 16ko

//vuint8 RefMem[]; 
vuint8 RefMem[64*1024/Gran]; // Mémorisation écriture

// LANGAGE FLAGS ------------
int IOLanPage=0; // Page mémoire
bool IOLanWrite=true;
bool IOLanRead=true;
bool IOLanWriteBis=false; // Kesako ?

// --------------------------

int mouseX,mouseY,mouseB;


//############################################################## 

int CosmicNoise[1][32]={
	 { 0  ,0  ,48 ,0  ,32 ,32 ,0  ,32 ,32 ,0  ,51 ,0  ,127,32 ,0  ,0
	, 0  ,32 ,32 ,127,32 ,0  ,0  ,53 ,0  ,0  ,32 ,0  ,0  ,32 ,0  ,0 }};	// Joystick button
int Noise(int Type)
{
static int NoiseIdx=0;
 NoiseIdx=(NoiseIdx>32)?0:(NoiseIdx+1);
return CosmicNoise[Type][NoiseIdx];
}

//############################################################## 

//C000-Keyboard Data----------------------------------------
void  IOWrKbdData(uint8 A,uint8 V) { printf ("KBD:Write Data\n"); }
uint8 IORdKbdData(uint8 A) { return KeyCode; }

//C010-Keyboard Strobe--------------------------------------
void  IOWrKbdStrobe(uint8 A,uint8 V) { KeyCode&=127;   }
uint8 IORdKbdStrobe(uint8 A) {  KeyCode&=127; return 0; }

//C020-Tape output toggle-----------------------------------
void IOWrTape(uint8 A,uint8 V) { } 
uint8 IORdTape(uint8 A)         { return 0; }

//C030-Speaker toggle---------------------------------------


uint8 IORdSpeaker(uint8 A)
{
 Speak();
}
void IOWrSpeaker(uint8 A,uint8 V) 
{
 //IORdSpeaker(A);
/* printf ("SPK:Beep\n");*/
// Ecriture : Double bascule : ne fait rien !
}

//C040-Utility strobe---------------------------------------
void IOWrUtility(uint8 A,uint8 V) { } 
uint8 IORdUtility(uint8 A)         { return 0; }

//C050-Graphic mode & game annunciators---------------------
void IOGraphic(uint8 A)
{
 switch (A) {
	case 0x50: Graph_Text=true;  //printf ("IOG:Graph mode\n");
		break;
	case 0x51: Graph_Text=false; //printf ("IOG:Text mode\n");
		break;
	case 0x52:
		All_4Lines=false; //printf ("IOG:Uniforme\n");
		if (Graph_Text) { // Supprime 4 lignes, invalidate graph
			int I;
			int D=PageSwitch?(0x4000/Gran):(0x2000/Gran);
			for (I=0;I<8;I++) {
				memset((void *)&RefMem[D+0x250],1,40/Gran);
				memset((void *)&RefMem[D+0x2D0],1,40/Gran);
				memset((void *)&RefMem[D+0x350],1,40/Gran);
				memset((void *)&RefMem[D+0x3D0],1,40/Gran);
				D+=0x400/Gran;
				}
			}
		return;
	case 0x53:
		All_4Lines=true;  //printf ("IOG:4Lignes\n");
		if (Graph_Text) { // Insère 4 lignes, invalidate text
			int D=PageSwitch?(0x800/Gran):(0x400/Gran);
			memset(&RefMem[D+0x250],1,40/Gran);
			memset(&RefMem[D+0x2D0],1,40/Gran);
			memset(&RefMem[D+0x350],1,40/Gran);
			memset(&RefMem[D+0x3D0],1,40/Gran);
			}
		return;	
	case 0x54: PageSwitch=false; //printf ("IOG:Page 1\n");
		break; 
	case 0x55: PageSwitch=true;  //printf ("IOG:Page 2\n");
		break;
	case 0x56: Lo_HiGraph=false; //printf ("IOG:Lo res\n");
		break;
	case 0x57: Lo_HiGraph=true;  //printf ("IOG:Hi res\n");
		break;
 	}
 GraphicModeUpdate();
}
void IOWrGraphic(uint8 A,uint8 V) { IOGraphic(A); } 
uint8 IORdGraphic(uint8 A)         { IOGraphic(A); return 0; }

//C060------------------------------------------------------
int64 JoyCycle;
int Xaz,Yaz;
void IOWrTapeGame(uint8 A,uint8 V) {} // C060

uint8 IORdTapeGame(uint8 A)
{
 int64 Cycle;
 A&=15;
 switch (A) {
 	case 0:	break; // cassette IN
 	case 1:	return ((mouseB&1)?128:0)+Noise(0); // Joystick Bouton 1
 	case 2:	return ((mouseB&2)?128:0)+Noise(0); // Joystick Bouton 2
 	case 3:	return ((mouseB&4)?128:0)+Noise(0); // Joystick Bouton 3
 	case 4:	if (!JoyControl) {
		Xaz++;		
		if (Xaz>(mouseX/280.0*JoyMaximum)) return 0; else return 128;
	  }else{
		Cycle=(float)mouseX*JoyMaximum/280.0;
		if ((SimCycles+FasCycles-JoyCycle)>Cycle) return 0; else return 128;
		}
 	case 5:	if (!JoyControl) {
		Yaz++;
		if (Yaz>(mouseY/192.0*JoyMaximum)) return 0; else return 128;
	  }else{
		Cycle=(float)mouseY*JoyMaximum/192.0; 
		if ((SimCycles+FasCycles-JoyCycle)>Cycle) return 0; else return 128;
		}
	default: printf ("Read TapeGame :%i\n",(int)A);
	}
 return 0;
}

//C070------------------------------------------------------
void IOWrGameStrobe(uint8 A,uint8 V) // C070
{
 JoyCycle=SimCycles+FasCycles;
 Xaz=Yaz=0;
} 

uint8 IORdGameStrobe(uint8 A)
{
 JoyCycle=SimCycles+FasCycles;
 Xaz=Yaz=0;
 return 0;
}

//C080-Carte langage 16ko ----------------------------------

//----------------------------
void CommuteIn(int Page) // Noread -> read
{
 int I;
 for (I=0;I<0x1000;I++) MEM[0xD000+I]=RAMLan[(Page?0x1000:0)+I];
 for (I=0;I<0x2000;I++) MEM[0xE000+I]=RAMLan[0x2000+I];
}
//----------------------------
void CommuteOut(int Page) // Read -> noread
{
 int I;
 for (I=0;I<0x1000;I++) RAMLan[(Page?0x1000:0)+I]=MEM[0xD000+I];
 for (I=0;I<0x2000;I++) RAMLan[0x2000+I]=MEM[0xE000+I];
 for (I=0;I<0x3000;I++) MEM[0xD000+I]=ROM[0x1000+I];
}
//----------------------------
void CommutePage(int Page) // change page lue : parm=page à archiver
{
 int I;
 for (I=0;I<0x1000;I++) RAMLan[((Page)?0x1000:0)+I]=MEM[0xD000+I]; // Lourde
 for (I=0;I<0x1000;I++) MEM[0xD000+I]=RAMLan[((Page)?0:0x1000)+I]; // récup
}
//----------------------------
void IOLan(uint8 A)
{
 int NeoPage=(A&8)?1:0;
 switch(A&3) {
 	case 0:  // Bank 0   read nowrite
 		if (!IOLanRead) CommuteIn(NeoPage);
			else if (IOLanPage!=NeoPage) CommutePage(IOLanPage);
		IOLanRead =true;
		IOLanWrite=false;
		IOLanWriteBis=false;
 		break;
 	case 1:  // Bank 0 noread   write
		if (IOLanRead) CommuteOut(IOLanPage);
 		IOLanRead =false;
		if (IOLanWriteBis) {
 			IOLanWrite=true;
			}
		IOLanWriteBis=true;
 		break;
 	case 2:  // Bank 0 noread nowrite
		if (IOLanRead) CommuteOut(IOLanPage);
 		IOLanRead =false;
		IOLanWrite=false;
		IOLanWriteBis=false;
 		break;
 	case 3:  // Bank 0   read   write
		if (!IOLanRead) CommuteIn(NeoPage);
			else if (IOLanPage!=NeoPage) CommutePage(IOLanPage);
		IOLanRead =true;
		if (IOLanWriteBis) {
 			IOLanWrite=true;
			}	
		IOLanWriteBis=true;
 		break;
	}
 IOLanPage=NeoPage;	
}
//----------------------------
void IOWrLan(uint8 A,uint8 V) {
	IOLan(A); } 

uint8 IORdLan(uint8 A) {
	IOLan(A); return 0x80; }

//C090>C0FF-------------------------------------------------
void IOWrTbd(uint8 A,uint8 V) { /*printf (" ACCES Write TBD !!! %X\n",(int)A); */} 
uint8 IORdTbd(uint8 A)         { /*printf (" ACCES Read TBD !!! %X\n",(int)A); */return 0; }


//############################################################## 

TIOWriteFct  IOWriteBase[16]={
		IOWrKbdData     ,IOWrKbdStrobe   ,IOWrTape        ,IOWrSpeaker     ,
		IOWrUtility     ,IOWrGraphic     ,IOWrTapeGame    ,IOWrGameStrobe  ,
		IOWrLan         ,IOWrTbd         ,IOWrTbd         ,IOWrTbd         ,
		IOWrTbd         ,IOWrTbd         ,IOWrTbd         ,IOWrTbd         };

TIOReadFct  IOReadBase[16]={
		IORdKbdData     ,IORdKbdStrobe   ,IORdTape        ,IORdSpeaker     ,
		IORdUtility     ,IORdGraphic     ,IORdTapeGame    ,IORdGameStrobe  ,
		IORdLan         ,IORdTbd         ,IORdTbd         ,IORdTbd         ,
		IORdTbd         ,IORdTbd         ,IORdTbd         ,IORdTbd         };



//############################################################## 
// Lecture bus
uint8 Busr(uint16 A)
{
 int V;
 if (A<0xC000) return MEM[A];
 if (A>=0xC100) return MEM[A];
 V=IOReadBase[(A-0xC000)/16](A-0xC000);
 
 return V;
}

// Ecriture bus
uint8 Busw(uint16 A,uint8 V)
{
 
 RefMem[A/Gran]|=1;
 if (A<0xC000) { MEM[A]=V; return V; }
 if ((A>=0xD000)&&IOLanWrite) {
 	if (IOLanRead) MEM[A]=V;
	else { if (A>=0xE000) RAMLan[A-0xC000]=V;
 					else RAMLan[A&0x0FFF+(IOLanPage?0x1000:0)]=V;
 		}
 	return V;
 	}
 if (A>=0xC100) return V;

 IOWriteBase[(A-0xC000)/16](A-0xC000,V);
 return V;
}
//------------------------------------------------------
void InitMem()
{
 int I;
 for (I=0;I<48*1024;I++) MEM[I]=0;
 for (I=0;I<16*1024;I++) MEM[I+0xC000]=ROM[I];
 IOLanPage=0;
 IOLanWrite=true;
 IOLanRead =false;
}

void InitBus()
{
 app_info appInfo;
 be_app->GetAppInfo(&appInfo);
 entry_ref AsimRef = appInfo.ref;
 AsimRef.set_name(".");
 BDirectory exeDir(&AsimRef);
 BPath AsimPath(&exeDir, "Apple2.rom");
 const char *FF = AsimPath.Path();

 FILE *FIN;
 FIN=fopen(FF,"rb");

 fread(ROM,1,4*1024,FIN);
 fread(&ROM[0],1,16*1024,FIN);
 InitMem();
 fclose(FIN); 
}

void SetPROM(int Slot,char *Data)
{
 int I;
 if ((Slot>0)&&(Slot<8)) {
 	for (I=0;I<256;I++) MEM[0xC000+Slot*256+I]=ROM[Slot*256+I]=Data[I];
	}
}

void SetROM(int Slot,char *Data)
{
 // No sé
}

void SetIOHooks(int Slot,TIOWriteFct WriteFct,TIOReadFct ReadFct)
{
 IOWriteBase[Slot+8]=WriteFct;
 IOReadBase [Slot+8]=ReadFct;
}


