/*#############################################
  #  ASIM : Simulateur Apple ][               #
  #                                           #
  #                              Haut-parleur # 
  #############################################
*/
#include "asim.h"
#include "config.h"
#include <MediaKit.h>

const int SURECH=8;	// Suréchantillonnage (puissance de 2)
const int FILTRE=4; // Filtrage moyenneur
const float FREQSON=44100.0; // Fréquence échantillonnage

float SpkTps=0;	// Temporisation relative speaker, en ms

uint8 SpkSon[16*1024];			// Buffer son
uint8 SpkTur[2*SURECH*1024];	// Buffer suréchantillonnage
uint8 SpkBuf[16];				// Remplissure buffers
int SpkNBC=0;					// 0-15 : Buffer courant écriture
float SpkPer=1024.0*1000.0/FREQSON;			// Période bloc de 1024 échs. en ms v.i. = 23.220
float SpkPerMin=1024*1000.0/FREQSON*0.995;	// 23.150;
float SpkPerMax=1024*1000.0/FREQSON*1.005;	// 23.300;

float Filter[40];	// Filter op.

BSoundPlayer *Ophi; // Ophicléide

media_raw_audio_format MRAF;

bool SpkTog=false;	// Toggle speaker.
int	 Nob=0;			// Buffer courant lecture


bool Musica=false; // ¿ Vamos a oír música ?
//------------------------------------------
// Appel IO Speaker
void  Speak()
{
 if (!Musica) return;
 /*printf ("SPK:Beep\n");*/
 float Tps=SpkTps+(float)FasCycles/(float)Speed; // Instant relatif, µs
 int64 NE=(float)Tps*(float)(1024.0*SURECH)/(float)SpkPer+0.5;
 int X=NE&(1024*2*SURECH-1);	// Pos. tableau
 SpkTur[X]++;				// Surmodulation ???
 return 0;
}

//------------------------------------------
// Test bouclage
void SpeakLoop(int64 SpkCycles)
{
 if (!Musica) return;
 SpkTps+=(float)SpkCycles/(float)Speed;
 if (SpkTps<SpkPer) return;
 SpkTps-=SpkPer;
 for (int I=0;I<1024;I++) {
	int S=0;
	for (int J=0;J<SURECH;J++) {
		if (SpkTur[I*SURECH+J]&1) SpkTog=!SpkTog;
		S+=SpkTog?1:0;
		}
	SpkSon[I+SpkNBC*1024]=S;
	}
 for (int I=0;I<1024*SURECH;I++) { SpkTur[I]=SpkTur[I+1024*SURECH]; SpkTur[I+1024*SURECH]=0; }
 //for (int I=0;I<1024;I++) SpkSon[I+SpkNBC*1024]=((I/32)&1); // Purity
 SpkBuf[SpkNBC]=1;
 SpkNBC=(SpkNBC+1)&15;
 int NBP=	SpkBuf[ 0]+SpkBuf[ 1]+SpkBuf[ 2]+SpkBuf[ 3]+SpkBuf[ 4]+SpkBuf[ 5]+SpkBuf[ 6]+SpkBuf[ 7]+
			SpkBuf[ 8]+SpkBuf[ 9]+SpkBuf[10]+SpkBuf[11]+SpkBuf[12]+SpkBuf[13]+SpkBuf[14]+SpkBuf[15];
 if (NBP<7) { SpkPer=(SpkPer>SpkPerMin)?(SpkPer-0.001):SpkPer;/* printf ("-%i %i\n",(int)(SpkPer*1000),(int)NBP);*/ }
 if (NBP>8) { SpkPer=(SpkPer<SpkPerMax)?(SpkPer+0.001):SpkPer;/* printf ("+%i %i\n",(int)(SpkPer*1000),(int)NBP);*/ }
}

//##############################################################
//##############################################################

//------------------------------------------
// Callback
void BufferProc(void *Cookie, void *Buffer,size_t Size,const media_raw_audio_format &Format)
{
 size_t I,J,K;
 float *Buf = (float *)Buffer;
 float T;
 float But[1100];
 Size/=sizeof (float);
 uint32 CC=Format.channel_count;
 if (Format.format != media_raw_audio_format::B_AUDIO_FLOAT) return;

 for (I=0;I<1024;I++) {
	T=SpkSon[I+Nob*1024]-(float)(SURECH)/2.0;
	But[I+FILTRE] =T/(float)(SURECH);
	}
 for (I=0;I<FILTRE;I++) But[I]=Filter[I];
 for (I=0;I<FILTRE;I++) Filter[I]=But[I+1024];

 float F=0;
 for (I=0;I<FILTRE;I++) F+=But[I];
 for (I=0;I<1024;I++) {
 	Buf[I]=F/FILTRE;
 	F=F+But[I+FILTRE]-But[I];
	}
 if (SpkBuf[Nob]) {
 	SpkBuf[Nob]=0;
 	Nob=(Nob+1)&15;
	} else { for (I=0;I<1024;I++) Buf[I]=0;/* printf ("Déverouillé\n");*/ }
}
//------------------------------------------

void InitSon()
{
 Musica=false;
 MRAF.format=media_raw_audio_format::B_AUDIO_FLOAT;
 MRAF.frame_rate=FREQSON;
 MRAF.channel_count=1;
 MRAF.byte_order=B_MEDIA_LITTLE_ENDIAN;
 MRAF.buffer_size=1024*sizeof(float);  // Octets ?
 Ophi=new BSoundPlayer(&MRAF,(const char *)"Ophicléide",BufferProc,NULL);
 status_t stat=Ophi->InitCheck();
 if (stat!=B_OK) {
 	delete Ophi;
 	BAlert *baAlert = new BAlert("Speaker", "I can't play sound !","Too bad","",""
 								,B_WIDTH_AS_USUAL, B_OFFSET_SPACING, B_WARNING_ALERT);
	baAlert->SetShortcut(0, B_ESCAPE);
	baAlert->Go();
	delete baAlert;
	return;
	}
 Ophi->Start();
 Ophi->SetHasData(true);
 Musica=true;
}

//------------------------------------------
void ClearSon()
{
 Ophi->Stop();
 delete Ophi;
}

