/*#############################################
  #  ASIM : Simulateur Apple ][               #
  #                  Panneau de configuration #
  #############################################
*/

#include <StorageKit.h>
#include "asimbe.h"
#include "asim.h"

ConfigWindow *winConfig;

//----------------------------------------
int MagicSpeed(int V) // Pseudo exp
{
 if (V<20) return (int) (V*500.0/20.0+1);
 if (V<40) return (int) (V*500.0/20.0);
 if (V<60) return (int) ((V-20)*1000.0/20.0);
 if (V<80) return (int) ((V-40)*2000.0/20.0);
 if (V<=100) return (int) ((V-60)*4000.0/20.0);
 return 1000;
}

int InvMagicSpeed(int V) // Pseudo log
{
 if (V<500) return (int) (V*20.0/500.0);
 if (V<1000) return (int) (V*20.0/500.0);
 if (V<2000) return (int) ((V+1000)*20.0/1000.0);
 if (V<4000) return (int) ((V+4000)*20.0/2000.0);
 if (V<=8000) return (int) ((V+12000)*20.0/4000.0);
 return 50;
}

/*++++++++++++++++++++++++++++++++++++++++++
  +  ConfigWindow                           +
  ++++++++++++++++++++++++++++++++++++++++++*/
ConfigWindow::ConfigWindow() : BWindow(BRect(0,0,0,0), "Configuration"
                                    ,B_TITLED_WINDOW,B_NOT_RESIZABLE | B_NOT_ZOOMABLE) 
{
 BRect r;
 Lock();
 const float width = 400,height=250;
 r = BScreen(be_app->WindowAt(0)).Frame();
 MoveTo(BPoint((r.Width()-width)/2,(r.Height()-height)/2));
 ResizeTo(width,height);
 bbSub=new BBox(Bounds(),"Substrat",B_FOLLOW_NONE,B_WILL_DRAW|B_NAVIGABLE_JUMP,B_NO_BORDER);
 bbSub->SetViewColor(216,216,216,0);
 
 r=Bounds();
 r.InsetBy(5,5);
 r.bottom-=30; 

 tvTab = new BTabView(r,"Config tabs",B_WIDTH_FROM_LABEL,B_FOLLOW_NONE,B_WILL_DRAW | B_NAVIGABLE); 
 tvTab->SetViewColor(216,216,216,0); 
 r=tvTab->Bounds();
 r.InsetBy(5,5); 
 r.bottom -= tvTab->TabHeight(); 
 vCPU=new CPUConfigView(r);
 tvTab->AddTab(vCPU);
 vVideo=new VideoConfigView(r);
 tvTab->AddTab(vVideo);
 vDisk=new DiskConfigView(r);
 tvTab->AddTab(vDisk);

 bbSub->AddChild(tvTab);
// tvTab->SetTabWidth(B_WIDTH_FROM_WIDEST);
 
 btOK=new BButton(BRect(170,220,230,240),"Bouton","OK",new BMessage(B_QUIT_REQUESTED));
 bbSub->AddChild(btOK);// btOK->MakeDefault(true);
 AddChild(bbSub);
 Unlock();
}
//-----------------------
bool ConfigWindow::QuitRequested()
{
 winConfig=NULL;
 return(true);
}
//-----------------------
void ConfigWindow::MessageReceived(BMessage *msg)
{
 switch (msg->what) {
	// CPU -----------------------------------
	case msgCPUSlide: {
		int32 V=msg->FindInt32("be:value");
		if (ThreadCPU) suspend_thread(ThreadCPU);
		Speed=MagicSpeed(V); LoopCycles=Speed*2;
		StartTime=real_time_clock_usecs()/1000-TimCycles/Speed;
		if (ThreadCPU) resume_thread(ThreadCPU);
		} break;
	case msgCPUType:
		CMOS=(msg->FindInt32("be:value"));
		break;
		
	// Display -------------------------------		
	case msgDisplay:
		DisplayModel=msg->FindInt16("Model");
		vVideo->VideoDisplay(true);
		break;
		
	// Disk ----------------------------------
	case msgDiskTurbo:
		TurboDisk=(msg->FindInt32("be:value"));
		break;
	case msgDiskCycle:
		CycleDisk=(msg->FindInt32("be:value"));
		break;
	case msgDiskSkewDOS:
		SectorSkew=SKEW_DOS;
		break;
	case msgDiskSkewPRODOS:
		SectorSkew=SKEW_PRODOS;
		break;
	case msgJoyTime: {
		JoyControl=true;
		JoyMaximum=3060;
		char Tex[50];
		sprintf (Tex,"%i",(int)JoyMaximum);
		vVideo->tcJoyMaxi->SetText(Tex);
		} break;
 	case msgJoyIter: {
 		JoyControl=false;
 		JoyMaximum=256;
		char Tex[50];
		sprintf (Tex,"%i",(int)JoyMaximum);
		vVideo->tcJoyMaxi->SetText(Tex);
		} break;
	case msgJoyMaxi: {
		char Tex[50];
		int I;
		sscanf(vVideo->tcJoyMaxi->Text(),"%i",&I);
		JoyMaximum=I;
		} break;
	default:
 		BWindow::MessageReceived(msg);
		}
}
/*++++++++++++++++++++++++++++++++++++++++++
  +  CPUConfigView                         +
  ++++++++++++++++++++++++++++++++++++++++++*/
SpeedSlider::SpeedSlider(BRect frame, char *label,BMessage *msg, int32 min, int32 max)
			: BSlider(frame,"CPU Speed",label,msg, min, max)
{ 
 if (Value()<40) sprintf (Text,"Speed=%6.0f kHz",(float)MagicSpeed(Value()));
			else sprintf (Text,"Speed=%6.2f MHz",(float)(MagicSpeed(Value())/1000.0));
}
//-----------------------
char* SpeedSlider::UpdateText() const
{ 
 Window()->Lock();
 if (Value()<40) sprintf ((char *)Text,"Speed=%6.0f kHz",(float)MagicSpeed(Value()));
			else sprintf ((char *)Text,"Speed=%6.2f MHz",(float)(MagicSpeed(Value())/1000.0));
 
 Window()->Unlock();
 return (char *)Text;
}
//-----------------------
CPUConfigView::CPUConfigView(BRect frame) : BView(frame,"CPU",B_FOLLOW_NONE,B_WILL_DRAW)
{
 const rgb_color kSlideColor = {0,100,100,255};
 const rgb_color kSlideFill  = {50,200,150,255};

 SetViewColor(216,216,216,0);
 bsSpeed = new SpeedSlider(BRect(10,110,260,130), "CPU Speed (MHz)", new BMessage(msgCPUSlide),0,100);
 bsSpeed->SetBarColor(kSlideColor);
 bsSpeed->UseFillColor(true,&kSlideFill);
 bsSpeed->ResizeToPreferred();
 bsSpeed->SetHashMarks(B_HASH_MARKS_BOTTOM); 
 bsSpeed->SetHashMarkCount(6);
 bsSpeed->SetPosition((float)InvMagicSpeed(Speed)/100.0);
 bsSpeed->SetLimitLabels("1khz", "8MHz");
 AddChild(bsSpeed);

 cbType=new BCheckBox(BRect(20,40,150,60),"CPU:Model","65C02 processor",new BMessage(msgCPUType));
 cbType->SetValue(CMOS);
 AddChild(cbType);

}

/*++++++++++++++++++++++++++++++++++++++++++
  +  VideoConfigView                       +
  ++++++++++++++++++++++++++++++++++++++++++*/
VideoConfigView::VideoConfigView(BRect frame): BView(frame,"Video/Joystick",B_FOLLOW_NONE,B_WILL_DRAW)
{
 SetViewColor(216,216,216,0);

 BMessage *msg;
 meMenu=new BMenu("Color");

 meMenu->AddItem(meDisColor=new BMenu("Color")); 
   msg=new BMessage(msgDisplay); msg->AddInt16("Model",DISPLAY_COLOR);
  meDisColor->AddItem(miDisColor   =new BMenuItem("Standard",msg)); miDisColor->SetMarked(true);
   msg=new BMessage(msgDisplay); msg->AddInt16("Model",DISPLAY_COLORLOW);
  meDisColor->AddItem(miDisColorlow=new BMenuItem("Modified",msg));

 meMenu->AddItem(meDisMono=new BMenu("Monochrome")); 
   msg=new BMessage(msgDisplay); msg->AddInt16("Model",DISPLAY_WHITE);
  meDisMono->AddItem(miDisWhite=new BMenuItem("White",msg));
   msg=new BMessage(msgDisplay); msg->AddInt16("Model",DISPLAY_GREEN); 
  meDisMono->AddItem(miDisGreen=new BMenuItem("Green",msg));
   msg=new BMessage(msgDisplay); msg->AddInt16("Model",DISPLAY_AMBER); 
  meDisMono->AddItem(miDisAmber=new BMenuItem("Amber",msg));

 mfField= new BMenuField(BRect(40,40,250,60),"Display","Display:",meMenu); 
 mfField->SetDivider(50);

 VideoDisplay(false);

 rbJoyTime =new BRadioButton(BRect(20,100,150,120),"Joystick:Time Controlled","Joystick :Time measurement",new BMessage(msgJoyTime));
 AddChild(rbJoyTime);
 rbJoyTime->ResizeToPreferred();
 
 rbJoyValue=new BRadioButton(BRect(20,130,150,150),"Joystick:Iteration","Joystick :Iteration",new BMessage(msgJoyIter));
 AddChild(rbJoyValue);
 rbJoyValue->ResizeToPreferred();
 
 tcJoyMaxi=new BTextControl(BRect(200,110,250,140),"Joystick:Maximum:","Maximum:","12345",new BMessage(msgJoyMaxi));
 AddChild(tcJoyMaxi);
 tcJoyMaxi->ResizeToPreferred();
 
if (JoyControl) {
	char Tex[50];
	rbJoyTime->SetValue(true);
	sprintf (Tex,"%i",(int)JoyMaximum);
	tcJoyMaxi->SetText(Tex);
	}
  else {
	char Tex[50];
	rbJoyValue->SetValue(true);
	sprintf (Tex,"%i",(int)JoyMaximum);
	tcJoyMaxi->SetText(Tex);
	}
// meMenu->ResizeToPreferred();
 mfField->ResizeToPreferred();
 AddChild(mfField);
}

/*++++++++++++++++++++++++++++++++++++++++++
  +  DiskConfigView                        +
  ++++++++++++++++++++++++++++++++++++++++++*/
DiskConfigView::DiskConfigView(BRect frame): BView(frame,"Disk",B_FOLLOW_NONE,B_WILL_DRAW)
{
 SetViewColor(216,216,216,0);

 cbTurbo=new BCheckBox(BRect(20,10,150,30),"Disk:Turbo","Turbodisk",new BMessage(msgDiskTurbo));
 AddChild(cbTurbo);
 cbTurbo->SetValue(TurboDisk);
 cbCycle=new BCheckBox(BRect(20,40,150,60),"Disk:Tempo","Cycle count regulation",new BMessage(msgDiskCycle));
 AddChild(cbCycle);

 cbCycle->SetValue(CycleDisk);

 rbSkewDOS=new BRadioButton(BRect(20,70,150,90),"Disk:DosSkew","DOS sector interleaving",new BMessage(msgDiskSkewDOS));
 AddChild(rbSkewDOS);
 rbSkewPRODOS=new BRadioButton(BRect(20,100,150,120),"Disk:ProDosSkew","PRODOS sector interleaving",new BMessage(msgDiskSkewPRODOS));
 AddChild(rbSkewPRODOS);

 if (SectorSkew==SKEW_DOS) rbSkewDOS->SetValue(true);
 					else   rbSkewPRODOS->SetValue(true);
}

//-------------------------
void VideoConfigView::VideoDisplay(bool Update)
{
if (Update) Window()->Lock(); 
 miDisColor   ->SetMarked((DisplayModel==DISPLAY_COLOR));
 miDisColorlow->SetMarked((DisplayModel==DISPLAY_COLORLOW));
 miDisWhite   ->SetMarked((DisplayModel==DISPLAY_WHITE));
 miDisGreen   ->SetMarked((DisplayModel==DISPLAY_GREEN));
 miDisAmber   ->SetMarked((DisplayModel==DISPLAY_AMBER));
 char *Tex;
 switch (DisplayModel) {
 	case DISPLAY_COLOR:		Tex="Color"; break;
	case DISPLAY_COLORLOW:	Tex="Color modified"; break;
	case DISPLAY_WHITE:		Tex="White monochrome"; break;
	case DISPLAY_GREEN:		Tex="Green monochrome"; break;
	case DISPLAY_AMBER:		Tex="Amber monochrome"; break;
	case DISPLAY_OFF:		Tex="Implosed TV"; break;
 	}
 meMenu->Superitem()->SetLabel(Tex);
 
 if (Update) {
	InitDisplay();
	GraphicModeUpdate();
	Window()->Unlock();
	}
}

//###############################################################

int SaveConfig()
{
 BPath Path;
 find_directory (B_USER_SETTINGS_DIRECTORY, &Path);
 Path.Append("EmulatorAppleII_settings");
// printf ("<SaveConfig>%s\n",Path.Path());

 BFile File(Path.Path(),B_WRITE_ONLY|B_CREATE_FILE);
 if (File.InitCheck()!=B_NO_ERROR) {
	printf ("ERREUR SAVE CONFIG\n");
	return 1; }

 File.Write(&Speed,sizeof(Speed));
 File.Write(&CMOS,sizeof(CMOS));
 File.Write(&DisplayModel,sizeof(DisplayModel));
 File.Write(&TurboDisk,sizeof(TurboDisk));
 File.Write(&JoyControl,sizeof(bool));
 File.Write(&JoyMaximum,sizeof(float));
 printf ("Speed=%i\n",(int)Speed);
 return 0;
}
//------------------------------------------
int LoadConfig()
{
 BPath Path;
 off_t Size;
 find_directory (B_USER_SETTINGS_DIRECTORY, &Path);
 Path.Append("EmulatorAppleII_settings");
// printf ("<LoadConfig>\n");

 BFile File(Path.Path(),B_READ_ONLY);
 if (File.InitCheck()!=B_NO_ERROR) {
	printf ("ERREUR LOAD CONFIG\n");
	return 1; }

 File.GetSize(&Size); 
// if (Size!=9) return 1;

 File.Read(&Speed,sizeof(Speed));	LoopCycles=Speed*2;
 File.Read(&CMOS,sizeof(CMOS)); 
 File.Read(&DisplayModel,sizeof(DisplayModel));
 File.Read(&TurboDisk,sizeof(TurboDisk));
 File.Read(&JoyControl,sizeof(bool));
 File.Read(&JoyMaximum,sizeof(float));

 return 0;
}

//###############################################################
const char *GelPrologue="BeOS Apple][ emulator frozen session 0.1.0\n";

int WriteInt8 (BFile *Fil,uint8  T) { return Fil->Write(&T,1); }
int ReadInt8  (BFile *Fil,uint8 *pT) { return Fil->Read(pT,1);  }
int WriteInt16(BFile *Fil,uint16 T) {
	uint8 C;
	C=T&255; Fil->Write(&C,1);
	C=(T>>8)&255; Fil->Write(&C,1);
	return 0;
	}
int ReadInt16 (BFile *Fil,uint16 *pT) {
	uint8 C;
	Fil->Read(&C,1); *pT=C;
	Fil->Read(&C,1); *pT|=C<<8;
	return 0;
	}
int WriteInt32(BFile *Fil,uint32 T) {
	uint8 C;
	C=T&255; Fil->Write(&C,1);
	C=(T>>8)&255; Fil->Write(&C,1);
	C=(T>>16)&255; Fil->Write(&C,1);
	C=(T>>24)&255; Fil->Write(&C,1);
	return 0;
	}
int ReadInt32 (BFile *Fil,uint32 *pT) {
	uint8 C;
	Fil->Read(&C,1); *pT=C;
	Fil->Read(&C,1); *pT|=C<<8;
	Fil->Read(&C,1); *pT|=C<<16;
	Fil->Read(&C,1); *pT|=C<<24;
	return 0;
	}
int WriteInt64(BFile *Fil,uint64 T) {
	uint8 C,I;
	for (I=0;I<8;I++) {
		C=T&255; T>>=8;
		Fil->Write(&C,1);
		}
	return 0;
	}

int ReadInt64(BFile *Fil,uint64 *pT) {
	uint8 C,I;
	*pT=0;
	for (I=0;I<8;I++) {
		Fil->Read(&C,1);
		*pT|=C<<(I*8);
		}
	return 0;
	}

int WriteInt32At(BFile *Fil,off_t AT,uint32 T) {
	uint8 C;
	C=T&255; Fil->WriteAt(AT,&C,1);
	C=(T>>8)&255; Fil->WriteAt(AT+1,&C,1);
	C=(T>>16)&255; Fil->WriteAt(AT+2,&C,1);
	C=(T>>24)&255; Fil->WriteAt(AT+3,&C,1);
	return 0;
	}

int WriteString(BFile *Fil,char *Str) {
	int Lgt=strlen(Str);
	char Z=0;
	Fil->Write(Str,Lgt+1);
	return 0;
	}

int ReadString(BFile *Fil,char *Str,int LgtMax) {
	char C;
	int I;
	I=0;
	do {
		Fil->Read(&C,1);
		if (I<LgtMax) Str[I]=C;
		I++;
		} while (C);
	return 0;
	}


//##########################################
int GelDiskDrive(BFile *Fil,SDrive *Drive)
{
 int I;
 WriteInt8(Fil,Drive->No);							//  	int		No;					// No Drive ?!?
 WriteInt8(Fil,(Drive->PH0) | (Drive->PH1>>1)
			| (Drive->PH2>>2) | (Drive->PH3>>2));	// 	bool	PH0,PH1,PH2,PH3;	// Stepper motor phases
 // Disk II interface
 WriteInt16(Fil,Drive->HeadTrack);					//	int		HeadTrack;			// Head position
 WriteInt8 (Fil,Drive->HeadPhase);					//	int		HeadPhase;			// Stepping motor phase 
 WriteInt8 (Fil,Drive->MotorON);					//	bool	MotorON;			// Spinning motor
 WriteInt8 (Fil,Drive->WriteProtect);				//	bool	WriteProtect;		// Guess ...
 WriteInt8 (Fil,Drive->LatchInOut);				//	bool	LatchInOut;			// DISK II Latch register direction false=input
 WriteInt8 (Fil,Drive->Latch);						//	uint8	Latch;				// Data latch
 WriteInt32(Fil,Drive->Turn);						//	int		Turn;				// Disk position index
 // Disquette
 WriteInt8 (Fil,Drive->ImageType);					//	int		ImageType;			// Disk image type :0=None 1=DSK 2=NIB
 WriteInt8 (Fil,Drive->MaxTrack);					//	int		MaxTrack;			// Number of tracks of the image file
 WriteInt32(Fil,Drive->TrackLen);					//	int		TrackLen;			// Number of bytes per track
 WriteInt8(Fil,Drive->Image?255:0);		// !!!!	//	uint8*	Image;				// Disk nibble image
 WriteInt8 (Fil,Drive->Skew);						//	int		Skew;				// 0=DOS 1=PRODOS 2=??

 // Disk images files
 WriteInt16(Fil,Drive->NbImages);								//	int		NbImages;
 //	BPath	**PathList;			// List of associated file paths
 WriteInt16(Fil,Drive->NoImage);								//	int		NoImage;			// Numéro image
 WriteInt8 (Fil,Drive->UpdateFile);								//	bool	UpdateFile;			// Image file has to be written back

 if (Drive->Image) {
	int Size=Drive->MaxTrack*Drive->TrackLen;
	WriteInt32(Fil,Size);
	Fil->Write(Drive->Image,Size);
	}
	
 for (I=0;I<Drive->NbImages;I++) {
	int32 Size;
	Size=strlen(Drive->PathList[I]->Path())+1;
	//printf ("path=%s L=%i\n",Drive->PathList[I]->Path(),Size);
 	WriteInt32(Fil,Size);
 	Fil->Write(Drive->PathList[I]->Path(),Size);
 	}
}

//##########################################
int DegelDiskDrive(BFile *Fil,SDrive *Drive)
{
 int I;
 uint8 T8;
 uint16 T16;
 uint32 T32;
 ReadInt8(Fil,&T8); Drive->No=T8;
 uint8 Phase;
 ReadInt8(Fil,&Phase);
 Drive->PH0=Phase&1;
 Drive->PH1=(Phase>>1)&1;
 Drive->PH2=(Phase>>2)&1;
 Drive->PH3=(Phase>>3)&1;
 ReadInt16(Fil,&T16); Drive->HeadTrack=T16;
 ReadInt8 (Fil,&T8);  Drive->HeadPhase=T8;
 ReadInt8 (Fil,&T8);  Drive->MotorON=T8;
 ReadInt8 (Fil,&T8);  Drive->WriteProtect=T8;
 ReadInt8 (Fil,&T8);  Drive->LatchInOut=T8;
 ReadInt8 (Fil,&T8);  Drive->Latch=T8;
 ReadInt32(Fil,&T32); Drive->Turn=T32;
 ReadInt8 (Fil,&T8); Drive->ImageType=T8;
 ReadInt8 (Fil,&T8); Drive->MaxTrack=T8;
 ReadInt32(Fil,&T32); Drive->TrackLen=T32;
 ReadInt8(Fil,&Phase);
 ReadInt8 (Fil,&T8);  Drive->Skew=T8;
 ReadInt16(Fil,&T16); Drive->NbImages=T16;
 ReadInt16(Fil,&T16); Drive->NoImage=T16;
 ReadInt8 (Fil,&T8);  Drive->UpdateFile=T8;
 if (Phase) {
 	uint32 Size;
	ReadInt32(Fil,&Size);
	Drive->Image=new uchar[Size];
	Fil->Read(Drive->Image,Size);
	}
 if (Drive->NbImages) Drive->PathList=new BPath *[Drive->NbImages];
 
 for (I=0;I<Drive->NbImages;I++) {
	uint32 Size;
	ReadInt32(Fil,&Size);
	char *Tmp=new char[Size];
 	Fil->Read(Tmp,Size);
 	Drive->PathList[I]=new BPath(Tmp);
 	delete Tmp; 	
	}
}

//##########################################

int Gel(BPath *Path)
{
 int I,Size;

 BFile Fil(Path->Path(),B_WRITE_ONLY|B_CREATE_FILE);
 off_t FilPos;

// PROLOGUE -------------------------------
 WriteInt8(&Fil,0);	// TAG Intro general
 WriteInt8(&Fil,0);	// Subtype
 FilPos=Fil.Position();
 WriteInt32(&Fil,0); // Block length

 WriteString(&Fil,GelPrologue); // Baratin 
 WriteInt8(&Fil,0x11);	// Apple ][+
 WriteInt32(&Fil,0x00000100); // Versionnumber

 WriteInt32At(&Fil,FilPos,Fil.Position()-FilPos-4);

// Computer-------------------------------
 WriteInt8(&Fil,1); // TAG Computer
 WriteInt8(&Fil,0x11);	// Subtype = Apple ][+
 FilPos=Fil.Position();
 WriteInt32(&Fil,0); // Block length
 // CPU
 WriteInt8(&Fil,GrA);
 WriteInt8(&Fil,GrX);
 WriteInt8(&Fil,GrY);
 WriteInt8(&Fil,GrSP);
 WriteInt16(&Fil,GrPC);
 WriteInt8(&Fil,GrP);
 WriteInt64(&Fil,SimCycles);
 WriteInt64(&Fil,TimCycles);
 // BUS
 Fil.Write(MEM,64*1024);
 Fil.Write(ROM,16*1024);
 Fil.Write(RAMLan,16*1024);
 WriteInt32(&Fil,(IOLanPage&65535) | (IOLanRead<<16) |
 				 (IOLanWrite<<17) | (IOLanWriteBis<<18) );
 // Graphic
 WriteInt32(&Fil,Graph_Text | (All_4Lines <<1) | (PageSwitch <<2) | (Lo_HiGraph <<3)); 

 WriteInt32At(&Fil,FilPos,Fil.Position()-FilPos-4);


// Disk -----------------------------------
 WriteInt8(&Fil,2); // TAG Disk
 WriteInt8(&Fil,0x01);	// Subtype = Disk ][
 FilPos=Fil.Position();
 WriteInt32(&Fil,0); // Block length
 
 WriteInt8(&Fil,6); // Slot #
 WriteInt8(&Fil,SelDrive);	// Disque sélecté

 GelDiskDrive(&Fil,&Drive1);
 GelDiskDrive(&Fil,&Drive2);
 
 WriteInt32At(&Fil,FilPos,Fil.Position()-FilPos-4);

// Terminator ----------------------------
 WriteInt8(&Fil,0);
 WriteInt8(&Fil,0xFF);	// FIN

 return 0;
}

//###############################################################

int Degel(BPath *Path)
{
 int I;
 uint32 Size;
 int ERR=0;
 
 BFile Fil(Path->Path(),B_READ_ONLY);
 
 uint8 TAG,SUB;
 off_t FilPos;
 do {
	I=ReadInt8(&Fil,&TAG);
	if (I<1) break;
	I=ReadInt8(&Fil,&SUB);
	if (I<1) break;
	//printf ("TAG=%i SUB=%i\n",(int)TAG,(int)SUB);
	switch (TAG) {
		case 0:	// GENERAL
			if (SUB==0xFF) {	// EOF
				goto Fin;
				} else
			if (SUB==0) {
				ReadInt32(&Fil,&Size);
				FilPos=Fil.Position()+Size;
				ReadString(&Fil,NULL,0);	// Chaine baratin
				uint8 Type;
				ReadInt8(&Fil,&Type);	// Type ordinateur
				if (Type!=0x11) {
					ERR=1;
					goto Fin; //ERREUR
					}
				//printf ("Type=%X\n",(int)Type);
				uint32 T32;
				ReadInt32(&Fil,&T32); // Version number
				printf ("Version fichier BeApple][ = :%0X\n",(int)T32);
				Fil.Seek(FilPos,SEEK_SET);
				}
			else {
				ReadInt32(&Fil,&Size);
				Fil.Seek(Size,SEEK_CUR);
				}
			break;

		case 1: // ORDINATEUR
			if (SUB==0x11) { // Apple][+
				ReadInt32(&Fil,&Size);
				FilPos=Fil.Position()+Size;

				ReadInt8(&Fil,&GrA);		// CPU
				ReadInt8(&Fil,&GrX);
				ReadInt8(&Fil,&GrY);
				ReadInt8(&Fil,&GrSP);
				ReadInt16(&Fil,&GrPC);
				ReadInt8(&Fil,&GrP);
				ReadInt64(&Fil,&SimCycles);
				ReadInt64(&Fil,&TimCycles);
				Fil.Read(MEM,64*1024);			// BUS
				Fil.Read(ROM,16*1024);
				Fil.Read(RAMLan,16*1024);
				uint32 T;
				ReadInt32(&Fil,&T);
				IOLanPage=T&65535;
				IOLanRead=(T>>16)&1;
				IOLanWrite=(T>>17)&1;
				IOLanWriteBis=(T>>18)&1;
				ReadInt32(&Fil,&T);				// Graphic
				Graph_Text=T&1;
				All_4Lines=(T>>1)&1;
				PageSwitch=(T>>2)&1;
				Lo_HiGraph=(T>>3)&1;
				
				Fil.Seek(FilPos,SEEK_SET);				
				}
			else {
				ReadInt32(&Fil,&Size);
				Fil.Seek(Size,SEEK_CUR);
				}
			break;
		case 2:
			if (SUB==0x01) { // Disk ][
				ReadInt32(&Fil,&Size);
				FilPos=Fil.Position()+Size;
				uint8 Slot;
				ReadInt8(&Fil,&Slot);
				if (Slot==6) {
					uint8 T8;
					ReadInt8(&Fil,&T8); SelDrive=T8;	// Disque sélecté
					Drive1.FreePlaylist();
					DegelDiskDrive(&Fil,&Drive1);
					Drive2.FreePlaylist();
					DegelDiskDrive(&Fil,&Drive2);
					}

				Fil.Seek(FilPos,SEEK_SET);
				}
			else {
				ReadInt32(&Fil,&Size);
				Fil.Seek(Size,SEEK_CUR);
				}
			break;
		default:
			ReadInt32(&Fil,&Size);
			Fil.Seek(Size,SEEK_CUR);
		}
  } while (true);
Fin:

 return 0;
}
