/*#############################################
  #  ASIM : Simulateur Apple ][               #
  #                                           #
  #                       graphic : affichage # 
  #############################################*/

#include "asim.h"
#include "asimbe.h"
//#include <Window.h>
#include <alloc.h>
#include <StorageKit.h>


// CONFIG FLAGS --------------------
int DisplayModel=DISPLAY_COLOR; // Modèle d'écran
int BlinkMax=4;	// Blink time = BlinkMax*PULSE_RATE

// VIDEO CONFIGURATION -------------
volatile bool Graph_Text=false; // Text=false Graphic=true
volatile bool All_4Lines=false; // All =false 4Lines=true
volatile bool PageSwitch=false; // Page1=false Page2=true
volatile bool Lo_HiGraph=false; // LoRes=false HiRes=true

int BlinkDelay=0;
bool BlinkState=false;

// ---------------------------------
BBitmap *bbEcran=NULL;
BView   *bvEcran=NULL;
BBitmap *bbChar=NULL;

uint16 XText[1024];
uint16 YText[1024];

// COLORS -------------------------
rgb_color Palette[16]={	// Palette low resolution
		{  0,  0,  0,0},	// 0: Black
		{135,  0, 50,0},	// 1: Magenta
		{ 53, 65,151,0},	// 2: Dark Blue
		{210,120,210,0},	// 3: Lavender
		{ 25, 75, 45,0},	// 4: Dark Green
		{125,125,125,0},	// 5: Grey 1
		{ 65,156,184,0},	// 6: Medium Blue
		{146,202,234,0},	// 7: Light Blue
		{ 79, 31, 15,0},	// 8: Brown
		{253, 56,  0,0},	// 9: Orange
		{ 98, 98, 98,0},	// A: Grey 2
		{250,163,172,0},	// B: Pink
		{ 67,160, 70,0},	// C: Light Green
		{188,193, 78,0},	// D: Yellow
		{ 65,191,194,0},	// E: Aquamarine
		{255,255,255,0}		// F: White
		};

const uint8 clBlack=0,clBlue =1,clOrange=2,clGreen =3,clViolet=4,clWhite =5;
uint8 CoWhite,CoBlack ,CoGreen ,CoAmber,CoBlue ,CoOrange,CoViolet;

// Par buscar colores en alta resolucion.
uint8 CoLookup[32*4];
uint8 CoLookupColor[32*4]={ // Pair & B7=0
		clBlack ,clBlack ,clBlack ,clBlack ,	// 000xx
		clViolet,clViolet,clWhite ,clWhite ,	// 001xx
		clBlack ,clBlack ,clGreen ,clGreen ,	// 010xx
		clWhite ,clWhite ,clWhite ,clWhite ,	// 011xx
		clBlack ,clBlack ,clBlack ,clBlack ,	// 100xx
		clViolet,clViolet,clWhite ,clWhite ,	// 101xx
		clBlack ,clBlack ,clGreen ,clGreen ,	// 110xx
		clWhite ,clWhite ,clWhite ,clWhite ,	// 111xx
			// Impair &B7=0
		clBlack ,clBlack ,clBlack ,clBlack ,	// 000xx
		clGreen ,clGreen ,clWhite ,clWhite ,	// 001xx
		clBlack ,clBlack ,clViolet,clViolet,	// 010xx
		clWhite ,clWhite ,clWhite ,clWhite ,	// 011xx
		clBlack ,clBlack ,clBlack ,clBlack ,	// 100xx
		clGreen ,clGreen ,clWhite ,clWhite ,	// 101xx
		clBlack ,clBlack ,clViolet,clViolet,	// 110xx
		clWhite ,clWhite ,clWhite ,clWhite ,	// 111xx
			// Pair &B7=1		
		clBlack ,clBlack ,clBlack ,clBlack ,	// 000xx
		clBlue  ,clBlue  ,clWhite ,clWhite ,	// 001xx
		clBlack ,clBlack ,clOrange,clOrange,	// 010xx
		clWhite ,clWhite ,clWhite ,clWhite ,	// 011xx
		clBlack ,clBlack ,clBlack ,clBlack ,	// 100xx
		clBlue  ,clBlue  ,clWhite ,clWhite ,	// 101xx
		clBlack ,clBlack ,clOrange,clOrange,	// 110xx
		clWhite ,clWhite ,clWhite ,clWhite ,	// 111xx
			// Impair &B7=1
		clBlack ,clBlack ,clBlack ,clBlack ,	// 000xx
		clOrange,clOrange,clWhite ,clWhite ,	// 001xx
		clBlack ,clBlack ,clBlue  ,clBlue  ,	// 010xx
		clWhite ,clWhite ,clWhite ,clWhite ,	// 011xx
		clBlack ,clBlack ,clBlack ,clBlack ,	// 100xx
		clOrange,clOrange,clWhite ,clWhite ,	// 101xx
		clBlack ,clBlack ,clBlue  ,clBlue  ,	// 110xx
		clWhite ,clWhite ,clWhite ,clWhite
		};

//---------------------------------------------------------------
void InitDisplay()
{
 int I;
 uint8 Color;
// HIRES
 if (DisplayModel<=DISPLAY_AMBER) {
	if (DisplayModel==DISPLAY_WHITE) Color=CoWhite; else
	if (DisplayModel==DISPLAY_GREEN) Color=CoGreen; else
	if (DisplayModel==DISPLAY_AMBER) Color=CoAmber; else
	Color=CoBlack;
	for (I=0;I<32*4;I++) CoLookup[I]=(I&4)?Color:CoBlack; 	
  }else{
	for (I=0;I<32*4;I++) switch(CoLookupColor[I]) {
		case clBlack : CoLookup[I]=CoBlack;  break;
		case clBlue  : CoLookup[I]=CoBlue;   break;
		case clOrange: CoLookup[I]=CoOrange; break;
		case clGreen : CoLookup[I]=CoGreen;  break;
		case clViolet: CoLookup[I]=CoViolet; break;
		case clWhite : CoLookup[I]=CoWhite;  break;
		}
	if (DisplayModel==DISPLAY_COLORLOW) {
		CoLookup[0x1B   ]=CoBlack;
		CoLookup[0x1B+32]=CoBlack;
		CoLookup[0x1B+64]=CoBlack;
		CoLookup[0x1B+96]=CoBlack;
		}
	}
// TEXT
 char *Pix=(char *)bbChar->Bits();
 for (I=0;I<8*256*8;I++) switch(DisplayModel) {
	case DISPLAY_GREEN:
		Pix[I]=(Pix[I]==CoBlack)?CoBlack:CoGreen;
		break;
	case DISPLAY_AMBER:
		Pix[I]=(Pix[I]==CoBlack)?CoBlack:CoAmber;
		break;
	default :
		Pix[I]=(Pix[I]==CoBlack)?CoBlack:CoWhite;
		break;
	}
}

//---------------------------------------------------------------

void InitGraphic()
{
 int X,Y,D;
 uint8 T;

 Graph_Text=false;
 All_4Lines=false;
 PageSwitch=false;
 Lo_HiGraph=false;

 BScreen Screen;
// Allocs
 bbEcran=new BBitmap(BRect(0,0,280,192),B_COLOR_8_BIT,true);
 bvEcran=new BView(BRect(0,0,280,192),"Vue",B_FOLLOW_NONE,0);
 bbEcran->AddChild(bvEcran);

 CoWhite =Screen.IndexForColor(255,255,255);
 CoBlack =Screen.IndexForColor(0  ,  0,  0);
 CoGreen =Screen.IndexForColor(0  ,255,  0);
 CoBlue  =Screen.IndexForColor(0  ,  0,255);
 CoAmber =Screen.IndexForColor(255,180, 10);
 CoOrange=Screen.IndexForColor(255,120,  0);
 CoViolet=Screen.IndexForColor(230,  0,255);

// Coordonates
 for (X=0;X<1024;X++) { XText[X]=YText[X]=255; }
 for (Y=0;Y<24;Y++) {
 	if (Y<8) D=Y*128; else
 	if (Y<16) D=0x28+(Y-8)*128; else
 	D=0x50+(Y-16)*128; 	
	for (X=0;X<40;X++) {
		XText[D+X]=X;
		YText[D+X]=Y;
		}
	}

// Text Gen
 bbChar =new BBitmap(BRect(0,0,8*256-1,8-1),B_COLOR_8_BIT);
 FILE *FIN=NULL;
 char Data[2048];
 
 app_info appInfo;
 be_app->GetAppInfo(&appInfo);
 entry_ref AsimRef = appInfo.ref;
 AsimRef.set_name(".");
 BDirectory exeDir(&AsimRef);
 BPath AsimPath(&exeDir, "character.rom");
 const char *FF = AsimPath.Path();

 FIN=fopen(FF,"rb"); // FIN=fopen("character.rom","rb");
 fread(Data,1,2048,FIN);
 int Nopl=bbChar->BytesPerRow();
 char *Pix=(char *)bbChar->Bits();
 fclose(FIN);

 for (X=0;X<2048;X++) {
    T=Data[X]; T>>=1;
    for (Y=0;Y<8;Y++) {
		if (X>0x80*8)		Pix[(X&0xFFF8)+Y+(X&7)*Nopl]=((T&1)==1)?CoWhite:CoBlack;
		else if (X<0x40*8)	Pix[(X&0xFFF8)+Y+(X&7)*Nopl]=((T&1)==1)?CoBlack:CoWhite;
					else	Pix[(X&0xFFF8)+Y+(X&7)*Nopl]=((T&1)==1)?CoWhite:CoBlack;
    	T/=2;
		}
	}
 InitDisplay();
}

//---------------------------------------------------------------
void ClearGraphic()
{
 delete bbEcran;
 delete bbChar;
}
//---------------------------------------------------------------
void GraphicModeUpdate()
{
 int D;
 D=(PageSwitch?(0x800/Gran):(0x400/Gran));
 memset((void *)&RefMem[D],1,0x400/Gran);
 D=(PageSwitch?(0x4000/Gran):(0x2000/Gran));
 memset((void *)&RefMem[D],1,0x2000/Gran);
}

//---------------------------------------------------------------
int Xmin,Xmax;
int Ymin,Ymax;

/*++++++++++++++++++++++++++++++++++++++++++*/
void TextUpdate(uint16 D) // Update text / low res.
{
 int X,Y,C;
 C=MEM[D];
 X=XText[D&0x3FF];
 Y=YText[D&0x3FF];
 if (X!=255) {

	if ((X*7+6)>Xmax) Xmax=X*7+6;
	if ((X*7)  <Xmin) Xmin=X*7;
	if ((Y*8+7)>Ymax) Ymax=Y*8+7;
	if ((Y*8)  <Ymin) Ymin=Y*8;

	if ((Graph_Text&&(!Lo_HiGraph))&&(!(All_4Lines&&(Y>=20)))) {
		bvEcran->SetHighColor(Palette[C&15]);
		bvEcran->FillRect(BRect(X*7,Y*8,X*7+6,Y*8+3));
		bvEcran->SetHighColor(Palette[C>>4]);
		bvEcran->FillRect(BRect(X*7,Y*8+4,X*7+6,Y*8+7));
	  }else{
		bvEcran->DrawBitmapAsync(bbChar,BRect(C*8+0,0,C*8+6,7),BRect(X*7,Y*8,X*7+6,Y*8+7));		
		}
	}
}
/*++++++++++++++++++++++++++++++++++++++++++*/

/*
(2000-2027:Line 0)	(2028-204F:Line 8)	(2050-2077:Line 16)	(2078-207F : 8 Offscreen bytes)
(2080-20A7:Line 1)	(20A8-20CF:Line 9)	(20D0-20F7:Line 17)	(20F8-20FF : 8 Offscreen bytes)
(2100-2127:Line 2)	(2128-214F:Line 10)	(2150-2177:Line 18)	(2178-217F : 8 Offscreen bytes)
(2180-21A7:Line 3)	(21A8-21CF:Line 11)	(21D0-21F7:Line 19)	(21F8-21FF : 8 Offscreen bytes)
(2200-2227:Line 4)	(2228-224F:Line 12)	(2250-2277:Line 20)	(2278-227F : 8 Offscreen bytes)
(2280-22A7:Line 5)	(22A8-22CF:Line 13)	(22D0-21F7:Line 21)	(22F8-22FF : 8 Offscreen bytes)
(2300-2327:Line 6)	(2328-234F:Line 14)	(2350-2277:Line 22)	(2378-237F : 8 Offscreen bytes)
(2380-23A7:Line 7)	(23A8-23CF:Line 15)	(23D0-23F7:Line 23)	(23F8-23FF : 8 Offscreen bytes)
*/
void GraphUpdate(uint8 *Upt,int Page) // Update hires graphics
{
 int X,Y,Ylog;
 int I;
 int Imin;
 int Bit;
 int Xmax,Xmin,Xu,Xc;
 uint16 C,D,E;
 uint8 *Pix;
 int Nopl=bbEcran->BytesPerRow();

 bool Tact,Fini;

 Tact=Fini=false;
 Ylog=Y=0;
 
 for (X=0,I=0;I<0x2000;I++,X++) {
	if (!Upt[I/Gran]) continue;
	if (X>=40) { // Changement de ligne
		if ((I&0x7F)>0x77) { I&=0x1F80;	I|=0x7F; continue; } // Offscreen
		Y=YText[I&0x3FF];
		if ((Y>=20)&&(All_4Lines)) { I&=0x1F80; I|=0x7F; continue; } // Skip 4 lines text 
		Y=Y*8+((I/1024)&7);
		X=XText[I&0x3FF];
		if (Tact) goto UpdateSegment; // Great, a 'goto' !
		}
	if (!Tact) { Imin=Page+I; Xmin=Xmax=X; Ylog=Y; Tact=true; continue; }
	if (X<=(Xmax+2)) { Xmax=X; continue; } 

  UpdateSegment:
  
	if ((Xmin*7-2)<(::Xmin)) (::Xmin)=Xmin*7-2;
	if ((Xmax*7+9)>(::Xmax)) (::Xmax)=Xmax*7+9;
	if (Ylog<(::Ymin)) (::Ymin)=Ylog;
	if (Ylog>(::Ymax)) (::Ymax)=Ylog;

	Pix=&((uint8 *)bbEcran->Bits())[Xmin*7-2+Nopl*Ylog];

	Bit=5; Xc=Xmin-1;
	if (Xmin>0) C=MEM[Imin-1]; else C=0;

	for (Xu=Xmin*7-2;Xu<Xmax*7+9;Xu++) { // Pixel
		if (Bit==5) {
			if (Xc<39) D=MEM[Imin]; else D=0;
			E=((C&127)/8)|((D&127)*16);
			}
		if (Bit==7) { Bit=0; C=D; Xc++; Imin++;	}
		if ((Xu>=0)&&(Xu<280)) *Pix=CoLookup[(E&31)|((C&128)/2)|((Xu&1)*32)];
		E=E/2;
		Bit++; Pix++;
		}
	if (Fini) goto Terminate;
	Xmin=Xmax=X; Ylog=Y;
	Imin=Page+I;
	}
 Fini=true;
 if (Tact) goto UpdateSegment; // Wonderful, another 'goto', I like 'em
 Terminate:
 if (::Xmin<0) ::Xmin=0;
 if (::Xmax>279) ::Xmax=279;		
}

/*++++++++++++++++++++++++++++++++++++++++++*/
void VideoUpdate()
{
 int D;
 int I,J;

 bbEcran->Lock();
 if (ThreadCPU) suspend_thread(ThreadCPU);
 
 BlinkDelay++;
 if (BlinkDelay==BlinkMax) { // Blinkation
 	BlinkDelay=0;
 	D=(PageSwitch?(0x800/Gran):(0x400/Gran));
 	for (I=0;I<0x400/Gran;I++) for (J=0;J<Gran;J++)
 		if ((MEM[D+I*Gran+J]>=0x40)&&(MEM[D+I*Gran+J]<0x80))
			RefMem[D+I]=1;
	BlinkState=!BlinkState;
	char *Pix=(char *)bbChar->Bits();
	uint8 Colo=Pix[0];
	Pix+=8*64;
	for (J=0;J<8;J++) {
		for (I=0;I<8*64;I++) Pix[I]=(Pix[I]==CoBlack)?Colo:CoBlack;
		Pix+=8*256;
		}
	}
		 
// Xmin=279; Xmax=0; Ymin=191; Ymax=0;
   Xmin=0; Xmax=0; Ymin=0; Ymax=0;
 
 if ((!Graph_Text)||(!Lo_HiGraph)) { // Text & Low res modes
	D=(PageSwitch?(0x800/Gran):(0x400/Gran));	
	for (I=0;I<0x400/Gran;I++) if (RefMem[D+I]) {
		for (J=0;J<Gran;J++) TextUpdate((D+I)*Gran+J);
		}
	memset((void *)&RefMem[D],0,0x400/Gran);
  }else{ // Graphmode
	D=(PageSwitch?(0x4000/Gran):(0x2000/Gran));
	GraphUpdate((uint8 *)&RefMem[D],D);
	memset((void *)&RefMem[D],0,0x2000/Gran);  
  	if (All_4Lines) { // Mixed Hires/Text
 		D=(PageSwitch?(0x800/Gran):(0x400/Gran));
		for (J=0;J<40;J++) if (RefMem[(D+0x250+J)/Gran]) TextUpdate(D+0x250+J);
		for (J=0;J<40;J++) if (RefMem[(D+0x2D0+J)/Gran]) TextUpdate(D+0x2D0+J);
		for (J=0;J<40;J++) if (RefMem[(D+0x350+J)/Gran]) TextUpdate(D+0x350+J);
		for (J=0;J<40;J++) if (RefMem[(D+0x3D0+J)/Gran]) TextUpdate(D+0x3D0+J);
		memset((void *)&RefMem[D],0,0x400/Gran);		
		}
	}
 bvEcran->Flush();
 bvEcran->Sync();
 BRect rect(Xmin,Ymin,Xmax,Ymax);
 winAsim->avAsim->DrawBitmap(bbEcran,rect,rect);
 if (ThreadCPU) resume_thread(ThreadCPU);
 bbEcran->Unlock();
}
