/*
 * Program to extract font data from .bfd files
 */

#include <stdio.h>
#include <string.h>

unsigned short data[256][19];

int main(int argc, char *argv[])
{
	char buffer[256], buffer2[256];
	int i, charno;
	int val;
	FILE *in, *out;
	char *p;

	if (NULL==(in = fopen(argv[1], "r"))) {
		printf("Could not open file \"%s\"\n", argv[1]);
		return 0;
	}

	if (p = strchr(argv[1], '.')) {
		*p = '\0';
	}
	while (p = strchr(argv[1], '-')) {
		*p = '_';
	}

	for (; ; ) {
		// Find ENCODING line
		do {
			fgets(buffer, 256, in);
		} while (!feof(in) && !strstr(buffer, "ENCODING"));
		charno = atoi(&buffer[9]);

		if (feof(in)) break;

		// Find BITMAP line
		do {
			fgets(buffer, 256, in);
		} while (!feof(in) && !strstr(buffer, "BITMAP"));

		if (feof(in)) break;

//		printf("\n/* %d */\n", charno);
		for (i=0; i<19; i++) {
			fscanf(in, "%x", &val);
			data[charno][i] = val;
//			printf("0x%04x, ", val);
		}
//		puts("");
	}

//	puts("};\n");

	// Now output the data...
	printf("//\n");
	printf("// Font data extracted from %s\n", argv[1]);
	printf("//\n");
	printf("\nunsigned short int %s[] = {\n", argv[1]);

	for (charno=32; charno<256; charno++) {
		printf("\n/* %d */\n", charno);
		for (i=0; i<19; i++) {
			printf("0x%04x, ", data[charno][i]);
		}
		puts("");
	}
	puts("};\n");

	fclose (in);

	return 0;
}
