/**
 * Mupen64 - main_gtk.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

/* The gtk interface but it is far from being complete...*/

#define VERSION "0.0.3"

#include <stdlib.h>
#include "rom.h"
#include "winlnxdefs.h"
#include "plugin.h"
#include "../r4300/r4300.h"
#include "../r4300/recomph.h"
#include "../memory/memory.h"
#include "../sound/sound.h"
#include <pthread.h>

#include <SDL/SDL.h>
#include <gtk/gtk.h>

#include "../logo.xpm"

static int file_selection_launched = 0;
static pthread_t my_thread;

static GtkWidget *window;
static GtkWidget *interp;
static GtkWidget *dynam;
static GtkWidget *pure_interp;
static GtkWidget *combo_gfx;
static GtkWidget *combo_input;

static int filter(const SDL_Event *event)
{
   switch (event->type)
     {
      case SDL_KEYDOWN:
	switch (event->key.keysym.sym)
	  {
	   case SDLK_ESCAPE:
	     stop_it();
	     break;
	   case SDLK_F1:
	     changeWindow();
	     break;
	   default:
	     keyDown(0, event->key.keysym.sym);
	  }
	return 0;
	break;
      case SDL_KEYUP:
	switch (event->key.keysym.sym)
	  {
	   case SDLK_ESCAPE:
	     break;
	   case SDLK_F1:
	     break;
	   default:
	     keyUp(0, event->key.keysym.sym);
	  }
	return 0;
	break;
      default:
	return 1;
     }
}

static void *main_thread(void *p)
{
   if (GTK_TOGGLE_BUTTON(dynam)->active == 1) dynacore = 1;
   else if (GTK_TOGGLE_BUTTON(pure_interp)->active == 1) dynacore = 2;
   else dynacore = 0;
   
   SDL_Init(SDL_INIT_VIDEO);
   SDL_SetVideoMode(10, 10, 16, 0);
   SDL_SetEventFilter(filter);
   SDL_ShowCursor(0);
   SDL_EnableKeyRepeat(0, 0);
   
   if (sound_init())
     {
	if(rom) {
	   free(rom);
	   rom = NULL;
	}
	if(ROM_HEADER) {
	   free(ROM_HEADER);
	   ROM_HEADER = NULL;
	}
	return 0;
     }
   init_memory();
   load_plugins(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo_gfx)->entry)),
		gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo_input)->entry)));
   romOpen_gfx();
   romOpen_input();
   go();
   romClosed_input();
   romClosed_gfx();
   closeDLL_input();
   closeDLL_gfx();
   free_sound();
   free(rom);
   rom = NULL;
   free(ROM_HEADER);
   ROM_HEADER = NULL;
   free_memory();
   file_selection_launched = 0;
   return 0;
}

static void launch_rom(GtkWidget *widget, gpointer data)
{
   char *name, *name_aux;
   
   name_aux = gtk_file_selection_get_filename(GTK_FILE_SELECTION(data));
   name = malloc(strlen(name_aux)+1);
   strcpy(name, name_aux);
   
   gtk_widget_destroy(GTK_WIDGET(data));
   
   printf("Emulateur Nintendo64 (mupen64) version : %s\n", VERSION);
   if (rom_read(name))
     {
	if(rom) {
	   free(rom);
	   rom = NULL;
	}
	if(ROM_HEADER) {
	   free(ROM_HEADER);
	   ROM_HEADER = NULL;
	}
	free(name);
	file_selection_launched = 0;
	return;
     }
   else
     pthread_create(&my_thread, NULL, main_thread, NULL);
}

static void cancel_load(GtkWidget *widget, gpointer data)
{
   file_selection_launched = 0;
   gtk_widget_destroy(GTK_WIDGET(data));
}

static void destroy_load(GtkWidget *widget, gpointer data)
{
}

static void load(GtkWidget *widget, gpointer data)
{
   if (!file_selection_launched)
     {
	GtkWidget *load_dialog;
	load_dialog = gtk_file_selection_new("Choose a N64 rom file : ");
	
	gtk_signal_connect(GTK_OBJECT(load_dialog), "destroy",
			   GTK_SIGNAL_FUNC(destroy_load), NULL);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(load_dialog)->ok_button), 
			   "clicked", GTK_SIGNAL_FUNC(launch_rom), load_dialog);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(load_dialog)->cancel_button),
			   "clicked", GTK_SIGNAL_FUNC(cancel_load), load_dialog);
   
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(load_dialog),
					".");
	gtk_widget_show(load_dialog);
	file_selection_launched = 1;
     }
}

static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
   return(FALSE);
}

static void destroy(GtkWidget *widget, gpointer data)
{
   gtk_main_quit();
}

static void config_gfx(GtkWidget *widget, gpointer data)
{
   exec_config(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo_gfx)->entry)));
}

static void test_gfx(GtkWidget *widget, gpointer data)
{
   exec_test(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo_gfx)->entry)));
}

static void about_gfx(GtkWidget *widget, gpointer data)
{
   exec_about(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo_gfx)->entry)));
}

static void config_input(GtkWidget *widget, gpointer data)
{
   exec_config(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo_input)->entry)));
}

static void test_input(GtkWidget *widget, gpointer data)
{
   exec_test(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo_input)->entry)));
}

static void about_input(GtkWidget *widget, gpointer data)
{
   exec_about(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo_input)->entry)));
}

int main (int argc, char *argv[])
{
   GtkWidget *load_button;
   GtkWidget *table;
   GtkWidget *pixmapwid;
   GtkStyle *style;
   GdkPixmap *pixmap;
   GdkBitmap *mask;
   GtkWidget *label_core;
   
   GList *glist_gfx = NULL;
   GtkWidget *label_gfx;
   GtkWidget *config_gfx_button;
   GtkWidget *test_gfx_button;
   GtkWidget *about_gfx_button;
   
   GList *glist_input = NULL;
   GtkWidget *label_input;
   GtkWidget *config_input_button;
   GtkWidget *test_input_button;
   GtkWidget *about_input_button;
   
   gtk_init(&argc, &argv);
   
   // cration de la fentre
   window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
   gtk_container_set_border_width(GTK_CONTAINER(window), 10);
   gtk_widget_show(window);
   
   // cration du bouton Load rom
   load_button = gtk_button_new_with_label("Load rom...");   
   gtk_widget_show(load_button);
   
   // cration du logo
   style = gtk_widget_get_style(window);
   pixmap = gdk_pixmap_create_from_xpm_d(window->window, &mask,
					 &style->bg[GTK_STATE_NORMAL],
					 (gchar **)logo_xpm);
   pixmapwid = gtk_pixmap_new(pixmap, mask);
   gtk_widget_show(pixmapwid);
   
   // cration de la selection du mode d'mulation '
   label_core = gtk_frame_new("cpu core : ");
   gtk_widget_show(label_core);
   interp = gtk_radio_button_new_with_label(NULL, "interpreter");
   gtk_widget_show(interp);
   dynam = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(interp)),
					   "dynamic compiler");
   gtk_widget_show(dynam);
   pure_interp = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(interp)), 
						 "pure interpreter");
   gtk_widget_show(pure_interp);
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(dynam), TRUE);
   
   // recherche des plugins
   search_plugins(argv[0]);
   while(get_plugin_type() != -1)
     switch (get_plugin_type())
       {
	case PLUGIN_TYPE_GFX:
	  glist_gfx = g_list_append(glist_gfx, next_plugin());
	  break;
	case PLUGIN_TYPE_CONTROLLER:
	  glist_input = g_list_append(glist_input, next_plugin());
	  break;
       }
   
   label_gfx = gtk_frame_new("gfx plugin : ");
   gtk_widget_show(label_gfx);
   combo_gfx = gtk_combo_new();
   gtk_combo_set_popdown_strings(GTK_COMBO(combo_gfx), glist_gfx);
   gtk_combo_set_value_in_list(GTK_COMBO(combo_gfx), TRUE, FALSE);
   gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo_gfx)->entry), FALSE);
   gtk_widget_show(combo_gfx);
   config_gfx_button = gtk_button_new_with_label("Config");
   gtk_widget_show(config_gfx_button);
   test_gfx_button = gtk_button_new_with_label("Test");
   gtk_widget_show(test_gfx_button);
   about_gfx_button = gtk_button_new_with_label("About");
   gtk_widget_show(about_gfx_button);
   
   label_input = gtk_frame_new("input plugin : ");
   gtk_widget_show(label_input);
   combo_input = gtk_combo_new();
   gtk_combo_set_popdown_strings(GTK_COMBO(combo_input), glist_input);
   gtk_combo_set_value_in_list(GTK_COMBO(combo_input), TRUE, FALSE);
   gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(combo_input)->entry), FALSE);
   gtk_widget_show(combo_input);
   config_input_button = gtk_button_new_with_label("Config");
   gtk_widget_show(config_input_button);
   test_input_button = gtk_button_new_with_label("Test");
   gtk_widget_show(test_input_button);
   about_input_button = gtk_button_new_with_label("About");
   gtk_widget_show(about_input_button);
   
   // mise en place des venements
   gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		      GTK_SIGNAL_FUNC(delete_event), NULL);
   gtk_signal_connect(GTK_OBJECT(window), "destroy",
		      GTK_SIGNAL_FUNC(destroy), NULL);
   gtk_signal_connect(GTK_OBJECT(load_button), "clicked",
		      GTK_SIGNAL_FUNC(load), NULL);
   gtk_signal_connect(GTK_OBJECT(config_gfx_button), "clicked",
		      GTK_SIGNAL_FUNC(config_gfx), NULL);
   gtk_signal_connect(GTK_OBJECT(test_gfx_button), "clicked",
		      GTK_SIGNAL_FUNC(test_gfx), NULL);
   gtk_signal_connect(GTK_OBJECT(about_gfx_button), "clicked",
		      GTK_SIGNAL_FUNC(about_gfx), NULL);
   gtk_signal_connect(GTK_OBJECT(config_input_button), "clicked",
		      GTK_SIGNAL_FUNC(config_input), NULL);
   gtk_signal_connect(GTK_OBJECT(test_input_button), "clicked",
		      GTK_SIGNAL_FUNC(test_input), NULL);
   gtk_signal_connect(GTK_OBJECT(about_input_button), "clicked",
		      GTK_SIGNAL_FUNC(about_input), NULL);
   
   // mise en page
   table = gtk_table_new(35, 30, TRUE);
   gtk_widget_show(table);
   
   gtk_container_add(GTK_CONTAINER(window), table);
   gtk_table_attach_defaults(GTK_TABLE(table), load_button, 0, 10, 0, 3);
   gtk_table_attach_defaults(GTK_TABLE(table), label_core, 0, 10, 5, 15);
   gtk_table_attach_defaults(GTK_TABLE(table), pixmapwid, 10, 30, 0, 10);
   gtk_table_attach_defaults(GTK_TABLE(table), interp, 1, 10, 6, 9);
   gtk_table_attach_defaults(GTK_TABLE(table), dynam, 1, 10, 9, 12);
   gtk_table_attach_defaults(GTK_TABLE(table), pure_interp, 1, 10, 12, 15);
   
   gtk_table_attach_defaults(GTK_TABLE(table), label_gfx, 0, 30, 15, 25);
   gtk_table_attach_defaults(GTK_TABLE(table), combo_gfx, 1, 29, 17, 22);
   gtk_table_attach_defaults(GTK_TABLE(table), config_gfx_button, 1, 10, 22, 24);
   gtk_table_attach_defaults(GTK_TABLE(table), test_gfx_button, 10, 20, 22, 24);
   gtk_table_attach_defaults(GTK_TABLE(table), about_gfx_button, 20, 29, 22, 24);
   
   gtk_table_attach_defaults(GTK_TABLE(table), label_input, 0, 30, 25, 35);
   gtk_table_attach_defaults(GTK_TABLE(table), combo_input, 1, 29, 27, 32);
   gtk_table_attach_defaults(GTK_TABLE(table), config_input_button, 1, 10, 32, 34);
   gtk_table_attach_defaults(GTK_TABLE(table), test_input_button, 10, 20, 32, 34);
   gtk_table_attach_defaults(GTK_TABLE(table), about_input_button, 20, 29, 32, 34);
   
   gtk_main();
   
   return 0;
}
