/**
 * Mupen64 - dma.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

/* The dynamic recompier detects the blocks of code by storing all the
 * dma transferts that happens but i know that this function has to be 
 * rewritten and that it is not sufficient to handle all the self modifying
 * code
 */

#include "dma.h"
#include "memory.h"
#include "../main/rom.h"
#include <stdio.h>
#include "../r4300/r4300.h"
#include "../r4300/interupt.h"
#include <malloc.h>
#include "pif.h"

void dma_pi_write()
{
   unsigned long longueur;
   int i, new_blk = 0;
   
   if (!dynacore && interpcore)
     {
#ifdef _BIG_ENDIAN
	memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		     rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		     pi_register.pi_wr_len_reg+1);
#else
	
	longueur = pi_register.pi_wr_len_reg;
	if ((pi_register.pi_dram_addr_reg % 4) != 0)
	  printf("unaligned PI dma 1\n");
	if ((pi_register.pi_cart_addr_reg % 4) != 0) {
	   if (((longueur+1) % 4) != 0)
	     printf("unaligned PI dma 23\n");
	   if ((pi_register.pi_cart_addr_reg % 4) == 2) {
	      memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg+2,
		     rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)+2,
		     longueur+1);
	      ((unsigned short*)
	       rdram)[(pi_register.pi_dram_addr_reg-2)/2]=
		((unsigned short*)rom)
	       [(((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)
		 - 2)/2];
	   }
	   else
	     printf("unaligned PI dma 2\n");
	}
	else if (((longueur+1) % 4) != 0) {
	   if (((longueur+1) % 4) == 2) {
	      memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		     rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		     longueur-1);
	      ((unsigned short*)
	       rdram)[(pi_register.pi_dram_addr_reg+longueur+1)/2]=
		((unsigned short*)rom)
	       [(((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)
		 + longueur+1)/2];
	   }
	   else
	     printf("unaligned PI dma 3\n");
	}
	else
	  memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		 rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		 longueur+1);
#endif
	MI_register.mi_intr_reg |= 0x10;
	gen_mi();
	
	return;
     }
   
   if (pi_register.pi_cart_addr_reg < 0x10000000)
     printf("pi dma not in cartridge\n");
   if (pi_register.pi_dram_addr_reg < 0x300)
     int_handler.valid = 0;
   for (i=0; i<NBR_BLOCKS; i++)
     {
	if (actual == &aux[i])
	  {
	     if ((0x80000000 + pi_register.pi_dram_addr_reg) <= actual->start)
	       {
		  if ((0x80000000 + pi_register.pi_dram_addr_reg +
		      pi_register.pi_wr_len_reg) >= actual->start)
		    {
		       printf("erreur de recompilation dans un dma pi\n");
		       stop=1;
		       return;
		    }
	       }
	     else if ((0x80000000 + pi_register.pi_dram_addr_reg) <= actual->end)
	       {
		  if ((0x80000000 + pi_register.pi_dram_addr_reg) <= PC->addr)
		    {
		       printf("erreur de dma pi\n");
		       stop=1;
		       return;
		    }
		  aux[i].end = (0x80000000 + pi_register.pi_dram_addr_reg - 4);
		  aux[i].length = aux[i].end - aux[i].start;
	       }
	  }
	if (aux[i].valid)
	  {
	     if (((0x80000000 + pi_register.pi_dram_addr_reg) <= actual->end)&&
		 ((0x80000000 + pi_register.pi_dram_addr_reg +
		   pi_register.pi_wr_len_reg) >= actual->start))
	       {
		  printf("recouvrement rdram\n");
		  stop=1;
		  return;
	       }
	  }
	if (((0x80000000 + pi_register.pi_dram_addr_reg) <= aux[i].end)&&
	    ((0x80000000 + pi_register.pi_dram_addr_reg +
	      pi_register.pi_wr_len_reg) >= aux[i].start) && !aux[i].valid) {
	   aux[i].start = 0;
	   if (aux[i].code) {
	      free(aux[i].code);
	      aux[i].code = NULL;
	   }
	   if (aux[i].block) {
	      free(aux[i].block);
	      aux[i].block = NULL;
	   }
	}
	if (!aux[i].valid && (0x80000000 + pi_register.pi_dram_addr_reg)
	    == (aux[i].end + 1)) {
	   aux[i].end = 0x80000000 + pi_register.pi_dram_addr_reg +
	     pi_register.pi_wr_len_reg;
	   aux[i].length = aux[i].end - aux[i].start;
	}
     }
   if (pi_register.pi_wr_len_reg>taille_rom)
     {
	longueur = taille_rom-((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF);
#ifdef _BIG_ENDIAN
	memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
	       rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
	       pi_register.pi_wr_len_reg+1);
#else
	if ((pi_register.pi_dram_addr_reg % 4) != 0)
	  printf("unaligned PI dma 1\n");
	if ((pi_register.pi_cart_addr_reg % 4) != 0) {
	   if (((longueur+1) % 4) != 0)
	     printf("unaligned PI dma 23\n");
	   if ((pi_register.pi_cart_addr_reg % 4) == 2) {
	      memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg+2,
		     rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)+2,
		     longueur+1);
	      ((unsigned short*)
	       rdram)[(pi_register.pi_dram_addr_reg-2)/2]=
		((unsigned short*)rom)
	       [(((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)
		 - 2)/2];
	   }
	   else
	     printf("unaligned PI dma 2\n");
	}
	else if (((longueur+1) % 4) != 0) {
	   if (((longueur+1) % 4) == 2) {
	      memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		     rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		     longueur-1);
	      ((unsigned short*)
	       rdram)[(pi_register.pi_dram_addr_reg+longueur+1)/2]=
		((unsigned short*)rom)
	       [(((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)
		 + longueur+1)/2];
	   }
	   else
	     printf("unaligned PI dma 3\n");
	}
	else
	  memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		 rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		 longueur);
#endif
	for (i=0; i<NBR_BLOCKS; i++) {
	   if (!aux[i].valid && !aux[i].start) {
	      new_blk=i;
	      break;
	   }
	   if (i==(NBR_BLOCKS-1) && new_blk == 0)
	     printf("erreur d'allocation d'un nouveau block\n");
	}
	aux[new_blk].valid = 0;
	aux[new_blk].start = 0x80000000+pi_register.pi_dram_addr_reg;
	aux[new_blk].end = aux[new_blk].start + longueur;
	aux[new_blk].length = longueur;
     }
   else
     {
	if ((pi_register.pi_dram_addr_reg+pi_register.pi_wr_len_reg)<0x400000)
	  {
	     longueur = pi_register.pi_wr_len_reg;
#ifdef _BIG_ENDIAN
	     memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		    rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		    pi_register.pi_wr_len_reg+1);
#else
	     if ((pi_register.pi_dram_addr_reg % 4) != 0)
	       printf("unaligned PI dma 1\n");
	     if ((pi_register.pi_cart_addr_reg % 4) != 0) {
		if (((longueur+1) % 4) != 0)
		  printf("unaligned PI dma 23\n");
		if ((pi_register.pi_cart_addr_reg % 4) == 2) {
		   memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg+2,
			  rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)+2,
			  longueur+1);
		   ((unsigned short*)
		    rdram)[(pi_register.pi_dram_addr_reg-2)/2]=
		     ((unsigned short*)rom)
		    [(((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)
		      - 2)/2];
		}
		else
		  printf("unaligned PI dma 2\n");
	     }
	     else if (((longueur+1) % 4) != 0) {
		if (((longueur+1) % 4) == 2) {
		   memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
			  rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
			  longueur-1);
		   ((unsigned short*)
		    rdram)[(pi_register.pi_dram_addr_reg+longueur+1)/2]=
		     ((unsigned short*)rom)
		    [(((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF)
		      + longueur+1)/2];
		}
		else
		  printf("unaligned PI dma 3\n");
	     }
	     else
	       memcpy((unsigned char *)(rdram)+pi_register.pi_dram_addr_reg,
		      rom+((pi_register.pi_cart_addr_reg-0x10000000)&0x1FFFFFFF),
		      longueur+1);
#endif
	     for (i=0; i<NBR_BLOCKS; i++) {
		if (!aux[i].valid && !aux[i].start) {
		   new_blk=i;
		   break;
		}
		if (i==(NBR_BLOCKS-1) && new_blk == 0)
		  printf("erreur d'allocation d'un nouveau block\n");
	     }
	     aux[new_blk].valid = 0;
	     aux[new_blk].start = 0x80000000+pi_register.pi_dram_addr_reg;
	     aux[new_blk].end = aux[new_blk].start + longueur;
	     aux[new_blk].length = longueur;
	  }
	else
	  {
	     printf("erreur dma\n");
	     stop=1;
	  }
     }
   MI_register.mi_intr_reg |= 0x10;
   gen_mi();
}

void dma_sp_write()
{
   if ((sp_register.sp_mem_addr_reg & 0x1000) > 0)
     {
	memcpy((unsigned char *)(SP_IMEM) + (sp_register.sp_mem_addr_reg & 0xFFF),
	       (unsigned char *)(rdram) + (sp_register.sp_dram_addr_reg & 0xFFFFFF),
	       (sp_register.sp_rd_len_reg & 0xFFF)+1);
	MI_register.mi_intr_reg |= 0x01;
	gen_mi();
     }
   else
     {
	memcpy((unsigned char *)(SP_DMEM) + (sp_register.sp_mem_addr_reg & 0xFFF),
	       (unsigned char *)(rdram) + (sp_register.sp_dram_addr_reg & 0xFFFFFF),
	       (sp_register.sp_rd_len_reg & 0xFFF)+1);
	MI_register.mi_intr_reg |= 0x01;
	gen_mi();
     }
}

void dma_sp_read()
{
   if ((sp_register.sp_mem_addr_reg & 0x1000) > 0)
     {
	printf("erreur dans dma_sp_read\n");
     }
   else
     {
	memcpy((unsigned char *)(rdram) + (sp_register.sp_dram_addr_reg & 0xFFFFFF),
	       (unsigned char *)(SP_DMEM) + (sp_register.sp_mem_addr_reg & 0xFFF),
	       (sp_register.sp_wr_len_reg & 0xFFF)+1);
	MI_register.mi_intr_reg |= 0x01;
	gen_mi();
     }
}

void dma_si_write()
{
   int i;
   if (si_register.si_pif_addr_wr64b != 0x1FC007C0)
     {
	printf("utilisation indite du SI\n");
	stop=1;
     }
   
   for (i=0; i<(64/4); i++)
     PIF_RAM[i] = sl(rdram[si_register.si_dram_addr/4+i]);
   update_pif_write();
   MI_register.mi_intr_reg |= 0x02;
   gen_mi();
}

void dma_si_read()
{
   int i;
   if (si_register.si_pif_addr_rd64b != 0x1FC007C0)
     {
	printf("utilisation indite du SI\n");
	stop=1;
     }
   update_pif_read();
   
   for (i=0; i<(64/4); i++)
     rdram[si_register.si_dram_addr/4+i] = sl(PIF_RAM[i]);
   MI_register.mi_intr_reg |= 0x02;
   gen_mi();
}
