#ifndef __3DMATH

#define __3DMATH

#ifdef __WIN32__
#include <windows.h>
#endif
#include <math.h>

typedef float MATRIX3[9];
typedef float MATRIX4[16];
typedef float VFLOAT;
typedef	float VECTOR[4];

extern void PrintMatrix4(MATRIX4 Matrix);
extern void PrintVector(VECTOR vec);
extern void PrintFloat(float f);
extern void m4_submat( MATRIX4 mr, MATRIX3 mb, int i, int j );
extern VFLOAT m4_det( MATRIX4 mr );
extern int m4_inverse( MATRIX4 mr, MATRIX4 ma );
extern int m3_inverse( MATRIX4 mr, MATRIX4 ma );
extern VFLOAT m3_det( MATRIX3 mat );
extern void TranformVector(float *src, float *dst, MATRIX4 mat);
extern float DotProduct(float *v1, float *v2);
extern void NormalizeVector(float *v);
extern BOOL compare_matrix4(MATRIX4 m1, MATRIX4 m2);

extern void transform_vector(float * vd,float x0,float y0,float z0);
extern void push_matrix(void);
extern void pop_matrix(void);
extern void load_matrix(float * m);
extern void mult_matrix(float * m);
extern void get_matrix(float * m);
extern void push_mult_matrix(float * m);
extern void push_load_matrix(float * m);

extern void calculate_light_vectors();
extern void math_lighting(t_vtx_tn *vtx, float color[4]);

#endif
