#ifndef _COMBINE_

#define _COMBINE_

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef __WIN32__
#include <windows.h>
#endif
#include <GL/gl.h>
#include <GL/glu.h>

#include "type_sizes.h"

#define CYCLE_MODE1 0
#define CYCLE_MODE2 1
#define CYCLE_COPY  2
#define CYCLE_FILL  3

extern _u8 cycle_mode;
extern _u32 cycle1;
extern _u32 cycle2;

extern void rdp_setcombine();
extern void DrawVisualTriangle(int vn[3]);
extern void BuildCombine(void);

#define UsePrim			0x01
#define UseEnv			0x02
#define UseShade		0x04

#define UsePrimAlpha		0x08
#define UseEnvAlpha			0x10
#define UseShadeAlpha		0x20
#define UsePrimAsAlpha		0x40
#define UseEnvAsAlpha		0x80
#define UseT0AsAlpha		0x100
#define UseShadeEnvFade		0x200
#define UseShadePrimFade	0x400

#define UsePrimEnv		(UsePrim | UseEnv)
#define UsePrimShade	(UsePrim | UseShade)
#define UsePrimEnvShade	(UsePrim | UseEnv | UseShade)
#define UseEnvShade		(UseEnv | UseShade)

#define UsePrimEnvAlpha			(UsePrimAlpha | UseEnvAlpha)
#define UsePrimShadeAlpha		(UsePrimAlpha | UseShadeAlpha)
#define UsePrimEnvShadeAlpha	(UsePrimAlpha | UseEnvAlpha | UseShadeAlpha)
#define UseEnvShadeAlpha		(UseEnvAlpha | UseShadeAlpha)


typedef struct
{
	int TexMode;
	int TexColor;
	int t1;
	int s1;
	int t2;
	int s2;
} t_Combine;


#endif
