#ifdef __WIN32__
#include <windows.h>
#else
#include <SDL/SDL.h>
#include "winlnxdefs.h"
#endif
#include <stdio.h>

#include "gfx.h"
#include "wingl.h"
#include "crc_ucode.h"

#ifdef USE_GTK
#include <gtk/gtk.h>
#endif

//** externals
void RealExecuteDList(unsigned __int32 dwAddr);
void RefreshVisual(void);

//** globals
BOOLEAN	 bFullScreen; // FullScreen Mode

int				*pInterruptMask;
unsigned char	*pRDRAM;
unsigned char	*pIMEM;
unsigned char	*pDMEM;
unsigned char	*pVIREG;
unsigned char	*pROM;

//BOOL			Draw2d = FALSE;
BOOL			Draw2d = TRUE;
BOOL			NoBlending = FALSE;			
int				ucode_version;
int skipCount;

HINSTANCE g_hInstance;
HWND g_hWnd;

/*
===============================================================================

  All our exported functions...

===============================================================================
*/
extern int ucode;
extern BOOL HandsetUcode;
BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD dwReason, LPVOID lpvReserved)
{
	ucode = -1;
	HandsetUcode = FALSE;

	g_hInstance = hinstDLL;


	return TRUE;
}

__declspec(dllexport) void CloseDLL (void)
{
}

extern SDL_Surface *Ecran;
__declspec(dllexport) void ChangeWindow (void)
{
   static int fullscreen = 0;
   fullscreen = 1 - fullscreen;
   Ecran = SDL_SetVideoMode(640, 480, 16,
			    ((fullscreen == 1) ? SDL_FULLSCREEN : 0) |
			    SDL_OPENGL);
}

__declspec(dllexport) void DllAbout ( HWND hParent )
{
#ifdef __WIN32__
	MessageBox(NULL, "TR64 OpenGL v0.5", "TR64 OpenGL - About Box", MB_OK|MB_ICONINFORMATION);
#else
   #ifdef USE_GTK
   GtkWidget *dialog, *label, *okay_button;
   
   /* Create the widgets */
	   
   dialog = gtk_dialog_new();
   label = gtk_label_new("TR64 OpenGL v0.5 made by Icepir8 and ported to Linux by Hacktarux");
   okay_button = gtk_button_new_with_label("OK");
   
   /* Ensure that the dialog box is destroyed when the user clicks ok. */
   
   gtk_signal_connect_object (GTK_OBJECT (okay_button), "clicked",
			      GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			      GTK_OBJECT(dialog));
   gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		      okay_button);
	
   /* Add the label, and show everything we've added to the dialog. */
   
   gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),
		      label);
   gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
   gtk_widget_show_all (dialog);
#else
   printf("TR64 OpenGL v0.5 made by Icepir8 and ported to Linux by Hacktarux");
#endif
#endif
}

__declspec(dllexport) void DllConfig ( HWND hParent )
{
#ifdef __WIN32__
	CreateConfigDlg();
#endif
}

__declspec(dllexport) void DllTest ( HWND hParent )
{
#ifdef __WIN32__
	MessageBox(NULL, "No Test Box yet", "message", MB_OK);
#else
#ifdef USE_GTK
   GtkWidget *dialog, *label, *okay_button;
   
   /* Create the widgets */
	   
   dialog = gtk_dialog_new();
   label = gtk_label_new ("No Test Box yet");
   okay_button = gtk_button_new_with_label("OK");
   
   /* Ensure that the dialog box is destroyed when the user clicks ok. */
   
   gtk_signal_connect_object (GTK_OBJECT (okay_button), "clicked",
			      GTK_SIGNAL_FUNC (gtk_widget_destroy), 
			      GTK_OBJECT(dialog));
   gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->action_area),
		      okay_button);
	
   /* Add the label, and show everything we've added to the dialog. */
   
   gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),
		      label);
   gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
   gtk_widget_show_all (dialog);
#else
        printf("No Test Box yet");
#endif
#endif
}

__declspec(dllexport) void DrawScreen (void)
{

}

__declspec(dllexport) void GetDllInfo ( PLUGIN_INFO * PluginInfo )
{	
	PluginInfo->NormalMemory = FALSE;
	PluginInfo->MemoryBswaped = TRUE;
	PluginInfo->Version = 0x0102;
	PluginInfo->Type = PLUGIN_TYPE_GFX;
	sprintf(PluginInfo->Name,"TR64 OpenGL v0.5c");
}


void (*CheckInterrupts)( void );
__declspec(dllexport) BOOL InitiateGFX (GFX_INFO Gfx_Info)
{
	pInterruptMask = (int*)Gfx_Info.MI_INTR_REG;
	pRDRAM = Gfx_Info.RDRAM;
	pDMEM = Gfx_Info.DMEM;
	pIMEM = Gfx_Info.IMEM;
	pROM = Gfx_Info.HEADER;
	pVIREG = (unsigned char*)Gfx_Info.DPC_START_REG;

	CheckInterrupts = Gfx_Info.CheckInterrupts;


	WinData.Width = 640;
	WinData.Height = 480;
	WinData.hWnd = Gfx_Info.hWnd;


	if(!WGL_Init()) return FALSE;

	return TRUE;
}

__declspec(dllexport) void MoveScreen (int xpos, int ypos)
{
}

int GetUCode();
__declspec(dllexport) void ProcessDList(void)
{
	unsigned __int32 addr = ((unsigned __int32 *)pDMEM)[0xff0>>2];

	ucode_version = GetUCode();

	RealExecuteDList(addr);
}

__declspec(dllexport) void ProcessRDPList(void)
{
}

__declspec(dllexport) void RomClosed (void)
{
#ifdef __WIN32__
	SaveUCode();
#endif
}

__declspec(dllexport) void UpdateScreen (void)
{
}

__declspec(dllexport) void ViStatusChanged (void)
{
}

__declspec(dllexport) void ViWidthChanged (void)
{
}

__declspec(dllexport) void RomOpen (void)
{
}

__declspec(dllexport) void DLL_ResetGFX (void)
{
}
