//#define DEBUG_R
#ifdef __WIN32__
#include <windows.h>
#else
#include "winlnxdefs.h"
#endif
#include <GL/gl.h>

#include "wingl.h"
#include "rdp_registers.h"
#include "Texture.h"

#define UsePrim			0x01
#define UseEnv			0x02
#define UseShade		0x04

#define UsePrimAlpha	0x08
#define UseEnvAlpha		0x10
#define UseShadeAlpha	0x20

#define UsePrimEnv		(UsePrim | UseEnv)
#define UsePrimShade	(UsePrim | UseShade)
#define UsePrimEnvShade	(UsePrim | UseEnv | UseShade)
#define UseEnvShade		(UseEnv | UseShade)

#define UsePrimEnvAlpha			(UsePrimAlpha | UseEnvAlpha)
#define UsePrimShadeAlpha		(UsePrimAlpha | UseShadeAlpha)
#define UsePrimEnvShadeAlpha	(UsePrimAlpha | UseEnvAlpha | UseShadeAlpha)
#define UseEnvShadeAlpha		(UseEnvAlpha | UseShadeAlpha)

//** externals
extern int SetActiveTexture();
extern t_rdp_reg rdp_reg;
extern HWND hGraphics;
extern int TexMode;
extern _u32 TexColor;
extern int ucode_version;

char output[1024];
char render_output[1024];

  static char *Mode[] = { "CC_COMBINED" ,   	      "CC_TEXEL0" ,
						  "CC_TEXEL1" ,		  "CC_PRIMITIVE" ,
						  "CC_SHADE" ,			  "CC_ENVIRONMENT" ,
						  "CC_CENTER" ,		  "CC_COMBINED_ALPHA" ,
						  "CC_TEXEL0_ALPHA" ,    "CC_TEXEL1_ALPHA" ,
						  "CC_PRIMITIVE_ALPHA" , "CC_SHADE_ALPHA" ,
						  "CC_ENV_ALPHA" ,		  "CC_LOD_FRACTION" ,
						  "CC_PRIM_LOD_FRAC" ,   "CC_K5" ,
						  "CC_UNDEFINED" ,		  "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,		  "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,		  "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,       "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,       "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,       "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,       "CC_UNDEFINED" ,
						  "CC_UNDEFINED" ,       "CC_0" };

 static char *Alpha[] = { "AC_COMBINED" ,      "AC_TEXEL0" ,
						  "AC_TEXEL1" ,        "AC_PRIMITIVE" , 
						  "AC_SHADE" ,		    "AC_ENVIRONMENT" , 
						  "AC_PRIM_LOD_FRAC" , "AC_0"};

 //** global variables
extern BOOL refresh_matrix;
extern BOOL refresh_lights;

extern _u8 uc0_a0,  uc0_b0,  uc0_c0,  uc0_d0, 
	   uc0_Aa0, uc0_Ab0, uc0_Ac0, uc0_Ad0,
       uc0_a1,  uc0_b1,  uc0_c1,  uc0_d1, 
	   uc0_Aa1, uc0_Ab1, uc0_Ac1, uc0_Ad1;

extern _u8 cycle_mode;
extern _u32 cycle1;
extern _u32 cycle2;

//** Prototypes
void Render_FlushVisualRenderBuffer(void);
void Render_load_modelview(float m[4][4]);
void Render_load_projection(float m[4][4]);
void Render_mul_modelview(float m[4][4]);
void Render_mul_projection(float m[4][4]);
void Render_push_load_modelview(float m[4][4]);
void Render_push_mul_modelview(float m[4][4]);
void Render_pop_modelview();
void Render_viewport();
void Render_lookat_x();
void Render_lookat_y();
void Render_light(int n);
void Render_line3d(int vn[]);
void Render_geometry_zbuffer(int on);
void Render_geometry_cullfront(int on);
void Render_geometry_cullback(int on);
void Render_geometry_cullfrontback(int on);
void Render_ClearVisual();
void Render_tri1(int vn[], _u8 flag);
void Render_tri2(int vn[], _u8 flag);

//** Functions
void Render_FlushVisualRenderBuffer(void)
{
//	WGL_FlushScreen();
	WGL_SwapBuffers();
}

void Render_ClearVisual()
{
		glDrawBuffer(GL_BACK);
        glClearColor(0.0, 0.0, 0.0, 1.0);
        glClearDepth(1.0);
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
}

void Render_load_modelview(float m[4][4])
{
		refresh_matrix = TRUE;
		glFlush();
        glMatrixMode(GL_MODELVIEW);
        glLoadMatrixf((GLfloat *)m);
}

void Render_load_projection(float m[4][4])
{
		refresh_matrix = TRUE;
		glFlush();
        glMatrixMode(GL_PROJECTION);
        glLoadMatrixf((GLfloat *)m);
//        glMatrixMode(GL_MODELVIEW);
}

void Render_mul_modelview(float m[4][4])
{
		refresh_matrix = TRUE;
		glFlush();
        glMatrixMode(GL_MODELVIEW);
        glMultMatrixf((GLfloat *)m);
}

void Render_mul_projection(float m[4][4])
{
		refresh_matrix = TRUE;
		glFlush();
        glMatrixMode(GL_PROJECTION);
        glMultMatrixf((GLfloat *)m);
        glMatrixMode(GL_MODELVIEW);
}

void Render_push_load_modelview(float m[4][4])
{
		refresh_matrix = TRUE;
		glFlush();
        glMatrixMode(GL_MODELVIEW);
        glPushMatrix();
        glLoadMatrixf((GLfloat *)m);
}

void Render_push_mul_modelview(float m[4][4])
{
		refresh_matrix = TRUE;
		glFlush();
        glMatrixMode(GL_MODELVIEW);
        glPushMatrix();
        glMultMatrixf((GLfloat *)m);
}

void Render_pop_modelview()
{
		refresh_matrix = TRUE;
		glFlush();
        glMatrixMode(GL_MODELVIEW);
        glPopMatrix();
}
extern WINDATA_T WinData;

//extern int WGL_sizeX;
//extern int WGL_sizeY;
int VPulx, VPuly, VPlrx, VPlry;

void Render_viewport()
{
/*	VPulx = rdp_reg.vp[4] - rdp_reg.vp[0];
	VPuly = rdp_reg.vp[5] - rdp_reg.vp[1];

	VPlrx = rdp_reg.vp[4] + rdp_reg.vp[0];
	VPlry = rdp_reg.vp[5] + rdp_reg.vp[1];

	VPulx *= 2;
	VPuly *= 2;
	VPlrx *= 2;
	VPlry *= 2;
	
    glMatrixMode(GL_PROJECTION);
	glViewport(VPulx, VPuly, VPlrx, VPlry);
//	glFrustum(VPulx, VPlrx, VPlry, VPuly, -1, 0);
//	glOrtho(VPulx, VPlrx, VPlry, VPuly, -1, 0);
*/
}

void Render_lookat_x()
{
}

void Render_lookat_y()
{
}


void Render_light(int n)
{
/*                rdp_reg.light[i].r;
                rdp_reg.light[i].g;
                rdp_reg.light[i].b;
                rdp_reg.light[i].a;
                rdp_reg.light[i].r_copy;
                rdp_reg.light[i].g_copy;
                rdp_reg.light[i].b_copy;
                rdp_reg.light[i].a_copy;
                rdp_reg.light[i].x;
                rdp_reg.light[i].y;
                rdp_reg.light[i].z;
                rdp_reg.light[i].w;

*/	
	refresh_lights = TRUE;
}

void Render_line3d(int vn[])
{
        int     i;
        float   v[4];

        glBegin(GL_LINES);

        for(i=0; i<2; i++)
        {
                v[0] = rdp_reg.vtx[vn[i]].x;   /* * perspective_normal; */
                v[1] = rdp_reg.vtx[vn[i]].y;   /* * perspective_normal; */
                v[2] = rdp_reg.vtx[vn[i]].z;   /* * perspective_normal; */
                v[3] = 1.0;   /* * perspective_normal; */

                glColor4ub(0x00, 0x99, 0x00, 0xff);
                glVertex3f(v[0],
                        v[1],
                        v[2]
                        );
        }
        glEnd();
}

void Render_geometry_zbuffer(int on)
{
        if(on)
                glEnable(GL_DEPTH_TEST);
        else
                glDisable(GL_DEPTH_TEST);
}

void Render_geometry_cullfront(int on)
{
        if(on)
        {
                glCullFace(GL_FRONT);
                glEnable(GL_CULL_FACE);
        }
        else
        {
                glDisable(GL_CULL_FACE);
        }
              //  glDisable(GL_CULL_FACE);
}

void Render_geometry_cullback(int on)
{
        if(on)
        {
                glCullFace(GL_BACK);
                glEnable(GL_CULL_FACE);
        }
        else
        {
                glDisable(GL_CULL_FACE);
        }
           //     glDisable(GL_CULL_FACE);
}

void Render_geometry_cullfrontback(int on)
{
        if(on)
        {
                glCullFace(GL_FRONT_AND_BACK);
                glEnable(GL_CULL_FACE);
        }
        else
        {
                glDisable(GL_CULL_FACE);
        }
         //       glDisable(GL_CULL_FACE);
}

//extern void MathSize(int tile_num);
void Render_TexRectangle(float xh, float yh, 
 				  	     float xl, float yl,
						 int tile_num,
						 float s, float t, 
						 float dsdx, float dtdy)
{
	t_tile *tmpTile = &rdp_reg.td[tile_num];
	//t_tile *tmpTile = rdp_reg.m_CurTile;
	float s0, t0, s1, t1;
	float fs0, ft0, fs1, ft1;
	int sHeight,sWidth;
	float color[4];
	float txl = (float)xl;
	float tyl = (float)yl;
	float txh = (float)xh;
	float tyh = (float)yh;
	
	float tw = (float)(tmpTile->Width - 1);
	float th = (float)(tmpTile->Height - 1);

	int tex1 = 1;
	int mul1 = 1;
	int twidth = rdp_reg.TextureImage.width;

	GLint hadDepthTest, hadBlending, hadAlphaTest;

	rdp_reg.m_CurTile = tmpTile;

	if ((dsdx < 0.1) && (dsdx > -0.1)) dsdx = 1;
	if ((dtdy < 0.1) && (dtdy > -0.1)) dtdy = 1;

	s1 = (xl - xh) * dsdx;
	t1 = (yl - yh) * dtdy;

	if (s1 > rdp_reg.m_CurTile->Width)
	{
		s1 /= 4;
	}

	txh -= 0.5;
	tyh -= 0.5;

	txl += 0.5;
	tyl += 0.5;

	if ((s == 0) && (t == 0))
	{
		s0 = s;
		t0 = t;
	}
	else
	{
		s0 = s - tmpTile->uls;
		t0 = t - tmpTile->ult;
	}

	s1 += s0;
	t1 += t0;

	if (t < 0) t=0;
	if (s < 0) s=0;

	if (t1 < 0) t1=0;
	if (s1 < 0) s1=0;

	if (tw < 1) tw++;
	if (th < 1) th++;

	fs0 = (float)s0 / tw;
	ft0 = (float)t0 / th;
	fs1 = (float)s1 / tw;
	ft1 = (float)t1 / th;


//** Set to 2d ...
	tex1 = 1;
	mul1 = 0;
	TexMode = 0;
	TexColor = 0;
	if (cycle_mode > 1)
		tex1 = 1;
	else
	switch (cycle1)
	{
	case 0x03b22e32: // k5,k5,0,t0,0,0,0,t0
		tex1 = 1;
		break;
	case 0x03ff2c32: // k5,k5,0,t0,0,0,0,t0
		tex1 = 1;
		break;
	case 0x03ff3fff: // k5,k5,0,t0,0,0,0,t0
		tex1 = 1;
		break;
	case 0x03ff7fff: // k5,k5,0,prim,0,0,0,t0
		tex1 = 1;
		TexMode = AlphaT0;
		mul1 = UsePrim;
		break;
	case 0x03ff8145: // env,shade,t0,shade,0,0,0,t0
		tex1 = 1;
		mul1 = UseEnv;
		break;
	case 0x03ffe1f3: // prim,k5,t0,ca,0,0,0,t0
		tex1 = 1;
		mul1 = UsePrim;
		break;
	case 0x03ffe3f1: // t0,k5,prim,ca,0,0,0,t0
		tex1 = 1;
		mul1 = UsePrim;
		break;
	case 0x03ffe5f1: // t0,k5,env,ca,0,0,0,t0
		tex1 = 1;
		mul1 = UseEnv;
		break;
	case 0x07ffe3f1: // t0,k5,prim,ca,0,0,0,t0
		tex1 = 1;
		mul1 = UsePrim;
		break;
	case 0x07ff3fff: // k5,k5,0,t0,0,0,0,prim
		tex1 = 1;
		TexMode = Tex;
		mul1 = UsePrim | UsePrimAlpha;
		break;
	case 0x07ff7fff: // k5,k5,0,prim,0,0,0,prim
		//tex1 = 0;
		mul1 = UsePrim | UsePrimAlpha;
		break;
	case 0x08638143: // prim,shade,t0,shade,prim,shade,t0,shade
		tex1 = 1;
		mul1 = UsePrim | UsePrimAlpha;
		break;
	case 0x09ff3fff: // k5,k5,0,t0,0,0,0,shade
//		mul1 = UseShade;
		TexMode = Tex;
		tex1 = 1;
		break;
	case 0x09ffe4f1: // t0,k5,shade,0,0,0,0,shade
//		mul1 = UseShade;
		//TexMode = Tex;
		tex1 = 1;
		break;
	case 0x09ff9fff: //
//		mul1 = UsePrim;
		tex1 = 1;
		break;
	case 0x0bff3fff: // t0,k5,env,ca,t0,0,env,0
		tex1 = 1;
		mul1 = UseEnv | UseEnvAlpha;
		break;
	case 0x0e7b6156: // cent,env,t0,prim,prim,0,t0,0
		tex1 = 1;
		//mul1 = UsePrim | UsePrimAlpha;
		mul1 = UsePrimAlpha;
		break;
	case 0x0e7b3fff: // k5,k5,0,t0,prim,0,t0,0
		tex1 = 1;
		mul1 = UsePrimAlpha;
		break;
	case 0x0e7b7fff: // k5,k5,0,prim,0,0,0,t0
		tex1 = 1;
		TexMode = AlphaT0;
		mul1 = UsePrim | UsePrimAlpha;
		break;
	case 0x0ef92e13: // prim,t0,primlod,t0,t0,0,prim,0
		tex1 = 1;
		mul1 = UsePrimAlpha;
		break;
	case 0x0ef97fff: // k5,k5,0,prim,t0,0,prim,0
		tex1 = 1;
		TexMode = AlphaT0;
		mul1 = UsePrim | UsePrimAlpha;
		break;
	case 0x0ef9a153: // env,prim,t0,env,t0,0,prim,0
		//TexMode = Prim_Sub_Env_Mult_Tex_Add_Env;
		tex1 = 1;
		mul1 = UsePrimAlpha;
		break;
	case 0x0f7a3fff: // k5,k5,0,t0,t1,0,env,0
		tex1 = 1;
		mul1 = UseEnvAlpha;
		break;
	case 0x0f7ae5f1: // t0,k5,env,0,t1,0,env,0
		tex1 = 1;
		mul1 = UseEnv | UseEnvAlpha;
		break;
	case 0x0e7be3f1: // prim,k5,t0,ca,prim,0,t0,0
	case 0x0ef9e1f3: // prim,k5,t0,ca,t0,0,prim,0
		tex1 = 1;
		mul1 = UsePrim | UsePrimAlpha;
		break;
	case 0x0ef9e3f1: // t0,k5,prim,ca,t0,0,prim,0
		tex1 = 1;
		mul1 = UsePrim | UsePrimAlpha;
		break;
	case 0x0ef93fff: // k5,k5,0,t0,t0,0,prim,0
		tex1 = 1;
		mul1 = UsePrimAlpha;
		break;
	case 0x0efbe3f3: // prim,k5,prim,ca,prim,0,prim,0
		mul1 = UsePrimAlpha;
		break;
	case 0x0f39e4f1: // t0,k5,shade,0,t0,0,shade,0
		tex1 = 1;
		break;
	case 0x0f793fff: // k5,k5,0,t0,t0,0,env,0
		tex1 = 1;
		mul1 = UseEnvAlpha;
		break;
	case 0x0f79bfff: // k5,k5,0,env,t0,0,env,0
		tex1 = 1;
		TexMode = AlphaT0;
		mul1 = UseEnv | UseEnvAlpha;
		break;
	case 0x0f79e5f1: // t0,k5,env,ca,t0,0,env,0
		tex1 = 1;
		mul1 = UseEnv | UseEnvAlpha;
		break;
	default:
#ifdef DEBUG_R
		sprintf(output,"Mode1 = %6x Mode2 = %6x\na0  = %s, b0  = %s, c0  = %s, d0  = %s\nAa0 = %s, Ab0 = %s, Ac0 = %s, Ad0 = %s\na1  = %s, b1  = %s, c1  = %s, d1  = %s\nAa1 = %s, Ab1 = %s, Ac1 = %s, Ad1 = %s\n",
			cycle1,cycle2,
			Mode[uc0_a0],   Mode[uc0_b0],   Mode[uc0_c0],   Mode[uc0_d0],
			Alpha[uc0_Aa0], Alpha[uc0_Ab0], Alpha[uc0_Ac0], Alpha[uc0_Ad0],
			Mode[uc0_a1],   Mode[uc0_b1],   Mode[uc0_c1],   Mode[uc0_d1],
			Alpha[uc0_Aa1], Alpha[uc0_Ab1], Alpha[uc0_Ac1], Alpha[uc0_Ad1]);
	MessageBox(hGraphics, output, "DisplayRect", MB_OK);
	exit(1);
#endif
		;
	}

	sWidth = rdp_reg.colorimg_width;
	sHeight = (sWidth * 3) >> 2;

	glGetIntegerv(GL_DEPTH_TEST, &hadDepthTest); //** Should be glGetBooleanv, but 
	glGetIntegerv(GL_BLEND, &hadBlending); //** Should be glGetBooleanv, but 
	glGetIntegerv(GL_ALPHA_TEST, &hadAlphaTest); //** Should be glGetBooleanv, but 

	glPushAttrib(GL_ENABLE_BIT);

	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);
//	glDisable(GL_ALPHA_TEST);
	glEnable(GL_BLEND);

    glMatrixMode(GL_PROJECTION);
	glPushMatrix();
    glLoadIdentity();
	glOrtho(0, sWidth, sHeight, 0, 0, 1);
    glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
    glLoadIdentity();

	if (tex1 == 1)
	{
		//SetActiveTextureTexRect((int)s,(int)t,(int)s1,(int)t1);
		SetActiveTexture();
		glEnable(GL_TEXTURE_2D);
	}

		color[0] = 1.0f;
		color[1] = 1.0f;
		color[2] = 1.0f;
		color[3] = 1.0f;

		if ((mul1 & UsePrim) != 0)
		{
			color[0] = color[0] * (((rdp_reg.primcolor >> 24) & 0xff) / 255.0f);
			color[1] = color[1] * (((rdp_reg.primcolor >> 16) & 0xff) / 255.0f);
			color[2] = color[2] * (((rdp_reg.primcolor >>  8) & 0xff) / 255.0f);
		}

		if ((mul1 & UseEnv) != 0)
		{
			color[0] = color[0] * (((rdp_reg.envcolor >> 24) & 0xff) / 255.0f);
			color[1] = color[1] * (((rdp_reg.envcolor >> 16) & 0xff) / 255.0f);
			color[2] = color[2] * (((rdp_reg.envcolor >>  8) & 0xff) / 255.0f);
		}

		if ((mul1 & UsePrimAlpha) != 0)
		{
			color[3] = color[3] * ((rdp_reg.primcolor & 0xff) / 255.0f);
		}

		if ((mul1 & UseEnvAlpha) != 0)
		{
			color[3] = color[3] * ((rdp_reg.envcolor & 0xff) / 255.0f);
		}

		glColor4fv(color);

	glBegin(GL_QUADS);
		if (tex1 == 1)
		{
			glTexCoord2f(fs1, ft1);
			glVertex2f(txl, tyl);
		
			glTexCoord2f(fs0, ft1);
			glVertex2f(txh, tyl);
		
			glTexCoord2f(fs0, ft0);
			glVertex2f(txh, tyh);
		
			glTexCoord2f(fs1, ft0);
			glVertex2f(txl, tyh);
		}
		else
		{
			glVertex2f(txl, tyl);
			glVertex2f(txh, tyl);
			glVertex2f(txh, tyh);
			glVertex2f(txl, tyh);
		}
	glEnd();

	glPopMatrix();
    glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glPopAttrib();

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glAlphaFunc(GL_GEQUAL,0.005f);

	if (hadBlending) glEnable(GL_BLEND);
	if (hadDepthTest) glEnable(GL_DEPTH_TEST);
	if (hadAlphaTest) glEnable(GL_ALPHA_TEST);

//	glCallList(kListEnd2D);

}

void Render_FillRectangle(int xh, int yh, 
 				  	     int xl, int yl,
						 _u32 fillclr)
{
	GLint hadDepthTest, hadBlending, hadAlphaTest;

	int sHeight,sWidth;
	float color[4];
	float txl = (float)xl+0.5;
	float tyl = (float)yl+0.5;
	float txh = (float)xh-0.5;
	float tyh = (float)yh-0.5;

//** Set to 2d ...
	//return;

	sWidth = rdp_reg.colorimg_width;
	sHeight = (sWidth * 3) >> 2;

	glGetIntegerv(GL_DEPTH_TEST, &hadDepthTest); //** Should be glGetBooleanv, but 
	glGetIntegerv(GL_BLEND, &hadBlending);		 //** Should be glGetBooleanv, but 
	glGetIntegerv(GL_ALPHA_TEST, &hadAlphaTest); //** Should be glGetBooleanv, but 

	glPushAttrib(GL_ENABLE_BIT);

	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);

    glMatrixMode(GL_PROJECTION);
	glPushMatrix();
    glLoadIdentity();
	glOrtho(0, sWidth, sHeight, 0, 0, 1);
    glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
    glLoadIdentity();
/*
	color[0] = ((fillclr      ) & 0xff) / 255.0f;
	color[1] = ((fillclr >>  8) & 0xff) / 255.0f;
	color[2] = ((fillclr >> 16) & 0xff) / 255.0f;
	color[3] = ((fillclr >> 24) & 0xff) / 255.0f;
*/

	color[0] = ((((fillclr >> 11 ) & 0x001f)<<3)) / 255.0f;
	color[1] = ((((fillclr >>  6 ) & 0x001f)<<3)) / 255.0f;
	color[2] = ((((fillclr >>  1 ) & 0x001f)<<3)) / 255.0f;
	color[3] = ((fillclr & 0x01) ? 0xff : 0x00) / 255.0f;

	glColor4fv(color);

	glBegin(GL_QUADS);
		{
			glVertex2f(txl, tyl);
			glVertex2f(txh, tyl);
			glVertex2f(txh, tyh);
			glVertex2f(txl, tyh);
		}
	glEnd();

	glPopAttrib();
	glPopMatrix();
    glMatrixMode(GL_PROJECTION);
	glPopMatrix();

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glAlphaFunc(GL_GEQUAL,0.005f);

	if (hadBlending) glEnable(GL_BLEND);
	if (hadDepthTest) glEnable(GL_DEPTH_TEST);
	if (hadAlphaTest) glEnable(GL_ALPHA_TEST);

//	glCallList(kListEnd2D);

}

void Render_tri1(int vn[], _u8 flag)
{
/*	int i;

	int width  = rdp_reg.td[rdp_reg.loadtile].lrs - rdp_reg.td[rdp_reg.loadtile].uls + 1; 
	int height = rdp_reg.td[rdp_reg.loadtile].lrt - rdp_reg.td[rdp_reg.loadtile].ult + 1; 
	width  >>= rdp_reg.td[rdp_reg.loadtile].shifts;
	height >>= rdp_reg.td[rdp_reg.loadtile].shiftt;


	if (rdp_reg.texture[rdp_reg.loadtile].scale_s == 0) rdp_reg.texture[rdp_reg.loadtile].scale_s = 1;
	if (rdp_reg.texture[rdp_reg.loadtile].scale_t == 0) rdp_reg.texture[rdp_reg.loadtile].scale_t = 1;

	glColor3f(1.0f, 1.0f, 1.0f);

	Load_ActiveTexture(rdp_reg.loadtile);

	glEnable(GL_TEXTURE_2D);
	glBegin(GL_TRIANGLES);
	for(i=0; i<3; i++)
	{
		t_vtx *vertex = &rdp_reg.vtx[vn[i]];
		float s = vertex->s * rdp_reg.texture[rdp_reg.loadtile].scale_s / (float)width;
		float t = vertex->t * rdp_reg.texture[rdp_reg.loadtile].scale_t / (float)height;
		glTexCoord2f(s, t);

		glVertex3f((float)vertex->x,
				   (float)vertex->y,
				   (float)vertex->z);
	}
	glEnd();*/
}

void Render_tri2(int vn[], _u8 flag)
{
	Render_tri1(vn, flag);
	Render_tri1(vn+3, flag);
}

void Render_DrawVisualRectangle(int ulx, int uly, int lrx, int lry)
{
        glCallList(rdp_reg.colorimg_width);
//            glBegin(GL_LINE_STRIP);
		      glBegin(GL_TRIANGLE_STRIP);
                glColor3ub(0x3f, 0x3f, 0xcf);
                glVertex2f((float)ulx, (float)uly);
                glVertex2f((float)lrx, (float)uly);
                glVertex2f((float)lrx, (float)lry);
                glVertex2f((float)ulx, (float)lry);
                glVertex2f((float)ulx, (float)uly);
            glEnd();
        glCallList(kListEnd2D);

} /* void DrawVisualRectangle(int ulx, int uly, int lrx, int lry) */







void Render_triangle(int vn[])
{
        int     i;
        float   v[3];

		glDisable(GL_TEXTURE_2D);

        glBegin(GL_TRIANGLES);

        for(i=0; i<3; i++)
        {
                v[0] = rdp_reg.vtx[vn[i]].x;   // perspective_normal;
                v[1] = rdp_reg.vtx[vn[i]].y;   // perspective_normal;
                v[2] = rdp_reg.vtx[vn[i]].z;   // perspective_normal;

                glColor4ub( rdp_reg.vtx[vn[i]].r,
							rdp_reg.vtx[vn[i]].g,
							rdp_reg.vtx[vn[i]].b, 0xff);
//                glColor4ub( 255,255,255,255);

                glVertex3f( v[0],
                            v[1],
                            v[2]);
        }
        glEnd();
}

