#ifdef __WIN32__
#include <windows.h>
#else
#include "winlnxdefs.h"
#endif
#include <GL/gl.h>
#include <GL/glu.h>
#include <stdio.h>
#include <stdlib.h>

#include "rdp_registers.h"
#include "Texture.h"

//** externals
extern int				*pInterruptMask;
extern unsigned char	*pRDRAM;
extern unsigned char	*pIDMEM;
extern unsigned char	*pVIREG;
extern HWND hGraphics;
extern int ucode_version;

//** texture - caching
#define CACHE_TEXTURES
#define MAX_CACHED_TEXTURES 4096
//#define MAX_CACHED_TEXTURES 512
static t_old_texture old_texture[MAX_CACHED_TEXTURES];
static t_index_texture index_texture[MAX_CACHED_TEXTURES];
unsigned int num_cached_texture = 1;

//** global variables

//#define TBUFFERSIZE  256*256*4
#define TBUFFERSIZE  1024*512*4
static unsigned char tbuffer0[TBUFFERSIZE];
static unsigned char tbuffer1[TBUFFERSIZE];
static unsigned char tbuffer2[TBUFFERSIZE];

int TexMode = 0;
_u32 TexColor = 0;

//** prototypes
static int TestPower2(int width, int height, int *nw, int *nh);

static void NCopyTextureRGBA32(_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);
static void NCopyTextureRGBA16(_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);
static void NCopyTextureCI8   (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);
static void NCopyTextureCI4   (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);
static void NCopyTextureIA16  (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);
static void NCopyTextureIA8   (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);
static void NCopyTextureIA4   (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);
static void NCopyTextureI16   (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);
static void NCopyTextureI8    (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);
static void NCopyTextureI4    (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);
//static void NCopyTextureYUV   (_u8 *i_src, _u8 *i_dst, _u32 sx, _u32 ex, _u32 sy, _u32 ey);

static NCopyTexture lpNCopyTexture[20] =
	{
		NCopyTextureCI4,
		NCopyTextureCI8,
		NCopyTextureRGBA16,
		NCopyTextureRGBA32,

		NCopyTextureCI4,    //  unsupported YUV modes
		NCopyTextureCI8,
		NCopyTextureRGBA16,
		NCopyTextureRGBA32,

		NCopyTextureCI4,
		NCopyTextureCI8,
		NCopyTextureRGBA16,
		NCopyTextureRGBA32,

		NCopyTextureIA4,
		NCopyTextureIA8,
		NCopyTextureIA16,
		NCopyTextureIA4,

		NCopyTextureI4,
		NCopyTextureI8,
		NCopyTextureI16,
		NCopyTextureI4
};
/******************************************************************************\
*                                                                              *
*   helper routines									  						   *
*                                                                              *
\******************************************************************************/

_u32 Palette8[256];
/*
static int TestPower2(int width, int height, int *nw, int *nh)
{
	int w;
	int temp, NewWidth = *nw, NewHeight = *nh;
	
//** test if width has the power of 2
	temp = width;
	for (w =11; w>= 0; w--)
	{
		if(temp&0x800)
		{
			NewWidth = (1<<w);
			break;
		}
		temp<<=1;
	}
//** test if height has the power of 2
	temp = height;
	for (w =11; w>= 0; w--)
	{
		if(temp&0x800)
		{
			NewHeight = (1<<w);
			break;
		}
		temp<<=1;
	}
//** return
	if ((NewWidth == width) && (NewHeight == height)) return 1;
	else
	{
		*nw = NewWidth;
		*nh = NewHeight;
		return 0;
	}
	return 1;
}
*/
void DelTexture()
{
	int i, v[MAX_CACHED_TEXTURES];
	_u16 *text;
	for (i=1; i < num_cached_texture; i ++)
	{
		text = old_texture[i].addr;
		v[i-1] = i;
		if ( (*text == 0xFF00) && (*(text+1) ==0xFE01) && (*(text+2) == i) )
		{
			text = old_texture[i].addr;
			*text = old_texture[i].old_bytes[0]; text++;
			*text = old_texture[i].old_bytes[1]; text++;
			*text = old_texture[i].old_bytes[2];
		}
		index_texture[i].TexID		= -1;
		index_texture[i].TexColor	= -1;
		index_texture[i].TexMode	= -1;
		index_texture[i].offset		= -1;
		index_texture[i].NextID		= -1;
		index_texture[i].Palette	= -1;
		index_texture[i].Size		= -1;
		
	}	
	glDeleteTextures(num_cached_texture-1,v);
	num_cached_texture=1;
}

static int TestPower2(int width, int height, int *nw, int *nh)
{
	int w;
	int temp, NewWidth = *nw, NewHeight = *nh;
	
//** test if width has the power of 2
	temp = 1;
	for (w = 0; w <= 9;w++)
	{
		NewWidth = temp;
		temp = temp << 1;
		if (NewWidth >= width)
		{
			break;
		}
	}
//** test if height has the power of 2
	temp = 1;
	for (w = 0; w <= 9;w++)
	{
		NewHeight = temp;
		temp = temp << 1;
		if (NewHeight >= height)
		{
			break;
		}
	}
//** return
	if ((NewWidth == width) && (NewHeight == height)) return 1;
	else
	{
		*nw = NewWidth;
		*nh = NewHeight;
		return 0;
	}
	return 1;
}

/******************************************************************************\
*                                                                              *
*   Texture Handling								  						   *
*                                                                              *
\******************************************************************************/
int twidth,tstart;
extern int TextWidth;

int DecompressTexture(t_tile *tmpTile,unsigned char *textaddr,int select)
{
	unsigned char *src  = &pRDRAM[(rdp_reg.TextureImage.addr + tmpTile->tmem) & 0x07fffff];
//	unsigned char *src  = textaddr;
	unsigned char *dest;

	_s32  tuls, tlrs, tult, tlrt;

    int width  = tmpTile->lrs - tmpTile->uls;
    int height = tmpTile->lrt - tmpTile->ult;

	_u8 size   = tmpTile->size;
	_u8 format = tmpTile->format;

	src = &pRDRAM[(rdp_reg.TextureImage.addr + tmpTile->tmem) & 0x07fffff];
	//src = &pRDRAM[tmpTile->addr];

	width = tmpTile->Width;
	
	if (select == 0)
		dest = (char *)&tbuffer1[0];
	else
		dest = (char *)&tbuffer0[0];

	twidth = rdp_reg.TextureImage.width;
//	twidth = tmpTile->line;

	if ((rdp_reg.TextureImage.size == (tmpTile->size + 1)) && (tmpTile->size == 0))
		twidth += twidth;

	if (width < 0) width = - width;
	if (height < 0) height = - height;

//	width++;
	height++;

	if (twidth < 0) twidth = -twidth;

	if (twidth <= 2) twidth = width;
//	if (twidth <= 2) twidth = tmpTile->line;
	tstart = width & 1;

	if (tmpTile->lrs > twidth)
	{
		tmpTile->lrs--;
		tmpTile->uls--;
	}

	tuls = tmpTile->uls;
	tlrs = tmpTile->lrs;
	tult = tmpTile->ult;
	tlrt = tmpTile->lrt;

	lpNCopyTexture[format << 2 | size](src, dest, tuls, tlrs, tult, tlrt);
	return 0;
}


int ModTexture(int tTexMode,int Length)
{
	int i; 
	_u32 tmp = 0, tmpClr,tmpClr2;
	int tT0r,tT0g,tT0b,tT0a;
	_u32 *dest = (_u32 *)tbuffer1;

//	return 1;

	switch (tTexMode)
	{
	case 0:// no changes
		return 1;
	case AlphaT0:
		for (i=0;i<Length;i++)
		{
			*(dest) |= 0x00ffffff;
			dest++;
		}
		break;
		//AlphaT0Red
	case AlphaT0Red:
		for (i=0;i<Length;i++)
		{
			*((_u8 *)(dest+3)) = *((_u8 *)dest);
			dest++;
		}
		break;
	case Tex:
		for (i=0;i<Length;i++)
		{
			*(dest) |= 0xff000000;
			dest++;
		}
		break;
	case Alpha_Mult_Prim:
		tmpClr = ((rdp_reg.primcolor >> 24) & 0xff);
		for (i=0;i<Length;i++)
		{
			tT0a = (*dest & 0xff000000) >> 24;
			tT0a *= tmpClr;
			tT0a >>= 8;
			if (tT0a < 0) tT0a = 0;
			if (tT0a > 0xff) tT0a = 0xff;
			tT0b = *dest & 0xffffff;
			*(dest) = (tT0a<<24) | tT0b;
			dest++;
		}
		break;
	case Alpha_Mult_Env:
		tmpClr = ((rdp_reg.envcolor >> 24) & 0xff);
		for (i=0;i<Length;i++)
		{
			tT0a = (*dest & 0xff000000) >> 24;
			tT0a *= tmpClr;
			tT0a >>= 8;
			if (tT0a < 0) tT0a = 0;
			if (tT0a > 0xff) tT0a = 0xff;
			tT0b = *dest & 0xffffff;
			*(dest) = (tT0a<<24) | tT0b;
			dest++;
		}
		break;
	case Tex | AlphaT0:
		break;
	case Prim_Sub_Tex:
//		tmpClr = ((rdp_reg.primcolor & 0xff) << 24) | ((rdp_reg.primcolor & 0xff00) << 8) | ((rdp_reg.primcolor & 0xff0000) >> 8) | (rdp_reg.primcolor >> 24);
		tmpClr = ((rdp_reg.primcolor & 0xff) << 24) | 
			(((rdp_reg.primcolor & 0xff00) << 16) >> 8) | 
			(((rdp_reg.primcolor & 0xff0000) << 8) >> 16)| 
			((rdp_reg.primcolor & 0xff000000) >> 24);
		for (i=0;i<Length;i++)
		{
			tT0r = (tmpClr & 0xff) - (*dest & 0xff);
			tT0g = (tmpClr & 0xff00) - (*dest & 0xff00);
			tT0b = (tmpClr & 0xff0000) - (*dest & 0xff0000);
			if (tT0r < 0) tT0r = 0;
			if (tT0g < 0) tT0g = 0;
			if (tT0b < 0) tT0b = 0;
			tT0a = *dest & 0xff000000;
			*dest = tT0r | tT0g | tT0b | tT0a;
			dest++;
		}
		break;
	case Env_Sub_Tex:
		tmpClr = ((rdp_reg.envcolor & 0xff) << 24) | ((rdp_reg.envcolor & 0xff00) << 8) | ((rdp_reg.envcolor & 0xff0000) >> 8) | (rdp_reg.envcolor >> 24);
		tmpClr = (tmpClr >> 1) | 0x808080;
		for (i=0;i<Length;i++)
		{
			tT0r = (tmpClr & 0xff) - (*dest & 0xff);
			tT0g = (tmpClr & 0xff00) - (*dest & 0xff00);
			tT0b = (tmpClr & 0xff0000) - (*dest & 0xff0000);
			if (tT0r < 0) tT0r = 0;
			if (tT0g < 0) tT0g = 0;
			if (tT0b < 0) tT0b = 0;
			tT0a = *dest & 0xff000000;
			*dest = tT0r | tT0g | tT0b | tT0a;
			dest++;
		}
		break;
	case Prim_Sub_Tex | Tex:
		tmpClr = ((rdp_reg.primcolor & 0xff) << 24) | ((rdp_reg.primcolor & 0xff00) << 8) | ((rdp_reg.primcolor & 0xff0000) >> 8) | ((rdp_reg.primcolor >> 24) &0xff);
		for (i=0;i<Length;i++)
		{
			tT0r = (tmpClr & 0xff) * (1.0f - ((*dest & 0xff) / 255.0f));
			tT0r += (*dest & 0xff);
			tT0g = (tmpClr & 0xff00) * (1.0f -(((*dest & 0xff00) >> 8) / 255.0f));
			tT0g += (*dest & 0xff00);
			tT0b = (tmpClr & 0xff0000) * (1.0f - (((*dest & 0xff0000) >> 16) / 255.0f));
			tT0b += (*dest & 0xff0000);
			if (tT0r < 0) tT0r = 0;
			if (tT0g < 0) tT0g = 0;
			if (tT0b < 0) tT0b = 0;
			if (tT0r > 0xff) tT0r = (_u32)0xff;
			if (tT0g > 0xff00) tT0g = (_u32)0xff00;
			if (tT0b > 0xff0000) tT0b = (_u32)0xff0000;
			tT0r &= (_u32)0x0ff;
			tT0g &= (_u32)0x0ff00;
			tT0b &= (_u32)0x0ff0000;
			tT0a = *dest & 0xff000000;
			*dest = tT0r | tT0g | tT0b | tT0a;
			dest++;
		}
		break;
	case Tex_Sub_Prim:
//		tmpClr = ((rdp_reg.primcolor & 0xff) << 24) | ((rdp_reg.primcolor & 0xff00) << 8) | ((rdp_reg.primcolor & 0xff0000) >> 8) | (rdp_reg.primcolor >> 24);
		tmpClr = ((rdp_reg.primcolor & 0xff) << 24) | 
			(((rdp_reg.primcolor & 0xff00) << 16) >> 8) | 
			(((rdp_reg.primcolor & 0xff0000) << 8) >> 16)| 
			((rdp_reg.primcolor & 0xff000000) >> 24);
		for (i=0;i<Length;i++)
		{
			tT0r = (*dest & 0xff) - (tmpClr & 0xff);
			tT0g = (*dest & 0xff00) - (tmpClr & 0xff00);
			tT0b = (*dest & 0xff0000) - (tmpClr & 0xff0000);
			if (tT0r < 0) tT0r = 0;
			if (tT0g < 0) tT0g = 0;
			if (tT0b < 0) tT0b = 0;
			tT0a = *dest & 0xff000000;
			*dest = tT0r | tT0g | tT0b | tT0a;
			dest++;
		}
		break;
	case Tex_Sub_Env:
		tmpClr = ((rdp_reg.envcolor & 0xff) << 24) | ((rdp_reg.envcolor & 0xff00) << 8) | ((rdp_reg.envcolor & 0xff0000) >> 8) | (rdp_reg.envcolor >> 24);
		//tmpClr = (tmpClr >> 1) | 0x808080;
		for (i=0;i<Length;i++)
		{
			tT0r = (*dest & 0xff) - (tmpClr & 0xff);
			tT0g = (*dest & 0xff00) - (tmpClr & 0xff00);
			tT0b = (*dest & 0xff0000) - (tmpClr & 0xff0000);
			if (tT0r < 0) tT0r = 0;
			if (tT0g < 0) tT0g = 0;
			if (tT0b < 0) tT0b = 0;
			tT0a = *dest & 0xff000000;
			*dest = tT0r | tT0g | tT0b | tT0a;
			dest++;
		}
		break;
	case Tex_Sub_Env_Mult_Prim_Add_Env:
		tmpClr = ((rdp_reg.envcolor & 0xff) << 24) | 
			((rdp_reg.envcolor & 0xff00) << 8) | 
			((rdp_reg.envcolor & 0xff0000) >> 8) | 
			(rdp_reg.envcolor >> 24);
		tmpClr2 = ((rdp_reg.primcolor & 0xff) << 24) | 
			(((rdp_reg.primcolor & 0xff00) << 16) >> 8) | 
			(((rdp_reg.primcolor & 0xff0000) << 8) >> 16)| 
			((rdp_reg.primcolor & 0xff000000) >> 24);
		for (i=0;i<Length;i++)
		{
			tT0r = ((*dest & 0xff) - (tmpClr & 0xff));
			tT0g = ((*dest & 0xff00) - (tmpClr & 0xff00)) >> 8;
			tT0b = ((*dest & 0xff0000) - (tmpClr & 0xff0000)) >> 16;

			tT0r *= (tmpClr2 & 0xff);
			tT0g *= ((tmpClr2 >>  8) & 0xff);
			tT0b *= ((tmpClr2 >> 16) & 0xff);

			tT0r >>= 8;
			tT0g >>= 8;
			tT0b >>= 8;

			tT0r += (tmpClr & 0xff);
			tT0g += (tmpClr & 0xff00) >> 8;
			tT0b += (tmpClr & 0xff0000) >> 16;

			if (tT0r < 0) tT0r = 0;
			if (tT0g < 0) tT0g = 0;
			if (tT0b < 0) tT0b = 0;

			if (tT0r > 0xff) tT0r = 0xff;
			if (tT0g > 0xff) tT0g = 0xff;
			if (tT0b > 0xff) tT0b = 0xff;

			tT0a = *dest & 0xff000000;
			*dest = tT0r | (tT0g << 8)| (tT0b << 16)| tT0a;
			dest++;
		}
		break;
	case Tex_Sub_Prim_Mult_Env_Add_Prim:
		tmpClr2 = ((rdp_reg.envcolor & 0xff) << 24) | 
			((rdp_reg.envcolor & 0xff00) << 8) | 
			((rdp_reg.envcolor & 0xff0000) >> 8) | 
			(rdp_reg.envcolor >> 24);
		tmpClr = ((rdp_reg.primcolor & 0xff) << 24) | 
			(((rdp_reg.primcolor & 0xff00) << 16) >> 8) | 
			(((rdp_reg.primcolor & 0xff0000) << 8) >> 16)| 
			((rdp_reg.primcolor & 0xff000000) >> 24);
		for (i=0;i<Length;i++)
		{
			tT0r = ((*dest & 0xff) - (tmpClr & 0xff));
			tT0g = ((*dest & 0xff00) - (tmpClr & 0xff00)) >> 8;
			tT0b = ((*dest & 0xff0000) - (tmpClr & 0xff0000)) >> 16;

			tT0r *= (tmpClr2 & 0xff);
			tT0g *= ((tmpClr2 >>  8) & 0xff);
			tT0b *= ((tmpClr2 >> 16) & 0xff);

			tT0r >>= 8;
			tT0g >>= 8;
			tT0b >>= 8;

			tT0r += (tmpClr & 0xff);
			tT0g += (tmpClr & 0xff00) >> 8;
			tT0b += (tmpClr & 0xff0000) >> 16;

			if (tT0r < 0) tT0r = 0;
			if (tT0g < 0) tT0g = 0;
			if (tT0b < 0) tT0b = 0;

			if (tT0r > 0xff) tT0r = 0xff;
			if (tT0g > 0xff) tT0g = 0xff;
			if (tT0b > 0xff) tT0b = 0xff;

			tT0a = *dest & 0xff000000;
			*dest = tT0r | (tT0g << 8)| (tT0b << 16)| tT0a;
			dest++;
		}
		break;
	case Tex_Sub_Env_Mult_Tex_Add_Prim:
		tmpClr = ((rdp_reg.envcolor & 0xff) << 24) | 
			((rdp_reg.envcolor & 0xff00) << 8) | 
			((rdp_reg.envcolor & 0xff0000) >> 8) | 
			(rdp_reg.envcolor >> 24);
		tmpClr2 = ((rdp_reg.primcolor & 0xff) << 24) | 
			(((rdp_reg.primcolor & 0xff00) << 16) >> 8) | 
			(((rdp_reg.primcolor & 0xff0000) << 8) >> 16)| 
			((rdp_reg.primcolor & 0xff000000) >> 24);
		for (i=0;i<Length;i++)
		{
			tT0r = ((*dest & 0xff) - (tmpClr & 0xff));
			tT0g = ((*dest & 0xff00) - (tmpClr & 0xff00)) >> 8;
			tT0b = ((*dest & 0xff0000) - (tmpClr & 0xff0000)) >> 16;

			tT0r *= ((*dest & 0xff) & 0xff);
			tT0g *= ((*dest >>  8) & 0xff);
			tT0b *= ((*dest >> 16) & 0xff);

			tT0r >>= 8;
			tT0g >>= 8;
			tT0b >>= 8;

			tT0r += (tmpClr2 & 0xff);
			tT0g += (tmpClr2 & 0xff00) >> 8;
			tT0b += (tmpClr2 & 0xff0000) >> 16;

			if (tT0r < 0) tT0r = 0;
			if (tT0g < 0) tT0g = 0;
			if (tT0b < 0) tT0b = 0;

			if (tT0r > 0xff) tT0r = 0xff;
			if (tT0g > 0xff) tT0g = 0xff;
			if (tT0b > 0xff) tT0b = 0xff;

			tT0a = *dest & 0xff000000;
			*dest = tT0r | (tT0g << 8)| (tT0b << 16)| tT0a;
			dest++;
		}
		break;
	case Prim_Sub_Env_Mult_Tex_Add_Env:
		tmpClr = ((rdp_reg.envcolor & 0xff) << 24) | 
			((rdp_reg.envcolor & 0xff00) << 8) | 
			((rdp_reg.envcolor & 0xff0000) >> 8) | 
			(rdp_reg.envcolor >> 24);
		tmpClr2 = ((rdp_reg.primcolor & 0xff) << 24) | 
			(((rdp_reg.primcolor & 0xff00) << 16) >> 8) | 
			(((rdp_reg.primcolor & 0xff0000) << 8) >> 16)| 
			((rdp_reg.primcolor & 0xff000000) >> 24);
		for (i=0;i<Length;i++)
		{
			tmpClr -= tmpClr2;
			tT0r = (tmpClr & 0xff);
			tT0g = (tmpClr & 0xff00) >> 8;
			tT0b = (tmpClr & 0xff0000) >> 16;

			tT0r *= ((*dest & 0xff) & 0xff);
			tT0g *= ((*dest >>  8) & 0xff);
			tT0b *= ((*dest >> 16) & 0xff);

			tT0r >>= 8;
			tT0g >>= 8;
			tT0b >>= 8;

			tT0r += (tmpClr2 & 0xff);
			tT0g += (tmpClr2 & 0xff00) >> 8;
			tT0b += (tmpClr2 & 0xff0000) >> 16;

			if (tT0r < 0) tT0r = 0;
			if (tT0g < 0) tT0g = 0;
			if (tT0b < 0) tT0b = 0;

			if (tT0r > 0xff) tT0r = 0xff;
			if (tT0g > 0xff) tT0g = 0xff;
			if (tT0b > 0xff) tT0b = 0xff;

			tT0a = *dest & 0xff000000;
			*dest = tT0r | (tT0g << 8)| (tT0b << 16)| tT0a;
			dest++;
		}
		break;
	case Env_Sub_Tex_Mult_EnvAlpha_Add_Tex:
		tmpClr = ((rdp_reg.envcolor & 0xff) << 24) | 
			((rdp_reg.envcolor & 0xff00) << 8) | 
			((rdp_reg.envcolor & 0xff0000) >> 8) | 
			(rdp_reg.envcolor >> 24);
		tmpClr2 = rdp_reg.envcolor & 0xff;
		for (i=0;i<Length;i++)
		{

			tT0r = (tmpClr & 0xff);
			tT0g = (tmpClr & 0xff00) >> 8;
			tT0b = (tmpClr & 0xff0000) >> 16;

			tT0r -= ((*dest & 0xff) & 0xff);
			tT0g -= ((*dest >>  8) & 0xff);
			tT0b -= ((*dest >> 16) & 0xff);

			tT0r *= tmpClr2;
			tT0g *= tmpClr2;
			tT0b *= tmpClr2;

			tT0r >>= 8;
			tT0g >>= 8;
			tT0b >>= 8;

			tT0r += ((*dest) & 0xff);
			tT0g += ((*dest >>  8) & 0xff);
			tT0b += ((*dest >> 16) & 0xff);

			if (tT0r < 0) tT0r = 0;
			if (tT0g < 0) tT0g = 0;
			if (tT0b < 0) tT0b = 0;

			if (tT0r > 0xff) tT0r = 0xff;
			if (tT0g > 0xff) tT0g = 0xff;
			if (tT0b > 0xff) tT0b = 0xff;

			tT0a = *dest & 0xff000000;
			*dest = tT0r | (tT0g << 8)| (tT0b << 16)| tT0a;
			dest++;
		}
		break;
	}
	return 1;
}

void TexMirrorS(int width,int height)
{
	_u32 *d = (_u32*)&tbuffer1[width * height * 8];
	_u32 *s = (_u32*)&tbuffer1[width * height * 4];
	int x,y;
	for (y=0;y<height;y++)
	{
		s -= width;
		for (x=0;x<width;x++)
		{
			*d-- = *s++;
		}
		s--;
		for (x=0;x<width;x++)
		{
			*d-- = *s--;
		}
		s++;
	}
	d = (_u32*)&tbuffer1[0];
	s = (_u32*)&tbuffer1[0];
	for (x = 0; x < (width * height); x++)
	{
		s++;
		*d++ = *s++;
	}
}

void TexMirrorT(int width,int height)
{
	_u32 *d = (_u32*)&tbuffer1[width * height * 8];
	_u32 *s = (_u32*)&tbuffer1[0];
	int x,y;
	for (y=0;y<height;y++)
	{
		d -= width;
		for (x=0;x<width;x++)
		{
			*d++ = *s++;
		}
		d -= width;
	}
	d = (_u32*)&tbuffer1[0];
	s = (_u32*)&tbuffer1[0];
	for (y=0;y<height;y++)
	{
		for (x=0;x<width;x++)
		{
			*d++ = *s++;
		}
		s += width;
	}
}

int SetActiveTexture()
{
	_u32 i, new_width, new_height;
	t_tile *t_p = rdp_reg.m_CurTile;
	_u16 *text = (_u16 *)((_u8 *)&pRDRAM[(rdp_reg.TextureImage.addr + t_p->tmem) & 0x07fffff]);
	_u8 *ttext = (_u8 *)&pRDRAM[(rdp_reg.TextureImage.addr + t_p->tmem) & 0x07fffff];
//** Use m_CurTile now (FiRES)  //**	t_tile *t_p = &rdp_reg.td[0];
	//t_tile *t_p1 = rdp_reg.m_NexTile;
	_s16 TexID = -1;
	int offset;
	int NextID;
	int LastID;
	int Size;

	_u64 addr = rdp_reg.TextureImage.addr;

	int  size = (int)t_p->size;
	int  format = (int)t_p->format;
	int  tult = (int)t_p->ult;
	int  palette = (int)t_p->palette;

	int twidth = t_p->Width;
	int width = rdp_reg.TextureImage.width;

    int stwidth  = t_p->lrs - t_p->uls;
    int stheight = t_p->lrt - t_p->ult;

	if (stwidth < 0) stwidth = -stwidth;
	if (stheight < 0) stheight = -stheight;

	if (rdp_reg.TextureImage.size == (t_p->size + 1))
		width += width;

    stwidth++;
    stheight++;

	if (((_s32)stwidth * (_s32)stheight) > ((_s32)TBUFFERSIZE - 0x100))
	{
		return 0;
	}

	Size = (stwidth * stheight);

//	stheight &= 0x0fffe;

	palette = 0;
	twidth = stwidth;

	if (width <= 1)
		width = twidth;

	if (format == 2)
	{
		switch (size)
		{
		case 0:
			palette += PaletteCRC[t_p->palette];
			break;
		case 1:
			palette += PaletteCRC[16];
			break;
		default:
			palette = 0;
			break;
		}
	}
	
	offset =  ((tult * width) + t_p->uls);// 8-bit

	ttext = &pRDRAM[(rdp_reg.TextureImage.addr + t_p->tmem) & 0x07fffff];

//	text = ttext;
	TexID = -1;
	NextID = -1;
	LastID = -1;
	if ( (*text == 0xFF00) && (*(text+1) == 0xFE01) && (*(text+2) < num_cached_texture) )
		TexID = (_s16)*(text+2);
	NextID = TexID;
	if (TexID != -1)
	{
//	for (i=TexID;i<num_cached_texture;i++)
	while (NextID >= 0)
	if (NextID >= 0)
	{
		if (Size == index_texture[NextID].Size)
		{
			if (offset == index_texture[NextID].offset)
			{
				if (TexMode == index_texture[NextID].TexMode)
				{
					if (TexColor == index_texture[NextID].TexColor)
					{
						if (palette == index_texture[NextID].Palette)
						{
							glBindTexture(GL_TEXTURE_2D, NextID);
							return 1;
						}
					}
				}
			}
		}
		LastID = NextID;
		NextID = index_texture[NextID].NextID;
	}
	}

//** texture is not cached yet... so we cache it

	index_texture[num_cached_texture].TexID = TexID;
	index_texture[num_cached_texture].offset = offset;
	index_texture[num_cached_texture].TexMode = TexMode;
	index_texture[num_cached_texture].TexColor = TexColor;
	index_texture[num_cached_texture].Palette = palette;
	index_texture[num_cached_texture].Size = Size;
	index_texture[num_cached_texture].NextID = -1;

	glBindTexture(GL_TEXTURE_2D, num_cached_texture);
	
	if ( (*text == 0xFF00) && (*(text+1) ==0xFE01) && (*(text+2) == (_u16)TexID) )
	{
		*text = old_texture[TexID].old_bytes[0]; text++;
		*text = old_texture[TexID].old_bytes[1]; text++;
		*text = old_texture[TexID].old_bytes[2];
	}

	DecompressTexture(t_p,ttext,0);

	if (TexID > -1)
	{
		text = old_texture[TexID].addr;
		*text = 0xFF00; text++;
		*text = 0xFE01; text++;
		*text = (_u16)TexID;
	}


	if (TexMode != 0) ModTexture(TexMode, t_p->Width * t_p->Height);
	
	text = (_u16 *)((_u8 *)&pRDRAM[(rdp_reg.TextureImage.addr + t_p->tmem) & 0x07fffff]);

	if (TexID < 0)
		TexID = (_s16)num_cached_texture;

	old_texture[num_cached_texture].addr = text;
	old_texture[num_cached_texture].old_bytes[0] = *text; *text = 0xFF00; text++;
	old_texture[num_cached_texture].old_bytes[1] = *text; *text = 0xFE01; text++;
	old_texture[num_cached_texture].old_bytes[2] = *text; *text = (_u16)TexID;

	if (LastID >= 0) 
	{
		index_texture[LastID].NextID = num_cached_texture;
	}

	if (t_p->maskt)
	{
		if (t_p->mirrort) TexMirrorT(t_p->Width, t_p->Height);
		if (t_p->clampt) glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		else glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	}
	else glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

	if (t_p->masks)
	{
		if (t_p->mirrors) 
			if (t_p->mirrort) 
				TexMirrorS(t_p->Width, t_p->Height * 2);
			else
				TexMirrorS(t_p->Width, t_p->Height);
		if (t_p->clamps) glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		else glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	}
	else glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);

//	if (rdp_reg.geometrymode & 0x00080000)
//	{
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
//	}
//	else
//	{
//		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
//		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
//	}

	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	
//** Build the texture...	
	if (TestPower2(t_p->Width, t_p->Height, (int*)&new_width, (int*)&new_height))
	{
		glTexImage2D(GL_TEXTURE_2D, 0, 4, t_p->Width, t_p->Height, 0, GL_RGBA,
				 GL_UNSIGNED_BYTE, (unsigned char*)tbuffer1);
	}
	else
	{
		gluScaleImage(GL_RGBA, t_p->Width, t_p->Height, GL_UNSIGNED_BYTE, (unsigned char*)tbuffer1,
					   new_width, new_height, GL_UNSIGNED_BYTE, (unsigned char*)tbuffer2);

		glTexImage2D(GL_TEXTURE_2D, 0, 4, new_width, new_height, 0, GL_RGBA,
					 GL_UNSIGNED_BYTE, (unsigned char*)tbuffer2);
	}

//** is needed for a lot of demos (FiRES) - if the combines mode work right
//** we dont need this anymore
//	if (NoBlending) glDisable(GL_BLEND);
//	else glEnable(GL_BLEND);

	num_cached_texture++;

// if we have cached to much textures we are clearing the complete texturestuff ...
	if (num_cached_texture >= MAX_CACHED_TEXTURES) 
	{
		num_cached_texture=1;
		for (i=1; i < MAX_CACHED_TEXTURES; i ++)
		{
			text = old_texture[i].addr;
			if ( (*text == 0xFF00) && (*(text+1) ==0xFE01) && (*(text+2) == i) )
			{
				text = old_texture[i].addr;
				*text = old_texture[i].old_bytes[0]; text++;
				*text = old_texture[i].old_bytes[1]; text++;
				*text = old_texture[i].old_bytes[2];
			}
			index_texture[i].TexID		= -1;
			index_texture[i].TexColor	= -1;
			index_texture[i].TexMode	= -1;
			index_texture[i].offset		= -1;
			index_texture[i].NextID		= -1;
			index_texture[i].Palette	= -1;
			index_texture[i].Size		= -1;
			glDeleteTextures(1,(int*)&i);
		}
		SetActiveTexture();
	}

	TexMode = 0;
	TexColor = 0;
	return 1;
}

/*****************************************************************************/


static void NCopyTextureRGBA32    (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey)
{
	_s32 x, y;
	_u8 *dest = i_dst;
    _u8 *src = i_src;

    int xc, yc;
    int xl, yl;
    int dx, dy;

	yl = ey - sy;
	xl = ex - sx;

	if (yl < 0) 
	{
		dy = -1;
		yl = - yl;
	}
	else 
	{
		dy = 1;
	}

	if (xl < 0) 
	{
		dx = -1;
		xl = - xl;
	}
	else 
	{
		dx = 1;
	}

	y = sy;

	for(yc = 0; yc <= yl; yc++)
	{
		x = sx;
   		src = i_src + ((y * twidth + x) << 2);
		for(xc = 0; xc <= xl; xc++)
		{
    		//src = i_src + ((y * twidth + x) << 2);
			src += 3;
            *dest = *src; src--; dest++;
            *dest = *src; src--; dest++;
            *dest = *src; src--; dest++;
            *dest = *src; dest++;
            src += 4;
			//x += dx;
        }
		y += dy;
	}


}

// correct !!

static void NCopyTextureRGBA16    (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey)
{
	_s32 x, y;
	_u8 *dest = i_dst;
    _u16 *src = (_u16*)i_src;

    int xc, yc;
    int xl, yl;
    int dx, dy;

	yl = ey - sy;
	xl = ex - sx;

	if (yl < 0) 
	{
		dy = -1;
		yl = - yl;
	}
	else 
	{
		dy = 1;
	}

	if (xl < 0) 
	{
		dx = -1;
		xl = - xl;
	}
	else 
	{
		dx = 1;
	}

	y = sy;

	for(yc = 0; yc <= yl; yc++)
	{
	_u32  src_l = (_u32)i_src + ((y * twidth + sx) << 1);
		x = sx;
		for(xc = 0; xc <= xl; xc++)
           {
			//_u32  src_l = (_u32)i_src + ((y * twidth + x) << 1);
			_u16 *src_h = (_u16 *)(src_l ^0x02);

			*(dest) = (((*src_h >> 11 ) & 0x001f)<<3); dest++;
			*(dest) = (((*src_h >>  6 ) & 0x001f)<<3); dest++;
			*(dest) = (((*src_h >>  1 ) & 0x001f)<<3); dest++;
			*(dest) =  (*src_h & 0x01) ? 0xff : 0x00; dest++;
//			src++;
			src_l += 0x02;
			//x += dx;
         }
		y += dy;
	}
}

static void NCopyTextureCI8    (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey)
{
   // tested //
        _u32   *d = (_u32*)i_dst;
        _u8   *s = i_src;
        unsigned int     x, y;
        _u16  *pal = (_u16 *)((_u8 *)(pRDRAM + rdp_reg.tlut_8_addr));   /* palette */
        _u16  rgba;   /* color */
		_u8 index;
		_u32 tsrc;

    int xc, yc;
    int xl, yl;
    int dx, dy;

	yl = ey - sy;
	xl = ex - sx;

	if (yl < 0) 
	{
		dy = -1;
		yl = - yl;
	}
	else 
	{
		dy = 1;
	}

	if (xl < 0) 
	{
		dx = -1;
		xl = - xl;
	}
	else 
	{
		dx = 1;
	}

	y = sy;

	for(yc = 0; yc <= yl; yc++)
	{
		x = sx;
		tsrc = ((_u32)i_src) + (((y * twidth) + x));
		for(xc = 0; xc <= xl; xc++)
                {
					//tsrc = ((_u32)i_src) + (((y * twidth) + x) ^ 0x03);
					//s = (_u8 *)tsrc;
					s = (_u8 *)(tsrc ^ 0x03);
					index = *s ^0x01;
					*d++ = Palette8[index];
					tsrc++;
					//x += dx;
                }
		y += dy;
	}
}


static void NCopyTextureCI4    (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey)
{
	// TT
    _u32 x, y, tsrc;
    int xc, yc;
    int xl, yl;
    int dx, dy;
    _u32 *d = (_u32*)i_dst;
    _u8 *s = i_src;
    _u32 color;
	t_tile *t_p = rdp_reg.m_CurTile;

	_u32  *palette = (_u32 *)(&Palette8)+(t_p->palette<<4);   /* palette */

    _u8 index;
	int tw;

	yl = ey - sy;
	xl = ex - sx;

	if (yl < 0) 
	{
		dy = -1;
		yl = - yl;
	}
	else 
	{
		dy = 1;
	}

	if (xl < 0) 
	{
		dx = -1;
		xl = - xl;
	}
	else 
	{
		dx = 1;
	}

	y = sy;

	for(yc = 0; yc <= yl; yc++)
	{
		x = sx;
		tw = (y * twidth + x);
		tsrc = ((_u32)i_src + (tw >> 1));
		for(xc = 0; xc <= xl; xc++)
		{
			//tw = (y * twidth + x);
			//tsrc = ((_u32)i_src + (tw >> 1))^ 0x03;
			//s = (_u8 *)tsrc;
			s = (_u8 *)(tsrc ^ 0x03);

            index = *s ^0x11;
			if ((x & 1) == 0)
			{
				color = palette[index >> 4];
			}
			else
			{
				color = palette[index & 0x0f];
				tsrc++;
			}
			*d++ = color;
			x += dx;
        }
		y += dy;
	}
}

void writetex()
{
	unsigned int i, j = 0;
	FILE *stream = fopen("d:/texture.raw","wb");
	for (i = 0; i < rdp_reg.td[0].Width*rdp_reg.td[0].Height; i++)
	{
		fprintf(stream,"%c",tbuffer1[j]); j++;
		fprintf(stream,"%c",tbuffer1[j]); j++;
		fprintf(stream,"%c",tbuffer1[j]); j++;
		j++;
	}
	fclose(stream);	
}

static void NCopyTextureIA16   (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey)
{
	// TT
	_u32 x, y, tsrc;
	_u8 *dest = i_dst;
    _u8 *src = i_src;
	_u8 intensity;

    int xc, yc;
    int xl, yl;
    int dx, dy;

	yl = ey - sy;
	xl = ex - sx;

	if (yl < 0) 
	{
		dy = -1;
		yl = - yl;
	}
	else 
	{
		dy = 1;
	}

	if (xl < 0) 
	{
		dx = -1;
		xl = - xl;
	}
	else 
	{
		dx = 1;
	}

	y = sy;

	for(yc = 0; yc <= yl; yc++)
	{
		x = sx;
		for(xc = 0; xc <= xl; xc++)
                {
			tsrc = ((_u32)i_src + (((y * twidth) + x) << 1)) ^ 0x02;
			src = (_u8 *)tsrc;
			intensity = *(src + 1);
			*dest =  intensity; dest++;
			*dest =  intensity; dest++;
			*dest =  intensity; dest++;
 	  	    *dest = *(src + 0); dest++;
			x += dx;
        }
		y += dy;
	}
}

static void NCopyTextureIA8   (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey)
{
	// TT
	_u32 x,y,i,tsrc;
	_u8 *dest = i_dst;
    _u8 *src = i_src;
//    float r,g,b,a;

    int xc, yc;
    int xl, yl;
    int dx, dy;

	yl = ey - sy;
	xl = ex - sx;

	if (yl < 0) 
	{
		dy = -1;
		yl = - yl;
	}
	else 
	{
		dy = 1;
	}

	if (xl < 0) 
	{
		dx = -1;
		xl = - xl;
	}
	else 
	{
		dx = 1;
	}

	y = sy;

	for(yc = 0; yc <= yl; yc++)
	{
		x = sx;
		for(xc = 0; xc <= xl; xc++)
		{
			tsrc = ((_u32)i_src + (y * twidth) + x) ^ 0x03;
			src = (_u8 *)tsrc;
			i = (*src &0xf0);
			i |= i >> 4;
			*dest = (_u8)i; dest++;
			*dest = (_u8)i; dest++;
			*dest = (_u8)i; dest++;
 	  	    *dest = (*src & 0x0f) | ((*src & 0x0f) << 4); dest++; // aplha
			x += dx;
        }
		y += dy;
	}

}

static void NCopyTextureIA4    (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey)
{
	// TT
    _u32 x, y, tsrc;
    _u8 *d = i_dst;
    _u8 *s = i_src;
    _u8 i;
	int tw;


    int xc, yc;
    int xl, yl;
    int dx, dy;

	yl = ey - sy;
	xl = ex - sx;

	if (yl < 0) 
	{
		dy = -1;
		yl = - yl;
	}
	else 
	{
		dy = 1;
	}

	if (xl < 0) 
	{
		dx = -1;
		xl = - xl;
	}
	else 
	{
		dx = 1;
	}

	y = sy;

	for(yc = 0; yc <= yl; yc++)
	{
		x = sx;
		for(xc = 0; xc <= xl; xc++)
		{
			/* 0x800 might be not correct! */
			tw = (y * twidth) + x;
			tsrc = (_u32)i_src + ((tw >> 1)^ 0x03);
			s = (_u8 *)tsrc;

//			if (!tw & 1)
			if ((x & 1) == 0)
			{
					i = (*s & 0xf0) | ((*s & 0xf0) >> 4);
					*d++ = i;
					*d++ = i;
					*d++ = i;
					*d++ = (i & 1) ? 0xff : 0x00;
			}
			else
			{
					i = (*s & 0x0f) | ((*s & 0x0f) << 4);
					*d++ = i;
					*d++ = i;
					*d++ = i;
					*d++ = (i & 1) ? 0xff : 0x00;
			}
			x += dx;
        }
		y += dy;
		//y++;
	}
}

static void NCopyTextureI16    (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey)
{
	_u32 x, y, tsrc;
	_u8 *dest = i_dst;
    _u8 *src = i_src;
	_u8 intensity;

    int xc, yc;
    int xl, yl;
    int dx, dy;

	yl = ey - sy;
	xl = ex - sx;

	if (yl < 0) 
	{
		dy = -1;
		yl = - yl;
	}
	else 
	{
		dy = 1;
	}

	if (xl < 0) 
	{
		dx = -1;
		xl = - xl;
	}
	else 
	{
		dx = 1;
	}

	y = sy;

	for(yc = 0; yc <= yl; yc++)
	{
		x = sx;
		for(xc = 0; xc <= xl; xc++)
        {
			tsrc = ((_u32)i_src + (((y * twidth) + x) << 1)) ^ 0x02;
			src = (_u8 *)tsrc;
			intensity = *(src + 1);
			*dest =  intensity; dest++;
			*dest =  intensity; dest++;
			*dest =  intensity; dest++;
 	  	    *dest = *(src + 1); dest++;
			x += dx;
        }
		y += dy;
	}
}

static void NCopyTextureI8    (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey)
{
        _u32  x, y;
        _u8  *d = i_dst;
        _u8  *s = i_src;
        _u8  i;


    int xc, yc;
    int xl, yl;
    int dx, dy;

	yl = ey - sy;
	xl = ex - sx;

	if (yl < 0) 
	{
		dy = -1;
		yl = - yl;
	}
	else 
	{
		dy = 1;
	}

	if (xl < 0) 
	{
		dx = -1;
		xl = - xl;
	}
	else 
	{
		dx = 1;
	}

	y = sy;

	for(yc = 0; yc <= yl; yc++)
	{
		x = sx;
		for(xc = 0; xc <= xl; xc++)
        {
                    s = i_src + (((y * twidth) + x) ^ 0x3);    
					i = *s;
					*d++ = i;
                    *d++ = i;
                    *d++ = i;
                    *d++ = i; 
                    //s++;
					x += dx;
        }
		y += dy;
	}
}

static void NCopyTextureI4    (_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey)
{
	// TT
    _u32 x, y, tsrc;
    _u8 *d = i_dst;
    _u8 *s = i_src;
    _u8 i;
	int tw;


    int xc, yc;
    int xl, yl;
    int dx, dy;

	yl = ey - sy;
	xl = ex - sx;

	if (yl < 0) 
	{
		dy = -1;
		yl = - yl;
	}
	else 
	{
		dy = 1;
	}

	if (xl < 0) 
	{
		dx = -1;
		xl = - xl;
	}
	else 
	{
		dx = 1;
	}

	y = sy;

	for(yc = 0; yc <= yl; yc++)
	{
		x = sx;
		for(xc = 0; xc <= xl; xc++)
        {
			/* 0x800 might be not correct! */
			tw = (y * twidth) + x;
			tsrc = (_u32)i_src + ((tw >> 1)^ 0x03);
			s = (_u8 *)tsrc;

//			if (!tw & 1)
			if ((x & 1) == 0)
			{
					i = (*s & 0xf0) | ((*s & 0xf0) >> 4);
					*d++ = i;
					*d++ = i;
					*d++ = i;
					*d++ = i;
			}
			else
			{
					i = (*s & 0x0f) | ((*s & 0x0f) << 4);
					*d++ = i;
					*d++ = i;
					*d++ = i;
					*d++ = i;
			}
			x += dx;
        }
		y += dy;
		//y++;
	}
}


/*****************************************************************************/
/*** the follow function is  not implemented yet *****************************/
/*****************************************************************************/

static void CopyTextureYUV(_u8 *i_src, _u8 *i_dst, _u32 width, _u32 height)
{
    _u32 i, j;
    _u8 *d = i_dst;
    _u16 *s = (_u16*)i_src;

    for(i=0; i < height; i++)
        for(j=0; j < width; j++)
        {
            *d++ = 100;
            *d++ = 150;
            *d++ = 200;
            *d++ = 255;
            s++;
        }

}
