#ifdef __WIN32__
#include <windows.h>
#else
#include "winlnxdefs.h"
#endif
#include "type_sizes.h"

#include "wingl.h"

#include "debug.h"
//** externals
extern int				*pInterruptMask;
extern unsigned char	*pRDRAM;
extern unsigned char	*pIDMEM;
extern unsigned char	*pVIREG;

char output[1024];

extern _u32 Palette8[256];
//extern unsigned long Palette4[256];
extern int	Vtidx[256];
extern int Vtcnt;
extern void FlushVisualTriangle(int vn[]);

#include "rdp.h"
#include "rdp_registers.h"
#include "3dmath.h"
#include "Combine.h"

// FiRES
extern	int ucode_version;
extern HWND hGraphics;
extern BOOLEAN Draw2d;
#include "rdp_gl.h"
#include "Render.h"
/* define macros - to speed up things and to make things looking nice */

#define SKIPMASK 1

t_rdp_reg rdp_reg;
int PaletteCRC[17];
static  _u32 segoffset2addr(_u32 so);   /* calcs the real addr out of seg and offset */
int DList_C = 0;

//** rdp instructions (audio & graphics) 
//** All ucodes 

// Globals 

static void fixme();
static void spnoop();

static void rdp_noop();
static void rdp_texrect();
static void rdp_texrectflip();
static void rdp_loadsync();
static void rdp_pipesync();
static void rdp_tilesync();
static void rdp_fullsync();
static void rdp_setkeygb();
static void rdp_setkeyr();
static void rdp_setconvert();
static void rdp_setscissor();
static void rdp_setprimdepth();
static void rdp_setothermode();
static void rdp_loadtlut();
static void rdp_settilesize();
static void rdp_loadblock();
static void rdp_loadtile();
static void rdp_settile();
static void rdp_fillrect();
static void rdp_setfillcolor();
static void rdp_setfogcolor();
static void rdp_setblendcolor();
static void rdp_setprimcolor();
static void rdp_setenvcolor();
extern void rdp_setcombine();
static void rdp_settextureimage();
static void rdp_setdepthimage();
static void rdp_setcolorimage();
static void rdp_trifill();
static void rdp_trishade();
static void rdp_tritxtr();
static void rdp_trishadetxtr();
static void rdp_trifillz();
static void rdp_trishadez();
static void rdp_tritxtrz();
static void rdp_trishadetxtrz();

static void rsp_reserved0();
static void rsp_reserved1();
static void rsp_reserved2();
static void rsp_reserved3();
void DelTexture();


static void MathTextureScales();
void hleGetMatrix(float *dst,DWORD *src);

void exec_gfx();




//////////////////////////////////////////////////////////////////////////////
// structure is tricky for changing the endians								//
//////////////////////////////////////////////////////////////////////////////
float UC6_Matrices[3][4][4];


_u8 doReadMemByte(_u32 where)
{
        where ^= 0x03;
        return(*((_u8 *)&pRDRAM[where]));

} // _u8 doReadMemByte(_u32 where) 


_u16 doReadMemHalfWord(_u32 where)
{
/*     _u32 hi = where ^ 0x03;
     _u32 lo = (where + 1) ^ 0x03;

	 return( (((_u16)((_u8)pRDRAM[hi]))<<8) | (_u8)pRDRAM[lo] );
*/
        where ^= 0x02;
		return(*((_u16 *)&pRDRAM[where]));

} // _u16 doReadMemHalfWord(_u32 where) 


_u32 doReadMemWord(_u32 where)
{
	 return(*((_u32 *)&pRDRAM[where]));
} // _u32 doReadMemWord(_u32 where) 


_u64 doReadMemDoubleWord(_u32 where)
{
        _u64 value;
		value = (*((_u64 *)&pRDRAM[where]));
        return( (value >> 32) | (value << 32) );
} // _u64 doReadMemDoubleWord(_u32 where) 



#include "hle_uc00.h"
#include "hle_uc01.h"
#include "hle_uc02.h"
#include "hle_uc03.h"
#include "hle_uc04.h"
#include "hle_uc05.h"
#include "hle_uc06.h"
#include "hle_uc.h"				// All Functions-Array


void exec_gfx()
{
	gfx_instruction[ucode_version][rdp_reg.cmd0>>24]();
}
/******************************************************************************\
*                                                                              *
*   RDP (Reality Display Processor) - global routines                          *
*                                                                              *
\******************************************************************************/
static void MathTextureScales()
{
	int i = rdp_reg.loadtile;
	float TScaleT, TScaleS, width, height;

	width=(float)((short)rdp_reg.m_CurTile->lrs >> rdp_reg.m_CurTile->shifts);
	width=width - (float)((short)rdp_reg.m_CurTile->uls >> rdp_reg.m_CurTile->shifts);
	if(width==0) width=1.f;

	height=(float)((short)rdp_reg.m_CurTile->lrt >> rdp_reg.m_CurTile->shiftt);
	height=height - (float)((short)rdp_reg.m_CurTile->ult >> rdp_reg.m_CurTile->shiftt);
	if(height==0) height=1.f;

	TScaleS = rdp_reg.m_CurTile->SScale / width;
	TScaleT = rdp_reg.m_CurTile->TScale / height;

	if ((rdp_reg.m_CurTile->maskt) && (rdp_reg.m_CurTile->mirrort)) TScaleT /= 2;
	if ((rdp_reg.m_CurTile->masks) && (rdp_reg.m_CurTile->mirrors)) TScaleS /= 2;

	rdp_reg.texture[i].scale_t = TScaleT;
	rdp_reg.texture[i].scale_s = TScaleS;	
}

#ifdef __WIN32__
void hleGetMatrix(float *dst,DWORD *src)
{
	float Const=1.f/65536.f;
	_asm
	{
		mov		edi,dword ptr dst
		mov		esi,dword ptr src
		mov		ecx,8
mat_loop:
		push	ecx
		mov		eax,dword ptr [esi]
		mov		ebx,eax
		and		eax,0xffff0000
		and		ebx,0x0ffff
		shl		ebx,16
		mov		ecx,dword ptr [esi+32]
		mov		edx,ecx
		shr		ecx,16
		mov		ax,cx
		mov		bx,dx
		add		esi,4
		mov		dword ptr [edi+4],eax
		mov		dword ptr [edi],ebx
		fild	dword ptr [edi]
		fmul	DWORD PTR Const
		fild	dword ptr [edi+4]
		fmul	DWORD PTR Const
		pop		ecx
		fstp	DWORD PTR [edi]
		fstp	DWORD PTR [edi+4]
		add		edi,8
		loop	mat_loop
	}
}
#else
float Const=1.f/65536.f;
#endif



void rdp_reset()
{
	int idx;
	for (idx = 0; idx < 16; idx++) rdp_reg.segment[idx] = 0xffffffff;

		rdp_reg.m_CurTile = &rdp_reg.td[0];
		//rdp_reg.m_NexTile = &rdp_reg.td[1];
		
        rdp_reg.pc_i = 0;
        rdp_reg.halt = 1;
        rdp_reg.lights = 1;

        rdp_reg.tile = 0;
        rdp_reg.loadtile = 7;
        rdp_reg.td[0].set_by = RDPTD_LOAD_NOT_SET;
        rdp_reg.td[1].set_by = RDPTD_LOAD_NOT_SET;
        rdp_reg.td[2].set_by = RDPTD_LOAD_NOT_SET;
        rdp_reg.td[3].set_by = RDPTD_LOAD_NOT_SET;
        rdp_reg.td[4].set_by = RDPTD_LOAD_NOT_SET;
        rdp_reg.td[5].set_by = RDPTD_LOAD_NOT_SET;
        rdp_reg.td[6].set_by = RDPTD_LOAD_NOT_SET;
        rdp_reg.td[7].set_by = RDPTD_LOAD_NOT_SET;

		Vtcnt = 0;

} /* void rdp_reset() */

static int rdpbusy = 0;
static int skipfram = 0;
// prefixed with "Real" because we have "ExecuteDList" exported from 
// driver.h and it wraps this function.
void RealExecuteDList(unsigned __int32 dwAddr)
{
    _u32   a,ta;
	int cnt = 0x1000;
	int tcmd;

	//ucode_version = AutodetectUCode(dwAddr);
	//ucode_version = 6;

    Render_ClearVisual();
	rdp_reg.task = GFX_TASK;
	rdp_reg.pc_i = 0;
	rdp_reg.pc[rdp_reg.pc_i] = dwAddr;
	rdp_reg.halt = 0;
	rdp_reg.m_CurTile = &rdp_reg.td[0];
	//rdp_reg.m_NexTile = &rdp_reg.td[1];

	Draw2d = FALSE;

	skipfram++;

/*	
	LOG_TO_FILE("\n****************************************\n");
	LOG_TO_FILE("* NEW DLIST                            *\n");
	LOG_TO_FILE("* address: %08X                    *\n", dwAddr);
	LOG_TO_FILE("* DList-no: %02i                         *\n", DList_C);
	LOG_TO_FILE("****************************************\n");
*/	
	DList_C++;
	if (TRUE)
	if ((skipfram & SKIPMASK) == 0)
//	if (0)
	{
		do
		{
//			a = rdp_reg.pc[rdp_reg.pc_i];
			a = rdp_reg.pc[rdp_reg.pc_i] & 0x007fffff;
			ta = a >> 2;

		//** load next commando
			rdp_reg.cmd0 = ((_u32 *)pRDRAM)[ta + 0];
			rdp_reg.cmd1 = ((_u32 *)pRDRAM)[ta + 1];
			rdp_reg.cmd2 = ((_u32 *)pRDRAM)[ta + 3];
			rdp_reg.cmd3 = ((_u32 *)pRDRAM)[ta + 5];

		//** point to next instruction 
			rdp_reg.curr = rdp_reg.pc[rdp_reg.pc_i] = (a + 8) & 0x007fffff;   

		//** execute next gfx-instruction
			tcmd = (_u8)(rdp_reg.cmd0>>24);

			if (ucode_version == 4)
			{
				if (((Vtcnt > 0) && (tcmd != 0x05) && (tcmd != 0x06) && (tcmd != 0x07)))
				{
					FlushVisualTriangle(Vtidx);
					Vtcnt = 0;
				}
			}
			else
			{
				if (((Vtcnt > 0) && (tcmd != 0xb1) && (tcmd != 0xb5) && (tcmd != 0xbf)))
				{
					FlushVisualTriangle(Vtidx);
					Vtcnt = 0;
				}
			}
			gfx_instruction[ucode_version][rdp_reg.cmd0>>24]();


		} while(!rdp_reg.halt);

		Render_FlushVisualRenderBuffer();
		//DelTexture();
	}
	else //if (((rdp_reg.cmd0>>24) & 0x0ff) == 0xb8)
	{
		//gfx_instruction[ucode_version][rdp_reg.cmd0>>24]();
		rdp_fullsync();
		rdp_reg.halt = 1;
	}

} /* rdp_execute_dlist() */




/******************************************************************************\
*                                                                              *
*   HLE (High Level Emulation) - helper routine.                               *
*                                                                              *
\******************************************************************************/

static _u32 segoffset2addr(_u32 so)
{
/*//        return( (rdp_reg.segment[(so>>24)&0x0f] + (so&0x00ffffff))  & 0x007fffff );
	_u32 seg = (so>>24)&0x0f;

	if (rdp_reg.segment[seg] != 0xffffffff)
        return((rdp_reg.segment[seg] + (so&0x00ffffff))  & 0x007fffff );
	else
        return((rdp_reg.segment[0] + (so&0x00ffffff))  & 0x007fffff );
*/
	int seg;
	_u32 offset;
	_u32 Address;
	seg=((so>>22)&0x3c)/4;
	offset=so&0xffffff;
	if(rdp_reg.segment[seg]==0xffffffff)		// predefined value... hope no one uses it!
	{
//		theApp.BPMessage("Undefinded segment access %d",seg);
		Address=offset+rdp_reg.segment[0];	// add the offset into the actual base address and now we have a rdRam address
		Address=offset;
		return(Address);
	}
	Address=offset+rdp_reg.segment[seg];	// add the offset into the actual base address and now we have a rdRam address
	return(Address & 0x07fffff);
} /* static _u32 segoffset2addr(_u32 so) */



static void rsp_reserved0()
{
        PRINT_RDP_NOT_IMPLEMENTED("RSP_RESERVED0");

        

} /* static void rsp_reserved0() */

static void rsp_reserved1()
{
        PRINT_RDP_NOT_IMPLEMENTED("RSP_RESERVED1");

        

} /* static void rsp_reserved1() */

static void rsp_reserved2()
{
        PRINT_RDP_NOT_IMPLEMENTED("RSP_RESERVED2");

        

} /* static void rsp_reserved2() */


static void rsp_reserved3()
{
        PRINT_RDP_NOT_IMPLEMENTED("RSP_RESERVED3");

        

} /* static void rsp_reserved3() */






/******************************************************************************\
*                                                                              *
*   RDP (Reality Display Processor) - static routines (graphics and audio)     *
*                                                                              *
\******************************************************************************/



static void fixme()
{
//	MessageBox(hGraphics, "Problem with UCode ...\ntry another one", "fixme", MB_OK);
/*		sprintf(output,"uCode = %i\ncmd0 = %8x\ncmd1 = %8x\ncmd2 = %8x\ncmd3 = %8x",ucode_version,rdp_reg.cmd0,rdp_reg.cmd1,rdp_reg.cmd2,rdp_reg.cmd3);
		MessageBox(hGraphics, output, "fixme", MB_OK);

		LOG_TO_FILE("%08X: %08X %08X CMD FIXME %08X\n", ADDR, CMD0, CMD1,rdp_reg.cmd0>>24);
*/
} // static void fixme() 





static void spnoop()
{
#ifdef WRITE_LOG
       PRINT_RDP_INFO("SPNOOP\n");
#endif
} /* static void spnoop() */





/******************************************************************************\
*                                                                              *
*   RDP (Reality Display Processor) emulation.                                 *
*                                                                              *
\******************************************************************************/




static void rdp_noop()
{
			LOG_TO_FILE("%08X: %08X %08X CMD RDP_NOOP\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("NOOP\n");
#endif
} /* static void rdp_noop() */



static void rdp_texrect()
{
        _u32   a = rdp_reg.pc[rdp_reg.pc_i];
        _u32   cmd2 = ((_u32 *)pRDRAM)[(a>>2)+1];
        _u32   cmd3 = ((_u32 *)pRDRAM)[(a>>2)+3];

        _u16  lrx     = (_u16)((rdp_reg.cmd0 & 0x00fff000) >> 12);
        _u16  lry     = (_u16)((rdp_reg.cmd0 & 0x00000fff) >>  0);
        _u16  ulx     = (_u16)((rdp_reg.cmd1 & 0x00fff000) >> 12); 
        _u16  uly     = (_u16)((rdp_reg.cmd1 & 0x00000fff) >>  0);

        float  lrxf     = lrx / 4.0f;
        float  lryf     = lry / 4.0f;
        float  ulxf     = ulx / 4.0f;
        float  ulyf     = uly / 4.0f;

        int     tile    = (_u16)((rdp_reg.cmd1 & 0x07000000) >> 24);

        float   s       = ((float)(_s16)((rdp_reg.cmd2 >> 16) & 0xffff)) / 32.0f;   //  s10.5
        float   t       = ((float)(_s16)((rdp_reg.cmd2      ) & 0xffff)) / 32.0f;   //  s10.5

        float   dsdx    = ((float)((_s16)((rdp_reg.cmd3 >> 16) & 0xffff))) / 1024.0f; //  s5.10
        float   dtdy    = ((float)((_s16)((rdp_reg.cmd3      ) & 0xffff))) / 1024.0f; //  s5.10

//		sprintf(output,"cmd0 = %8x\ncmd1 = %8x\ncmd2 = %8x\ncmd3 = %8x",rdp_reg.cmd0,rdp_reg.cmd1,rdp_reg.cmd2,rdp_reg.cmd3);
//		MessageBox(hGraphics, output, "textrect", MB_OK);

				LOG_TO_FILE("%08X: %08X %08X CMD RDP_TEXRECT\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG

        PRINT_RDP_INFO("TEXRECT ");
        PRINT_RDP_MNEMONIC("ulx=%4hu; uly=%4hu; lrx=%4hu; lry=%4hu; tile=%u; s=%+9.4f; t=%+9.4f; dsdx=%+7.4f; dtdy=%+7.4f\n",
               ulx, uly, lrx, lry, tile, s, t, dsdx, dtdy);
#endif
/*
        printf("TEXRECT ");
        printf("ulx=%4hu; uly=%4hu; lrx=%4hu; lry=%4hu; tile=%u; s=%+9.4f; t=%+9.4f; dsdx=%+7.4f; dtdy=%+7.4f\n",
               ulx, uly, lrx, lry, tile, s, t, dsdx, dtdy);
*/

		rdp_reg.curr = rdp_reg.pc[rdp_reg.pc_i] = (a + 16) & 0x007fffff;   

		rdp_reg.loadtile  = tile;
		rdp_reg.m_CurTile = &rdp_reg.td[tile];
		//rdp_reg.m_NexTile = &rdp_reg.td[(tile+1)&7];

    /* gil: in this case i am correct! */
    /* 1cyc mode (0x00000000): w = lrx - ulx     */
    /* 2cyc mode (0x00100000): w = lrx - ulx     */
    /* copy mode (0x00200000): w = lrx - ulx + 1 */
    /* fill mode (0x00300000): not allowed       */
        if(cycle_mode == CYCLE_COPY)
        {
            /* we are in copy mode */
            /* 4 texels are drawn per cycle */
//                lry--;
                dsdx /= 4.0;
        }
        else
        {
            /* we are in 1 or 2 cycle mode (fill mode is not allowed)! */
            /* we must not draw the bottom and right edges */
                lrx--;
                lry--;
        }


		//DrawTexRectangle(ulx, uly, lrx, lry, tile, s,t,1, 1);
		Render_TexRectangle(ulxf, ulyf, lrxf, lryf, tile, s,t,dsdx, dtdy);

        //draw2d(rdp_reg.textureimg_addr, rdp_reg.tlut_8_addr, rdp_reg.td[tile].format, rdp_reg.td[tile].size,
        //        //(_u16)((((float)(lrx - ulx)))*(f_dsdx)), (_u16)f_s, (_u16)f_t,
        //        lrx - ulx, 0, 0,
        //        lrx - ulx, lry - uly, 0, 0,
        //        rdp_reg.colorimg_addr, rdp_reg.colorimg_fmt, rdp_reg.colorimg_size, rdp_reg.colorimg_width, ulx, uly);


        //

} /* static void rdp_texrect() */





static void rdp_texrectflip()
{
			LOG_TO_FILE("%08X: %08X %08X CMD RDP_TEXRECTFLIP\n",
				 ADDR, CMD0, CMD1);

        PRINT_RDP_NOT_IMPLEMENTED("TEXRECTFLIP");

} /* static void rdp_texrectflip() */





static void rdp_loadsync()
{
			LOG_TO_FILE("%08X: %08X %08X CMD RDP_LOADSYNC\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
		PRINT_RDP_INFO("LOADSYNC\n");
        PRINT_RDP_WARNING("ignored");
#endif
} /* static void rdp_loadsync() */





static void rdp_pipesync()
{
			LOG_TO_FILE("%08X: %08X %08X CMD RDP_PIPESYNC\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("PIPESYNC\n");
        PRINT_RDP_WARNING("ignored");
#endif
} /* static void rdp_pipesync() */





static void rdp_tilesync()
{
			LOG_TO_FILE("%08X: %08X %08X CMD RDP_TILESYNC\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("TILESYNC\n");
        PRINT_RDP_WARNING("ignored");
#endif
} /* static void rdp_tilesync() */




void (*CheckInterrupts)(void);
static void rdp_fullsync()
{
		LOG_TO_FILE("%08X: %08X %08X CMD RDP_FULLSYNC\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("FULLSYNC\n");
#endif
        *pInterruptMask = 0x20; //0x20 Lionel
		CheckInterrupts();
        //((_u32 *)mem.dpc_reg)[2] = 0;

        //

} /* static void rdp_fullsync() */





static void rdp_setkeygb()
{
		LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETKEYG\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_NOT_IMPLEMENTED("SETKEYGB");
#endif        

} /* static void rdp_setkeygb() */





static void rdp_setkeyr()
{
		LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETKEYR\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_NOT_IMPLEMENTED("SETKEYR");
#endif
        

} /* static void rdp_setkeyr() */





static void rdp_setconvert()
{
		LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETCONVERT\n",
				 ADDR, CMD0, CMD1);

        PRINT_RDP_NOT_IMPLEMENTED("SETCONVERT");

        

} /* static void rdp_setconvert() */





static void rdp_setscissor()
{
        static char *interlace_modes[] = { "no", "?", "even", "odd" };

        rdp_reg.scissor.ulx             = (rdp_reg.cmd0 & 0x00fff000) >> 14;
        rdp_reg.scissor.uly             = (rdp_reg.cmd0 & 0x00000fff) >> 2;
        rdp_reg.scissor.interlace_mode  = (rdp_reg.cmd1 & 0x03000000) >> 24;
        rdp_reg.scissor.lrx             = (rdp_reg.cmd1 & 0x00fff000) >> 14;
        rdp_reg.scissor.lry             = (rdp_reg.cmd1 & 0x00000fff) >> 2;

    /* It seems that most demo coders thought that SETSCISSOR uses:
          x, y, width, height
       arguments. That is NOT correct. SETSCISSOR uses:
          ulx, uly, lrx, lry
       args!!! */

			LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETSCISSOR\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG

        PRINT_RDP_INFO("SETSCISSOR ");
        PRINT_RDP_MNEMONIC("ulx=%lu; uly=%lu; lrx=%lu; lry=%lu; interlace_mode=%s\n",
                rdp_reg.scissor.ulx,
                rdp_reg.scissor.uly,
                rdp_reg.scissor.lrx,
                rdp_reg.scissor.lry,
                interlace_modes[rdp_reg.scissor.interlace_mode]
                );
        PRINT_RDP_WARNING("interlace_mode is ignored");
#endif
		SetVisualClipRectangle(rdp_reg.scissor.ulx, rdp_reg.scissor.uly, rdp_reg.scissor.lrx, rdp_reg.scissor.lry);

} /* static void rdp_setscissor() */





static void rdp_setprimdepth()
{
	LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETPRIMDEPTH\n",
				 ADDR, CMD0, CMD1);

	PRINT_RDP_NOT_IMPLEMENTED("SETPRIMDEPTH");     

} /* static void rdp_setprimdepth() */





static void rdp_setothermode()
{
	_u32 Mode0 = rdp_reg.cmd0 & 0x0ffffff;
	_u32 Mode1 = rdp_reg.cmd1;

	LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETOTHERMODE\n",
					ADDR, CMD0, CMD1);

	rdp_reg.mode_h = Mode0;
	rdp_reg.mode_l = Mode1;

	cycle_mode = (_u8)(Mode0 & 0x3);

	if (Mode1 & 3)
	{
//		glEnable(GL_ALPHA_TEST);
///		GL_ALWAYS
//		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//	glEnable(GL_BLEND);
	}
	else
	{
//		glDisable(GL_ALPHA_TEST);
//		glBlendFunc(GL_ONE, GL_ZERO);
//		glDisable(GL_BLEND);
	}
} /* static void rdp_setothermode() */


static void rdp_loadtlut()
{
        _u32  tile   = (rdp_reg.cmd1 >> 24) & 0x07;
        _u16 count  = ((_u16)(rdp_reg.cmd1 >> 14) & 0x03ff);

	LOG_TO_FILE("%08X: %08X %08X CMD RDP_LOADTLUT\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("LOADTLUT ");
        PRINT_RDP_MNEMONIC("	tile=%ld (->tmem=%lx), count=%hx\n", 
               tile,
               rdp_reg.td[tile].tmem,
               count
               );
#endif
        rdp_reg.tlut_8_fmt  = rdp_reg.TextureImage.fmt;
        rdp_reg.tlut_8_size = rdp_reg.TextureImage.size;
        rdp_reg.tlut_8_addr = (_u32)(rdp_reg.TextureImage.addr);
/*
		sprintf(output,"address = %8x",rdp_reg.tlut_8_addr);
		MessageBox(hGraphics, output, "Pallette load", MB_OK);
*/
		{
			int i;
			_u32  *dpal = (_u32 *)(&Palette8);
			_u32  color;
			_u8   *d = (_u8 *)(&Palette8);
			_u16  *spal = (_u16 *)((_u8 *)pRDRAM + (rdp_reg.tlut_8_addr));
			for (i=0; i<17; i++) PaletteCRC[i] = 0;
			for (i=0; i<256; i++)
			{
				PaletteCRC[16] += (*spal * (i + 1));
				PaletteCRC[i>>4] += (*spal * ((i & 0xf) + 1));
				//*dpal++ = *spal++;
				color = *spal++;
				*d++ = (((color >> 11 ) & 0x001f)<<3);
				*d++ = (((color >>  6 ) & 0x001f)<<3);
				*d++ = (((color >>  1 ) & 0x001f)<<3);
				*d++ = (color & 0x01) ? 0xff : 0x00;

			}
		}

        rdp_reg.tlut_4_fmt[rdp_reg.td[tile].palette]  = rdp_reg.TextureImage.fmt;
        rdp_reg.tlut_4_size[rdp_reg.td[tile].palette] = rdp_reg.TextureImage.size;
        rdp_reg.tlut_4_addr[rdp_reg.td[tile].palette] = (_u32)rdp_reg.TextureImage.addr;
} /* static void rdp_loadtlut() */

 



static void rdp_settilesize()
{
        _u32 tile = (rdp_reg.cmd1 >> 24) & 0x07;
		t_tile *tmpTile = &rdp_reg.td[tile];
		int twidth, theight;

        tmpTile->uls = ((_u16)(rdp_reg.cmd0 >> 12)) & 0x0fff;
        tmpTile->ult = ((_u16)( rdp_reg.cmd0     )) & 0x0fff;
        tmpTile->lrs = ((_u16)(rdp_reg.cmd1 >> 12)) & 0x0fff;
        tmpTile->lrt = ((_u16)( rdp_reg.cmd1     )) & 0x0fff;

		twidth  = tmpTile->lrs - tmpTile->uls;
		if (twidth < 0) twidth = - twidth;
		twidth += 4;
		tmpTile->Width  = twidth >> 2;

		theight  = tmpTile->lrt - tmpTile->ult;
		if (theight < 0) theight = - theight;
		theight += 4;
		tmpTile->Height  = theight >> 2;

//		tmpTile->Width  = (tmpTile->lrs - tmpTile->uls + 1) & 0x0fffe;
//		tmpTile->Height = (tmpTile->lrt - tmpTile->ult + 1) & 0x0fffe;

		tmpTile->uls = (tmpTile->uls >> 2);
		tmpTile->ult = (tmpTile->ult >> 2);
	    tmpTile->lrs = ((tmpTile->lrs+2) >> 2);
		tmpTile->lrt = ((tmpTile->lrt+2) >> 2);

		if(tmpTile->lrs == tmpTile->uls) tmpTile->lrs++;
		if(tmpTile->lrt == tmpTile->ult) tmpTile->lrt++;


//**  Math the Texture-Coordinate Scalefactors ...
		MathTextureScales();

			LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETTILESIZE\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETTILESIZE ");
        PRINT_RDP_MNEMONIC("	uls=%hu; ult=%hu; lrs=%hu; lrt=%hu; tile=%lu\n",
                rdp_reg.td[tile].uls,
                rdp_reg.td[tile].ult,
                rdp_reg.td[tile].lrs,
                rdp_reg.td[tile].lrt,
                tile
                );
#endif
} /* static void rdp_settilesize() */





static void rdp_loadblock()
{	
        _u32 tile = (_u32)((rdp_reg.cmd1 >> 24) & 0x07);
		_u16 dxt = (_u16)(rdp_reg.cmd1 & 0x0fff);
		t_tile *tmpTile = &(rdp_reg.td[tile]);

		tmpTile->set_by = RDPTD_LOADBLOCK;
		tmpTile->addr   = (_u32)(rdp_reg.TextureImage.addr);
		rdp_reg.loadtile  = tile;
		rdp_reg.m_CurTile = tmpTile;

		tmpTile->uls = (_u16)((rdp_reg.cmd0 >> 12) & 0x0fff);
		tmpTile->ult = (_u16)((rdp_reg.cmd0	   ) & 0x0fff);
		tmpTile->lrs = (_u16)((rdp_reg.cmd1 >> 12) & 0x0fff);

		tmpTile->uls = (tmpTile->uls >> 2);
		tmpTile->ult = (tmpTile->ult >> 2);
	    tmpTile->lrs = ((tmpTile->lrs+2) >> 2);
		tmpTile->lrt = ((tmpTile->lrt+2) >> 2);

		dxt = (_u16)(((float)1.0f) / (((float)(dxt) / ((float)(2048.0f)))));
		tmpTile->dxt = dxt;

		
	LOG_TO_FILE("%08X: %08X %08X CMD RDP_LOADBLOCK\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
	PRINT_RDP_INFO("LOADBLOCK ");
/*	PRINT_RDP_MNEMONIC("	uls=%hu; ult=%hu; lrs=%hu; (real line width)dxt=%hu(*64bit); tile=%lu (->tmem=%hx)\n",
			rdp_reg.td[TILE].uls,
			rdp_reg.td[TILE].ult,
			rdp_reg.td[TILE].lrs,
			rdp_reg.td[TILE].dxt,
			TILE,
			rdp_reg.td[TILE].tmem
			);
*/
#endif
} /* static void rdp_loadblock() */





static void rdp_loadtile()
{
        _u32 tile = (_u32)((rdp_reg.cmd1 >> 24) & 0x07);
		t_tile *tmpTile = &(rdp_reg.td[tile]);

		tmpTile->set_by = RDPTD_LOADTILE;
		tmpTile->addr   = (_u32)rdp_reg.TextureImage.addr;
		rdp_reg.loadtile  = tile;
		rdp_reg.m_CurTile = tmpTile;		

		tmpTile->uls = (_u16)((rdp_reg.cmd0 >> 12) & 0x0fff);
		tmpTile->ult = (_u16)((rdp_reg.cmd0	   ) & 0x0fff);
		tmpTile->lrs = (_u16)((rdp_reg.cmd1 >> 12) & 0x0fff);
		tmpTile->lrt = (_u16)((rdp_reg.cmd1      ) & 0x0fff);		

		tmpTile->uls = (tmpTile->uls >> 2);
		tmpTile->ult = (tmpTile->ult >> 2);
	    tmpTile->lrs = ((tmpTile->lrs+2) >> 2);
		tmpTile->lrt = ((tmpTile->lrt+2) >> 2);


			LOG_TO_FILE("%08X: %08X %08X CMD RDP_LOADTILE\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
	PRINT_RDP_INFO("LOADTILE");
	PRINT_RDP_MNEMONIC("	uls=%lu, ult=%lu, tile=%lu; lrs=%lu, lrt=%lu\n", 
		(rdp_reg.cmd0 & 0x00fff000) >> 12, 
		(rdp_reg.cmd0 & 0x00000fff),
		(rdp_reg.cmd1 & 0x07000000) >> 24,
		(rdp_reg.cmd1 & 0x00fff000) >> 12, 
		(rdp_reg.cmd1 & 0x00000fff) );
#endif

} /* static void rdp_loadtile() */





static void rdp_settile()
{
        static char *format[]   = { "RGBA", "YUV", "CI", "IA", "I", "?", "?", "?" };
        static char *size[]     = { "4bit", "8bit", "16bit", "32bit" };
        static char *cm[]       = { "NOMIRROR/WARP(NOCLAMP)", "MIRROR", "CLAMP", "MIRROR&CLAMP" };

        _u32 tile = (_u32)((rdp_reg.cmd1 >> 24) & 0x07);
		t_tile *tmpTile = &rdp_reg.td[tile];

        tmpTile->format  = (_u8) ((rdp_reg.cmd0 >> 21) & 0x07);
        tmpTile->size    = (_u8) ((rdp_reg.cmd0 >> 19) & 0x03);
        tmpTile->line    = (_u16)((rdp_reg.cmd0 >>  9) & 0x01ff);
        tmpTile->tmem    = (_u16)( rdp_reg.cmd0        & 0x01ff)*8;
        tmpTile->palette = (_u8) ((rdp_reg.cmd1 >> 20) & 0x0f);
        tmpTile->clampt  = (_u8) ((rdp_reg.cmd1 >> 19) & 0x01);
        tmpTile->mirrort = (_u8) ((rdp_reg.cmd1 >> 18) & 0x01);
        tmpTile->maskt   = (_u8) ((rdp_reg.cmd1 >> 14) & 0x0f);
        tmpTile->shiftt  = (_u8) ((rdp_reg.cmd1 >> 10) & 0x0f);
        tmpTile->clamps  = (_u8) ((rdp_reg.cmd1 >>  9) & 0x01);
        tmpTile->mirrors = (_u8) ((rdp_reg.cmd1 >>  8) & 0x01);
        tmpTile->masks   = (_u8) ((rdp_reg.cmd1 >>  4) & 0x0f);
        tmpTile->shifts  = (_u8) ( rdp_reg.cmd1        & 0x0f);


		rdp_reg.loadtile = tile;
		rdp_reg.m_CurTile=tmpTile;
		//rdp_reg.m_NexTile = &rdp_reg.td[(tile+1)&7];


        //** setup line from "64bit pixel" to correct 32, 16, 8 or 4bit pixel 
//        switch(rdp_reg.td[tile].size)
//        switch(rdp_reg.TextureImage.size)
        switch(rdp_reg.td[tile].size)
        {
                case 0:   //** 4bit 
                        rdp_reg.td[tile].line <<= 4;
                        break;
                case 1:   //** 8bit 
                        rdp_reg.td[tile].line <<= 3;
                        break;
                case 2:   //** 16bit 
                        rdp_reg.td[tile].line <<= 2;
                        break;
                case 3:   //** 32bit 
                        rdp_reg.td[tile].line <<= 1;
                        break;
        }


			LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETTILE\n",
				 ADDR, CMD0, CMD1);

/*
#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETTILE ")
        PRINT_RDP_MNEMONIC(
                "	format=%s; size=%s; line=%lu (pixel); tmem=%lu; tile=%lu; palette=$%lx;\n"
                "	cmt=%s; maskt=%lu; shiftt=%lu; cms=%s; masks=%lu; shifts=%lu\n",
                format[rdp_reg.td[tile].format],
                size[rdp_reg.td[tile].size],
                rdp_reg.td[tile].line,
                rdp_reg.td[tile].tmem,
                tile,
                rdp_reg.td[tile].palette,
                cm[(rdp_reg.td[tile].clampt << 1) | rdp_reg.td[tile].mirrort],
                rdp_reg.td[tile].maskt,
                rdp_reg.td[tile].shiftt,
                cm[(rdp_reg.td[tile].clamps << 1) | rdp_reg.td[tile].mirrors],
                rdp_reg.td[tile].masks,
                rdp_reg.td[tile].shifts);
#endif
*/
} /* static void rdp_settile() */





static void rdp_fillrect()
{
        _u32   ulx, uly, lrx, lry;
        _u32   color;

        lrx = (rdp_reg.cmd0 & 0x00ffc000) >> 14;
        lry = (rdp_reg.cmd0 & 0x00000ffc) >> 2;
        ulx = (rdp_reg.cmd1 & 0x00ffc000) >> 14;
        uly = (rdp_reg.cmd1 & 0x00000ffc) >> 2;


	LOG_TO_FILE("%08X: %08X %08X CMD RDP_FILLRECT\n",
				 ADDR, CMD0, CMD1);
        
#ifdef WRITE_LOG
        PRINT_RDP_INFO("FILLRECT ");
        PRINT_RDP_MNEMONIC("ulx=%lu; uly=%lu; lrx=%lu; lry=%lu\n",
                           ulx,
                           uly,
                           lrx,
                           lry);
        PRINT_RDP_WARNING("modes are ignored");
#endif

    /* modes: copy mode is not used (not allowed?) */
        if(!(rdp_reg.mode_h & 0x00200000))
        {
            /* if we are not in 1 or 2 cycle mode (not in copy or fill mode) */
            /* we must not draw the bottom and right edges                   */
                //lrx--;
                //lry--;
                color = rdp_reg.blendcolor;
        }
        else
        {
                color = rdp_reg.fillcolor;
        }
                SetVisualColor(rdp_reg.fillcolor);

				Render_FillRectangle(ulx, uly, lrx, lry, color);
} /* static void rdp_fillrect() */





static void rdp_setfillcolor()
{
		LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETFILLCOLOR\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETFILLCOLOR ");
        PRINT_RDP_MNEMONIC("color=$%08lx\n", rdp_reg.cmd1);
#endif
        rdp_reg.fillcolor = rdp_reg.cmd1;

} /* static void rdp_setfillcolor() */





static void rdp_setfogcolor()
{
		LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETFOGCOLOR\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETFOGCOLOR ");
        PRINT_RDP_MNEMONIC("color=$%08lx\n", rdp_reg.cmd1);
#endif
        rdp_reg.fogcolor = rdp_reg.cmd1;

} /* static void rdp_setfogcolor() */





static void rdp_setblendcolor()
{
		LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETBLENDCOLOR\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETBLENDCOLOR ");
        PRINT_RDP_MNEMONIC("color=$%08lx\n", rdp_reg.cmd1);
#endif
        rdp_reg.blendcolor = rdp_reg.cmd1;

} /* static void rdp_setblendcolor() */





static void rdp_setprimcolor()
{

		LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETPRIMCOLOR\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETPRIMCOLOR ");
        PRINT_RDP_MNEMONIC("color=$%08lx\n", rdp_reg.cmd1);
#endif
        rdp_reg.primcolor = rdp_reg.cmd1;

} /* static void rdp_setprimcolor() */





static void rdp_setenvcolor()
{
		LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETENVCOLOR\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETENVCOLOR ");
        PRINT_RDP_MNEMONIC("color=$%08lx\n", rdp_reg.cmd1);
#endif
        rdp_reg.envcolor = rdp_reg.cmd1;

} /* static void rdp_setenvcolor() */


static void rdp_settextureimage()
{
        static char *format[]   = { "RGBA", "YUV", "CI", "IA", "I", "?", "?", "?" };
        static char *size[]     = { "4bit", "8bit", "16bit", "32bit" };


        rdp_reg.TextureImage.fmt	  = (_u8)((rdp_reg.cmd0 >> 21) & 0x07);
        rdp_reg.TextureImage.size	  = (_u8)((rdp_reg.cmd0 >> 19) & 0x03);
        rdp_reg.TextureImage.width	  = (_u16)(1 + (rdp_reg.cmd0 & 0x00000fff));
        rdp_reg.TextureImage.addr	  = segoffset2addr(rdp_reg.cmd1);
		rdp_reg.TextureImage.vaddr	  = rdp_reg.cmd0;


//		rdp_reg.TextureImage.LoadAddr = &pRDRAM[rdp_reg.TextureImage.addr];

	LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETTEXTUREIMAGE\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETTEXTUREIMAGE ");
        PRINT_RDP_MNEMONIC("	format=%s; size=%s; width=%hu; addr=$%08lx\n",
               format[rdp_reg.TextureImage.fmt],
               size[rdp_reg.TextureImage.size],
               rdp_reg.TextureImage.width,
               rdp_reg.TextureImage.addr);
#endif
} /* static void rdp_settextureimage() */





static void rdp_setdepthimage()
{

	LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETDEPTHIMAGE\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETDEPTHIMAGE ");
        PRINT_RDP_MNEMONIC("addr=$%lx\n", rdp_reg.cmd1);
#endif
//FIRES        rdp_reg.depthimg_addr = segoffset2addr(rdp_reg.cmd1);

} /* static void rdp_setdepthimage() */





static void rdp_setcolorimage()
{
        static char *format[]   = { "RGBA", "YUV", "CI", "IA", "I", "?", "?", "?" };
        static char *size[]     = { "4bit", "8bit", "16bit", "32bit" };

		//if (rdp_reg.colorimg_addr != (segoffset2addr(rdp_reg.cmd1))) Render_FlushVisualRenderBuffer();

		//Render_ClearVisual();

        rdp_reg.colorimg_fmt   = (_u8)((rdp_reg.cmd0 & 0x00e00000) >> 21);
        rdp_reg.colorimg_size  = (_u8)((rdp_reg.cmd0 & 0x00180000) >> 19);
        rdp_reg.colorimg_width = (_u16)((rdp_reg.cmd0 & 0x00000fff)+1);
//        rdp_reg.TextureImage.width	  = (_u16)(1 + (rdp_reg.cmd0 & 0x00000fff));
        rdp_reg.colorimg_addr = segoffset2addr(rdp_reg.cmd1);


	LOG_TO_FILE("%08X: %08X %08X CMD RDP_SETCOLORIMAGE\n",
				 ADDR, CMD0, CMD1);

#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETCOLORIMAGE ");
        PRINT_RDP_MNEMONIC("format=%s; size=%s; width=%hu; addr=$%lx\n",
                           format[rdp_reg.colorimg_fmt],
                           size[rdp_reg.colorimg_size],
                           rdp_reg.colorimg_width,
                           rdp_reg.colorimg_addr);
#endif
        //printf("%x\n", rdp_reg.colorimg_addr);
/*                SetVisualRenderBuffer(
                        rdp_reg.colorimg_fmt, rdp_reg.colorimg_size,
                        rdp_reg.colorimg_width, rdp_reg.colorimg_addr + (_u8 *)pRDRAM);
*/
} /* static void rdp_setcolorimage() */





static void rdp_trifill()
{
        PRINT_RDP_NOT_IMPLEMENTED("TRIFILL");
} /* static void rdp_trifill() */





static void rdp_trishade()
{
        PRINT_RDP_NOT_IMPLEMENTED("TRISHADE");
} /* static void rdp_trishade() */





static void rdp_tritxtr()
{
        PRINT_RDP_NOT_IMPLEMENTED("TRITXTR");
} /* static void rdp_tritxtr() */





static void rdp_trishadetxtr()
{
        PRINT_RDP_NOT_IMPLEMENTED("TRISHADETXTR");
} /* static void rdp_trishadetxtr() */





static void rdp_trifillz()
{
        PRINT_RDP_NOT_IMPLEMENTED("TRIFILLZ");
} /* static void rdp_trifillz() */





static void rdp_trishadez()
{
        PRINT_RDP_NOT_IMPLEMENTED("TRISHADEZ");
} /* static void rdp_trishadez() */





static void rdp_tritxtrz()
{
        PRINT_RDP_NOT_IMPLEMENTED("TRITXTRZ");
} /* static void rdp_tritxtrz() */





static void rdp_trishadetxtrz()
{
        PRINT_RDP_NOT_IMPLEMENTED("TRISHADETXTRZ");
} /* static void rdp_trishadetxtrz() */

