/**
 * Mupen64 - compare_core.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <sys/stat.h>
#include "r4300.h"
#include "../memory/memory.h"

static FILE *f;
static int pipe_opened = 0;
static long long int comp_reg[32];
extern unsigned long op;
static unsigned long old_op;

void display_error()
{
   printf("erreur @:%x\n", (int)old_op);
   printf("erreur @:%x\n", (int)op);
   stop=1;
}

/*void check_input();
extern unsigned long controller_state;
void check_input_sync()
{
   if (!dynacore && interpcore)
     {
	fread(&controller_state, 4, 1, f);
     }
   else
     {
	check_input();
	fwrite(&controller_state, 4, 1, f);
     }
}*/

void compare_core()
{   
   if (!dynacore && interpcore)
     {
	if (!pipe_opened)
	  {
	     mkfifo("compare_pipe", 0600);
	     f = fopen("compare_pipe", "r");
	     pipe_opened = 1;
	  }
	fread (comp_reg, 32, sizeof(long long int), f);
	if (memcmp(reg, comp_reg, 32*sizeof(long long int)))
	  display_error();
	/*fread (comp_reg, 32, sizeof(long long int), f);
	if (memcmp(reg_cop0, comp_reg, 32*sizeof(long long int)))
	  display_error();
	fread (comp_reg, 32, sizeof(long int), f);
	if (memcmp(reg_cop1_fgr_32, comp_reg, 32*sizeof(long int)))
	  display_error();*/
	old_op = op;
     }
   else
     {
	if (!pipe_opened)
	  {
	     f = fopen("compare_pipe", "w");
	     pipe_opened = 1;
	  }
	fwrite(reg, 32, sizeof(long long int), f);
	//fwrite(reg_cop0, 32, sizeof(long long int), f);
	//fwrite(reg_cop1_fgr_32, 32, sizeof(long int), f);
     }
}
