/**
 * Mupen64 - exception.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "exception.h"
#include "r4300.h"
#include "macros.h"
#include "../memory/memory.h"
#include "recomph.h"

void address_error_exception()
{
   printf("address_error_exception\n");
   stop=1;
}

void TLB_invalid_exception()
{
   printf("TLB invalid exception\n");
   stop=1;
}

void XTLB_refill_exception(unsigned long long int addresse)
{
   printf("XTLB refill exception\n");
   stop=1;
}

void TLB_refill_exception(unsigned long addresse, int w)
{
   if (delay_slot)
     {
	skip_jump = 1;
	printf("on est dans le delay slot\nTLB refill exception\n");
	stop=1;
     }
   else
     {
	if (w) Cause |= 0x20;
	else Cause |= 0x10;
	if (Status & 0x2) // Test de EXL
	  {
	     if (dynacore) printf("dynamic TLB refill exception, EXL=1\n");
	     else jump_to(0x80000180);
	  }
	else
	  {
	     if (!dynacore) EPC = PC->addr;
	     else
	       {
		  if (pending) EPC = PC->addr;
		  else EPC = (PC+1)->addr;
	       }
	     sign_extended(EPC);
	     Cause &= ~0x80000000;
	     Status |= 0x2; //EXL=1
	     if (dynacore) printf("dynamic TLB refill exception\n");
	     else jump_to(0x80000000);
	  }
     }
}

void TLB_mod_exception()
{
   printf("TLB mod exception\n");
   stop=1;
}

void integer_overflow_exception()
{
   printf("integer overflow exception\n");
   stop=1;
}

void coprocessor_unusable_exception()
{
   printf("coprocessor_unusable_exception\n");
   stop=1;
}

extern unsigned long interp_addr;

void exception_general()
{
   if (delay_slot) skip_jump = 1;
   Status |= 2;
   if (!dynacore)
     {
	if (!interpcore) EPC = PC->addr;
	else EPC = interp_addr;
     }
   else
     {
	if (pending) EPC = PC->addr;
	else EPC = (PC+1)->addr;
     }
   sign_extended(EPC);
   if(delay_slot==1 || delay_slot==3)
     {
	Cause |= 0x80000000;
	EPC-=4;
	//if (dynacore)
	  check_eret();
     }
   else
     {
	Cause &= 0x7FFFFFFF;
     }
   if (dynacore) dyna_exception();
   else if (interpcore) interp_addr = 0x80000180;
   else jump_to(0x80000180);
}
