/**
 * Mupen64 - gcop1_d.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include "../recomph.h"
#include "assemble.h"
#include "../r4300.h"
#include "../ops.h"

void genadd_d()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fadd_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);
   genupdate_system(0);
}

void gendiv_d()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fdiv_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);
   genupdate_system(0);
}

void gensub_d()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fsub_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);
   genupdate_system(0);
}

void genmul_d()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.ft);
   fmul_preg32_qword(EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);
   genupdate_system(0);
}

void genmov_d()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   mov_reg32_preg32(EBX, EAX);
   add_reg32_imm8(EAX, 4);
   mov_reg32_preg32(ECX, EAX);
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   mov_preg32_reg32(EAX, EBX);
   add_reg32_imm8(EAX, 4);
   mov_preg32_reg32(EAX, ECX);
   genupdate_system(0);
}

void genneg_d()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fs);
   fld_preg32_qword(EAX);
   fchs();
   mov_eax_memoffs32((unsigned long *)(reg_cop1_simple) + dst->f.cf.fd);
   fstp_preg32_qword(EAX);
   genupdate_system(0);
}

void gencvt_s_d()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(CVT_S_D));
   call_reg32(EAX);
   genupdate_system(0);
}

void gencvt_w_d()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(CVT_W_D));
   call_reg32(EAX);
   genupdate_system(0);
}

void gentrunc_w_d()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(TRUNC_W_D));
   call_reg32(EAX);
   genupdate_system(0);
}

void genc_le_d()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_LE_D));
   call_reg32(EAX);
   genupdate_system(0);
}

void genc_lt_d()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_LT_D));
   call_reg32(EAX);
   genupdate_system(0);
}

void genc_eq_d()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(C_EQ_D));
   call_reg32(EAX);
   genupdate_system(0);
}
