/**
 * Mupen64 - pif.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>

#include "memory.h"
#include "pif.h"
#include "../r4300/r4300.h"
#include "../r4300/interupt.h"
#include "../main/winlnxdefs.h"
#include "../main/plugin.h"

//#define DEBUG_PIF
#ifdef DEBUG_PIF
void print_pif()
{
   int i;
   for (i=0; i<(64/8); i++)
     printf("%x %x %x %x | %x %x %x %x\n",
	    PIF_RAMb[i*8+0], PIF_RAMb[i*8+1],PIF_RAMb[i*8+2], PIF_RAMb[i*8+3],
	    PIF_RAMb[i*8+4], PIF_RAMb[i*8+5],PIF_RAMb[i*8+6], PIF_RAMb[i*8+7]);
   getchar();
}
#endif

void EepromCommand(BYTE *Command)
{
   switch (Command[2])
     {
      case 0: // check -> have to implement 16K eeprom when ini file will be working
	Command[1] |= 0x80;
	break;
      default:
	printf("unknown command in EepromCommand : %x\n", Command[2]);
     }
}

void internal_ReadController(int Control, BYTE *Command)
{
   switch (Command[2])
     {
      case 1:
	if (Controls[Control].Present)
	  {
	     BUTTONS Keys;
	     getKeys(Control, &Keys);
	     *((unsigned long *)(Command + 3)) = Keys.Value;
	  }
	break;
      case 2:
	printf("read controller pack in internal_ReadController\n");
	break;
      case 3:
	printf("write controller pack in internal_ReadController\n");
	break;
     }
}

void internal_ControllerCommand(int Control, BYTE *Command)
{
   switch (Command[2])
     {
      case 0x00: // check
      case 0xFF:
	if ((Command[1] & 0x80))
	  break;
	if (Controls[Control].Present)
	  {
	     Command[3] = 0x05;
	     Command[4] = 0x00;
	     switch(Controls[Control].Plugin)
	       {
		case PLUGIN_MEMPAK:
		  Command[5] = 1;
		  break;
		case PLUGIN_RAW:
		  Command[5] = 1;
		  break;
		default:
		  Command[5] = 0;
		  break;
	       }
	  }
	else
	  Command[1] |= 0x80;
	break;
      case 0x01:
	if (!Controls[Control].Present)
	  Command[1] |= 0x80;
	break;
      case 0x02:
	printf("read controller pack in internal_ControllerCommand\n");
	break;
      case 0x03:
	printf("write controller pack in internal_ControllerCommand\n");
	break;
     }
}

void update_pif_write()
{
   int i=0, channel=0;
#ifdef DEBUG_PIF
   printf("write\n");
   print_pif();
#endif
   if (PIF_RAMb[0x3F] > 1)
     {
	switch (PIF_RAMb[0x3F])
	  {
	   case 0x08:
	     PIF_RAMb[0x3F] = 0;
	     MI_register.mi_intr_reg |= 0x02;
	     gen_mi();
	     break;
	   default:
	     printf("error in update_pif_write : %x\n", PIF_RAMb[0x3F]);
	  }
	return;
     }
   while (i<0x40)
     {
	switch(PIF_RAMb[i])
	  {
	   case 0x00:
	     channel++;
	     if (channel > 6) i=0x40;
	     break;
	   case 0xFF:
	     break;
	   default:
	     if (!(PIF_RAMb[i] & 0xC0))
	       {
		  if (channel < 4)
		    {
		       if (Controls[channel].Present && 
			   Controls[channel].RawData)
			 controllerCommand(channel, &PIF_RAMb[i]);
		       else
			 internal_ControllerCommand(channel, &PIF_RAMb[i]);
		    }
		  else if (channel == 4)
		    EepromCommand(&PIF_RAMb[i]);
		  else
		    printf("channel >= 4 in update_pif_write\n");
		  i += PIF_RAMb[i] + (PIF_RAMb[(i+1)] & 0x3F) + 1;
		  channel++;
	       }
	     else
	       i=0x40;
	  }
	i++;
     }
   PIF_RAMb[0x3F] = 0;
   controllerCommand(-1, NULL);
#ifdef DEBUG_PIF
   print_pif();
#endif
}

void update_pif_read()
{
   int i=0, channel=0;
#ifdef DEBUG_PIF
   printf("read\n");
   print_pif();
#endif
   while (i<0x40)
     {
	switch(PIF_RAMb[i])
	  {
	   case 0x00:
	     channel++;
	     if (channel > 6) i=0x40;
	     break;
	   case 0xFE:
	     i = 0x40;
	     break;
	   case 0xFF:
	     break;
	   case 0xB4:
	   case 0x56:
	   case 0xB8:
	     break;
	   default:
	     if (!(PIF_RAMb[i] & 0xC0))
	       {
		  if (channel < 4)
		    {
		       if (Controls[channel].Present && 
			   Controls[channel].RawData)
			 readController(channel, &PIF_RAMb[i]);
		       else
			 internal_ReadController(channel, &PIF_RAMb[i]);
		    }
		  i += PIF_RAMb[i] + (PIF_RAMb[(i+1)] & 0x3F) + 1;
		  channel++;
	       }
	     else
	       i=0x40;
	  }
	i++;
     }
   readController(-1, NULL);
#ifdef DEBUG_PIF
   print_pif();
#endif
}
