#ifndef _TEXTURE_H_
#define _TEXTURE_H_

typedef void (*NCopyTexture)(_u8 *i_src, _u8 *i_dst, _s32 sx, _s32 ex, _s32 sy, _s32 ey);

typedef struct
{
	_u16 old_bytes[3];
	_u16 *addr;
	_u16 *addr2;
	_u16 *addr3;
} t_old_texture;

typedef struct
{
	_s16	TexID;
	int		TexMode;
	_u32	TexColor;
	int		offset;
	int		NextID;
	int		Palette;
	int		Size;
} t_index_texture;

extern int SetActiveTexture();
extern int SetActiveTextureTexRect(int uls,int ult,int lrs,int lrt);

// Texture Modes
#define AlphaT0								0x01
#define Tex									0x02
#define Prim_Sub_Tex						0x04
#define Env_Sub_Tex							0x08
#define YUV									0x10
#define Tex_Sub_Prim						0x14
#define Tex_Sub_Env							0x18
#define Tex_Sub_Env_Mult_Prim_Add_Env		0x40
#define Tex_Sub_Env_Mult_Tex_Add_Prim		0x41
#define Prim_Sub_Env_Mult_Tex_Add_Env		0x42
#define Env_Sub_Tex_Mult_EnvAlpha_Add_Tex	0x43
#define Tex_Sub_Prim_Mult_Env_Add_Prim		0x44
#define Alpha_Mult_Prim						0x80
#define Alpha_Mult_Env						0x81
#define AlphaT0Red							0x100
#endif
