#include <stdlib.h>
#include <stdio.h>
#ifdef __WIN32__
#include <windows.h>
#include <direct.h>

#include "resource.h"
#else
#include "winlnxdefs.h"
#include <string.h>
#endif
#include "crc_ucode.h"

extern unsigned char	*pROM;

char video_ini[1024];
int ucode=-1;
BOOL HandsetUcode;
HWND hConfig;
extern HWND g_hWnd;
extern HINSTANCE g_hInstance;



#ifdef __WIN32__
LRESULT CALLBACK ConfigProc(HWND hDlg, unsigned message, WORD wParam, LONG lParam);
void CreateConfigDlg();
#endif

void GetPluginDir( char * Directory ) 
{
#ifdef __WIN32__
	char path_buffer[_MAX_PATH], drive[_MAX_DRIVE] ,dir[_MAX_DIR];
	char fname[_MAX_FNAME],ext[_MAX_EXT];
 	GetModuleFileName(NULL,path_buffer,sizeof(path_buffer));
	_splitpath( path_buffer, drive, dir, fname, ext );
	strcpy(Directory,drive);
	strcat(Directory,dir);
	strcat(Directory,"Plugin\\");
#else
        strcpy(Directory, "plugins/");
#endif
}

int GetUCode()
{
#ifdef __WIN32__
	t_romheader header;
	char *p = (char*)&header;
	int i;
	char CRC_Entry[1024];


        if (ucode != -1) 
		return ucode;

	for (i = 0; i<sizeof(t_romheader); i++)
	{
		p[i] = pROM[i^3];
	}


// Generate String of video.ini
	GetPluginDir(video_ini);
	strcat(video_ini, "\\tr64_ogl.ini");
	WritePrivateProfileStringW( NULL, NULL, NULL, L"appname.ini" ); 


	sprintf(CRC_Entry,"%08X%08X-%02X", header.crc1, header.crc2, header.countrycode);

// Load Number of UCodeTable-entries
	ucode = GetPrivateProfileInt(CRC_Entry, "UCode", -1, video_ini);
	while (ucode == -1)
	{
		char temp[1024];
		//CreateConfigDlg();

// the message handling sux if i create the Dlg here :(((
// i think it is a thread problem :((

		MessageBox(NULL, "Config your UCode\nChange to the GUI and click Config", "TR64 ogl", MB_OK);

		sprintf(temp,"-1");
		WritePrivateProfileString(CRC_Entry, "Name", (char*)header.name, video_ini);
		WritePrivateProfileString(CRC_Entry, "UCode", "-1", video_ini);	
		
		sprintf(temp, "Cant find UCode for ROM \"%s\".\nLook for UCode=-1 in the tr64_ogl.ini\n [%s]", (char*)header.name, CRC_Entry);
	}
	return ucode;
#else
	char c, s[2];
	if (ucode != -1) 
		return ucode;
	while (ucode < 0 || ucode > 6)
	   {
	      printf("please select the ucode:");
	      c = getchar();
	      s[0] = c;
	      s[1] = 0;
	      ucode =  atoi(s);
	   }
	printf("selected ucode : %d\n", ucode);
	return ucode;
#endif
}




#ifdef __WIN32__

//////////////////////////////////////////////////////////////////////////////
//  														//
//////////////////////////////////////////////////////////////////////////////
int GetSelectedUCode()
{
	if (SendDlgItemMessage(hConfig, IDC_UC0 ,BM_GETCHECK, 0,0) == BST_CHECKED)
		return 0;
	if (SendDlgItemMessage(hConfig, IDC_UC1 ,BM_GETCHECK, 0,0) == BST_CHECKED)
		return 1;
	if (SendDlgItemMessage(hConfig, IDC_UC2 ,BM_GETCHECK, 0,0) == BST_CHECKED)
		return 2;
	if (SendDlgItemMessage(hConfig, IDC_UC3 ,BM_GETCHECK, 0,0) == BST_CHECKED)
		return 3;
	if (SendDlgItemMessage(hConfig, IDC_UC4 ,BM_GETCHECK, 0,0) == BST_CHECKED)
		return 4;
	if (SendDlgItemMessage(hConfig, IDC_UC5 ,BM_GETCHECK, 0,0) == BST_CHECKED)
		return 5;
	if (SendDlgItemMessage(hConfig, IDC_UC6 ,BM_GETCHECK, 0,0) == BST_CHECKED)
		return 6;

	return -1;
}


//////////////////////////////////////////////////////////////////////////////
// //
//////////////////////////////////////////////////////////////////////////////
void SetUCodeButton(int button)
{
	switch (button)
	{
	case 0:
		SendDlgItemMessage(hConfig, IDC_UC0 ,BM_SETCHECK, BST_CHECKED,0);	
		break;
	case 1:
		SendDlgItemMessage(hConfig, IDC_UC1 ,BM_SETCHECK, BST_CHECKED,0);	
		break;
	case 2:
		SendDlgItemMessage(hConfig, IDC_UC2 ,BM_SETCHECK, BST_CHECKED,0);	
		break;
	case 3:
		SendDlgItemMessage(hConfig, IDC_UC3 ,BM_SETCHECK, BST_CHECKED,0);	
		break;
	case 4:
		SendDlgItemMessage(hConfig, IDC_UC4 ,BM_SETCHECK, BST_CHECKED,0);	
		break;
	case 5:
		SendDlgItemMessage(hConfig, IDC_UC5 ,BM_SETCHECK, BST_CHECKED,0);	
		break;
	case 6:
		SendDlgItemMessage(hConfig, IDC_UC6 ,BM_SETCHECK, BST_CHECKED,0);	
		break;
	}
}


//////////////////////////////////////////////////////////////////////////////
// Set Comment Proc 														//
//////////////////////////////////////////////////////////////////////////////
void SaveUCode()
{
	t_romheader header;
	char *p = (char*)&header;
	int i;
	char CRC_Entry[1024], temp[32];

	if (!HandsetUcode) return;
	if (MessageBox(NULL, "Do ya want to Save your selected UCode ??", "UCode", MB_YESNO|MB_ICONQUESTION) == IDNO) return;



	for (i = 0; i<sizeof(t_romheader); i++)
	{
		p[i] = pROM[i^3];
	}

// Generate String of video.ini
	GetPluginDir(video_ini);
	strcat(video_ini, "\\tr64_ogl.ini");


	sprintf(temp, "%i", ucode);
	sprintf(CRC_Entry,"%08X%08X-%02X", header.crc1, header.crc2, header.countrycode);
	WritePrivateProfileString(CRC_Entry, "Name", (char*)header.name, video_ini);
	WritePrivateProfileString(CRC_Entry, "UCode", temp, video_ini);	
}



//////////////////////////////////////////////////////////////////////////////
// Init Comment Proc 														//
//////////////////////////////////////////////////////////////////////////////
void CreateConfigDlg()
{
	if (!hConfig)
		hConfig = CreateDialog(g_hInstance, "IDD_CONFIG", g_hWnd, (DLGPROC)ConfigProc);
	SetUCodeButton(1);
}



//////////////////////////////////////////////////////////////////////////////
// Set Comment Proc 														//
//////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK ConfigProc(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
	switch (message) 
	{
       case WM_INITDIALOG:
            return (TRUE);
			break;

        case WM_COMMAND:
			switch (wParam) 
			{
				case IDOK:
					{
						ucode = GetSelectedUCode();
						HandsetUcode = TRUE;
						EndDialog(hDlg, TRUE);
						hConfig = NULL;						
					}
					return (TRUE);
					break;

				case IDCANCEL:
					EndDialog(hDlg, TRUE);
					hConfig = NULL;
					return (TRUE);
					break;
			}
			break;
	}
	return FALSE;
}
#endif
