#include <GL/gl.h>

//////////////////////////////////////////////////////////////////////////////
// Perfect Darkness															//
// Goldeneye																//
//////////////////////////////////////////////////////////////////////////////

void rsp_uc05_matrix();
void rsp_uc05_movemem();
void rsp_uc05_vertex();
void rsp_uc05_displaylist();
void rsp_uc05_sprite2d();

void rsp_uc05_tri4();
void rsp_uc05_rdphalf_cont();
void rsp_uc05_rdphalf_2();
void rsp_uc05_rdphalf_1();
void rsp_uc05_line3d();
void rsp_uc05_cleargeometrymode();
void rsp_uc05_setgeometrymode();
void rsp_uc05_enddl();
void rsp_uc05_setothermode_l();
void rsp_uc05_setothermode_h();
void rsp_uc05_texture();
void rsp_uc05_moveword();
void rsp_uc05_popmatrix();
void rsp_uc05_culldl();
void rsp_uc05_tri1();



//////////////////////////////////////////////////////////////////////////////
// structure is tricky for changing the endians								//
//////////////////////////////////////////////////////////////////////////////
typedef struct 
{
	_s16 y;
	_s16 x;
//	_u16 flags;

	_u8 t;
	_u8 s;

	_s16 z;

//	_s16 t;
//	_s16 s;

	_u8  a;
	_u8  b;
	_u8  g;
	_u8  r;
} t_vtx_uc5;


//////////////////////////////////////////////////////////////////////////////
// LoadVertex																//
//////////////////////////////////////////////////////////////////////////////
void rsp_uc05_vertex()
{
	_u32	a = segoffset2addr(rdp_reg.cmd1);
	int     v0, i, n, len;

	v0 = (CMD0 & 0x0F0000) >> 16;
	n = ((CMD0 & 0xF00000) >> 20) + 1;

	if ((CMD0 & 0xFFF00) != 0)
	{
		int t = 0;
	}

	LOG_TO_FILE("%08X: %08X %08X CMD UC5_LOADVTX  vertex %i..%i\n",
				 ADDR, CMD0, CMD1,  v0, n-1);

	for(i = 0; i < n; i++)
	{
		t_vtx_uc5 *vtx = (t_vtx_uc5 *)&pRDRAM[a+(i*sizeof(t_vtx_uc5))];

		rdp_reg.vtx[v0].x     = (float)vtx->x;
		rdp_reg.vtx[v0].y     = (float)vtx->y;
		rdp_reg.vtx[v0].z     = (float)vtx->z;
/*		rdp_reg.vtx[v0].flags = (_u16)vtx->flags;
		rdp_reg.vtx[v0].s     = 1.0f; //(float)vtx->s;
		rdp_reg.vtx[v0].t     = 1.0f; //(float)vtx->t;
*/
		rdp_reg.vtx[v0].flags = 0;
		rdp_reg.vtx[v0].s     = (float)vtx->s;
		rdp_reg.vtx[v0].t     = (float)vtx->t;

		rdp_reg.vtx[v0].r     = (_u8)vtx->r;
		rdp_reg.vtx[v0].g     = (_u8)vtx->g;
		rdp_reg.vtx[v0].b     = (_u8)vtx->b;
		rdp_reg.vtx[v0].a     = (_u8)vtx->a;

		LOG_TO_FILE("   vtx[%02i]: [xyz %04X %04X %04X] -> %12.5f %12.5f %12.5f [%02X,%02X,%02X]\n",
		      v0, vtx->x, vtx->y, vtx->z, 
			  rdp_reg.vtx[v0].x, rdp_reg.vtx[v0].y, rdp_reg.vtx[v0].z,
			  rdp_reg.vtx[v0].r, rdp_reg.vtx[v0].g, rdp_reg.vtx[v0].b);

		v0++;
	}
}




void rsp_uc05_tri4()
{
	int     vn[3];

	LOG_TO_FILE("%08X: %08X %08X CMD UC5_TRI2", ADDR, CMD0, CMD1);
	
	vn[0] = ((CMD1 & 0xf0) >> 4);
	vn[1] = ((CMD1 & 0x0f) >> 0);
	vn[2] = ((CMD0 & 0x0f) >> 0);

	if ((vn[0] !=0) || (vn[1] !=0) || (vn[2] !=0))
	{
		DrawVisualTriangle(vn);
//		Render_triangle(vn);
		LOG_TO_FILE("(%i,%i,%i)", vn[0], vn[1], vn[2]);
	}

	vn[0] = ((CMD1 & 0xf000) >> 12);
	vn[1] = ((CMD1 & 0x0f00) >>  8);
	vn[2] = ((CMD0 & 0xf0)   >>  4);
	if ((vn[0] !=0) || (vn[1] !=0) || (vn[2] !=0))
	{
		DrawVisualTriangle(vn);
//		Render_triangle(vn);
		LOG_TO_FILE("(%i,%i,%i)", vn[0], vn[1], vn[2]);
	}

	vn[0] = ((CMD1 & 0xf00000) >> 20);
	vn[1] = ((CMD1 & 0x0f0000) >> 16);
	vn[2] = ((CMD0 & 0x0f00)   >>  8);
	if ((vn[0] !=0) || (vn[1] !=0) || (vn[2] !=0))
	{
		DrawVisualTriangle(vn);
//		Render_triangle(vn);
		LOG_TO_FILE("(%i,%i,%i)", vn[0], vn[1], vn[2]);
	}

	vn[0] = ((CMD1 & 0xf0000000) >> 28);
	vn[1] = ((CMD1 & 0x0f000000) >> 24);
	vn[2] = ((CMD0 & 0xf000)	 >> 12);
	if ((vn[0] !=0) || (vn[1] !=0) || (vn[2] !=0))
	{
		DrawVisualTriangle(vn);
//		Render_triangle(vn);
		LOG_TO_FILE("(%i,%i,%i)", vn[0], vn[1], vn[2]);
	}
	LOG_TO_FILE("\n");
} // void rsp_uc05_tri4()


//seems to be okay
void rsp_uc05_texture()
{
        int tile = (rdp_reg.cmd0 >> 8)  & 0x07;				//** tile
		_u32 mipmap_level = (rdp_reg.cmd0 >> 11) & 0x07;	//** mipmap_level   - not used yet
		_u32 on = (rdp_reg.cmd0 & 0xff);			//** 1: on - 0:off

		float s = (float)((rdp_reg.cmd1 >> 16) & 0xffff);
		float t = (float)((rdp_reg.cmd1      ) & 0xffff);

		t_tile *tmp_tile = &rdp_reg.td[tile];
		tmp_tile->Texture_on = (_u8)on;

		tmp_tile->SScale=(float)s/65535.f;
		tmp_tile->TScale=(float)t/65535.f;

		tmp_tile->TScale/=32.f;
		tmp_tile->SScale/=32.f;

	LOG_TO_FILE("%08X: %08X %08X CMD UC5_TEXTURE NC\n", ADDR, CMD0, CMD1);
}

void rsp_uc05_popmatrix()
{
//	_u32 param = (CMD1 / 64);


//	while(param)
//	{
		Render_pop_modelview();
//		param--;
//	}

		LOG_TO_FILE("%08X: %08X %08X CMD UC5_POPMATRIX \n", ADDR, CMD0, CMD1);
}


void rsp_uc05_matrix()
{

        _u32   a = segoffset2addr(rdp_reg.cmd1);
        _u8   command =(_u8)((CMD0 & 0xF0000) >> 16);
        float   m[4][4];
        int     i, j;

		//hleGetMatrix((float*)m, (DWORD*)&pRDRAM[a]);
           a = a >> 1;  
 for(i=0;i<16;i+=4)
  {
   for(j=0;j<4;j++)
       {
     m[i>>2][j] = (float)
      ((((long)((unsigned short *)pRDRAM)[(a + i + j)^1]) << 16) |
       ((unsigned short *)pRDRAM)[(a + i + j + 16)^1]) / 65536.0f;
    }
  }
   

		LOG_TO_FILE("%08X: %08X %08X CMD UC5_LOADMTX  at %08X ", ADDR, CMD0, CMD1, a);

         switch(command)
        {

            case 0: // modelview  mul  nopush 
				LOG_TO_FILE("modelview  mul  nopush\n");
                mult_matrix((GLfloat *)m);
                break;

            case 1: // projection mul  nopush 
            case 5: // projection mul  push   
				LOG_TO_FILE("projection mul  nopush\n");
                Render_mul_projection(m);
                break;

            case 2: // modelview  load nopush 
				LOG_TO_FILE("modelview  load nopush\n");
                load_matrix((GLfloat *)m);
                break;

            case 3: // projection load nopush 
            case 7: // projection load push   
				LOG_TO_FILE("projection load nopush\n");
                glLoadMatrixf((GLfloat *)m);
                break;

            case 4: // modelview  mul  nopush 
				LOG_TO_FILE("modelview  mul  nopush\n");
                push_mult_matrix((GLfloat *)m);
                break;

            case 6: // modelview  load push   
				LOG_TO_FILE("modelview  load push\n");
                push_load_matrix((GLfloat *)m);
                break;


			default:
				LOG_TO_FILE("unknown Command %x\n", command);
				DebugBox("MISSING MATRIX COMMAND");
				exit(1);
				break;
        } /* switch(command) */

        //
        LOG_TO_FILE(
				"Load matrix\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "        { %#+12.5f %#+12.5f %#+12.5f %#+12.5f }\n"
                "\n",
                m[0][0], m[0][1], m[0][2], m[0][3],
                m[1][0], m[1][1], m[1][2], m[1][3],
                m[2][0], m[2][1], m[2][2], m[2][3],
                m[3][0], m[3][1], m[3][2], m[3][3]
                );
}

void rsp_uc05_displaylist()
{
        _u32 addr = segoffset2addr(CMD1);
        _u8  push = (_u8)(CMD0 >> 16) & 0xff; 

	LOG_TO_FILE("%08X: %08X %08X CMD UC5_DISPLAYLIST \n", ADDR, CMD0, CMD1);

        switch(push)
        {
            case 0:   // push: we do a call of the dl 
                rdp_reg.pc_i++;
                if(rdp_reg.pc_i > 9)
                {
					DebugBox("DList Stack overflow");
					return;
                }
                rdp_reg.pc[rdp_reg.pc_i] = addr;
                break;

            case 1:   // branch 
                rdp_reg.pc[rdp_reg.pc_i] = addr;
                break;

            default:
                DebugBox("Unknow DList command");
                break;

        } // switch(push) 

}

void rsp_uc05_enddl()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC5_ENDDISPLAYLIST \n", ADDR, CMD0, CMD1);
	if(rdp_reg.pc_i < 0)
	{
		DebugBox("EndDL - Display Stack underrun");
		rdp_reg.halt = 1;
		return;
	}

	if(rdp_reg.pc_i == 0)
	{
		rdp_reg.halt = 1;
	}
	rdp_reg.pc_i--;
}






//////////////////////////////////////////////////////////////////////////////
// UCode 1 functions
//////////////////////////////////////////////////////////////////////////////



void rsp_uc05_setgeometrymode()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC5_SETGEOMETRYMODE \n", ADDR, CMD0, CMD1);
#ifdef WRITE_LOG
        PRINT_RDP_INFO("SETGEOMETRYMODE ");
        PRINT_RDP_MNEMONIC(
                "+$%08lx:\n"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s",
                rdp_reg.cmd1,
                (rdp_reg.cmd1 & 0x00000001) ? "        zbuffer\n" : "",
                (rdp_reg.cmd1 & 0x00000002) ? "        texture\n" : "",
                (rdp_reg.cmd1 & 0x00000004) ? "        shade\n" : "",
                (rdp_reg.cmd1 & 0x00000200) ? "        shade smooth\n" : "",
                (rdp_reg.cmd1 & 0x00001000) ? "        cull front\n" : "",
                (rdp_reg.cmd1 & 0x00002000) ? "        cull back\n" : "",
                (rdp_reg.cmd1 & 0x00010000) ? "        fog\n" : "",
                (rdp_reg.cmd1 & 0x00020000) ? "        lightning\n" : "",
                (rdp_reg.cmd1 & 0x00040000) ? "        texture gen\n" : "",
                (rdp_reg.cmd1 & 0x00080000) ? "        texture gen lin\n" : "",
                (rdp_reg.cmd1 & 0x00100000) ? "        lod\n" : ""
                );
#endif
        rdp_reg.geometrymode |= rdp_reg.cmd1;

        if(rdp_reg.cmd1 & 0x00000002)
                rdp_reg.geometrymode_textures = 1;

//		Render_geometry_zbuffer(1);
        if(rdp_reg.cmd1 & 0x00000001)
                Render_geometry_zbuffer(1);
//		else
//                Render_geometry_zbuffer(0);

//		if (rdp_reg.geometrymode & 0x00003000) Render_geometry_cullfrontback(0);
        switch(rdp_reg.geometrymode & 0x00003000)
        {
            case 0x1000:
                Render_geometry_cullfront(1);
                break;
            case 0x2000:
                Render_geometry_cullback(1);
                break;
            case 0x3000:
                Render_geometry_cullfrontback(1);
                break;
            default:
//                Render_geometry_cullfrontback(0);
				break;
        } //** switch(rdp_reg.geometrymode & 0x00003000) 


		if((rdp_reg.cmd1 & 0x00020000) != 0)
				rdp_reg.useLights = 1;

}

void rsp_uc05_moveword()
{
        int i;

        switch(rdp_reg.cmd0 & 0xff)
        {
            case 0x00:
#ifdef WRITE_LOG
                PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD MATRIX");
#endif                
                break;

            case 0x02:
                rdp_reg.lights = (rdp_reg.cmd1 - 0x80000000) / 32 - 1;
				//calculate_light_vectors();
#ifdef WRITE_LOG
                PRINT_RDP_INFO("MOVEWORD NUMLIGHT: ");
                PRINT_RDP_MNEMONIC("lights: %d\n", rdp_reg.lights);
#endif
                break;

            case 0x04:
#ifdef WRITE_LOG
                PRINT_RDP_INFO("MOVEWORD CLIP: ");
#endif
				switch((rdp_reg.cmd0 >> 8) & 0xffff)
                {
                    case 0x0004:
#ifdef WRITE_LOG
                        PRINT_RDP_MNEMONIC("-x = ");
#endif
                        rdp_reg.clip.nx = rdp_reg.cmd1;
                        break;

                    case 0x000c:
#ifdef WRITE_LOG
                        PRINT_RDP_MNEMONIC("-y = ");
#endif
                        rdp_reg.clip.ny = rdp_reg.cmd1;
                        break;

                    case 0x0014:
#ifdef WRITE_LOG
                        PRINT_RDP_MNEMONIC("+x = ");
#endif
                        rdp_reg.clip.px = rdp_reg.cmd1;
                        break;

                    case 0x001c:
#ifdef WRITE_LOG
                        PRINT_RDP_MNEMONIC("+y = ");
#endif
                        rdp_reg.clip.py = rdp_reg.cmd1;
                        break;

                    default:
#ifdef WRITE_LOG
                        PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD CLIP - wrong offset");
#endif
                        ;

                } /* switch((rdp_reg.cmd0 >> 8) & 0xffff) */
                
#ifdef WRITE_LOG
                PRINT_RDP_MNEMONIC("%d\n", (_s32)(_s16)rdp_reg.cmd1);
                PRINT_RDP_WARNING("ignored");
#endif
                break;

            case 0x06:
#ifdef WRITE_LOG
                PRINT_RDP_INFO("MOVEWORD SEGMENT: ");
                PRINT_RDP_MNEMONIC("$%08lx -> seg#%d\n", rdp_reg.cmd1, (rdp_reg.cmd0 >> 10) & 0xf);
#endif
                rdp_reg.segment[(rdp_reg.cmd0 >> 10) & 0xf] = rdp_reg.cmd1;
                break;

            case 0x08:
#ifdef WRITE_LOG
                PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD FOG");
#endif
//FIX
//                
                break;

            case 0x0a:
                i = (rdp_reg.cmd0 & 0x0000e000) >> 13;

                if(rdp_reg.cmd0 & 0x00000400)
                {
#ifdef WRITE_LOG
                        PRINT_RDP_INFO("MOVEWORD LIGHTCOL ");
                        printf("MOVEWORD LIGHTCOL ");
#endif
                        rdp_reg.light[i].r         = ((float)((rdp_reg.cmd1 >> 24) & 0xff))/255.0f;
                        rdp_reg.light[i].g         = ((float)((rdp_reg.cmd1 >> 16) & 0xff))/255.0f;
                        rdp_reg.light[i].b         = ((float)((rdp_reg.cmd1 >>  8) & 0xff))/255.0f;
                        rdp_reg.light[i].a         = 1.0f;

                }
                else
                {
#ifdef WRITE_LOG
                        PRINT_RDP_INFO("MOVEWORD LIGHTCOL (copy) ");
                        printf("MOVEWORD LIGHTCOL (copy) ");
#endif
                        rdp_reg.light[i].r_copy    = ((float)((rdp_reg.cmd1 >> 24) & 0xff))/255.0f;
                        rdp_reg.light[i].g_copy    = ((float)((rdp_reg.cmd1 >> 16) & 0xff))/255.0f;
                        rdp_reg.light[i].b_copy    = ((float)((rdp_reg.cmd1 >>  8) & 0xff))/255.0f;
                        rdp_reg.light[i].a_copy    = 1.0f;
                }

#ifdef WRITE_LOG
                PRINT_RDP_MNEMONIC("%d: rgb?=$%08lx\n", i, rdp_reg.cmd1);
                PRINT_RDP_MNEMONIC(
                        "        rgba=%04.2f,%04.2f,%04.2f,%04.2f\n",
                        ((float)((rdp_reg.cmd1 >> 24) & 0xff))/255.0f,
                        ((float)((rdp_reg.cmd1 >> 16) & 0xff))/255.0f,
                        ((float)((rdp_reg.cmd1 >>  8) & 0xff))/255.0f,
                        1.0f
                        );
                printf("%d: rgb?=$%08lx\n", i, rdp_reg.cmd1);
                printf(
                        "        rgba=%04.2f,%04.2f,%04.2f,%04.2f\n",
                        ((float)((rdp_reg.cmd1 >> 24) & 0xff))/255.0f,
                        ((float)((rdp_reg.cmd1 >> 16) & 0xff))/255.0f,
                        ((float)((rdp_reg.cmd1 >>  8) & 0xff))/255.0f,
                        1.0f
                        );
#endif
				//calculate_light_vectors();
                break;

            case 0x0c:
#ifdef WRITE_LOG
                PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD POINTS");
#endif                
                break;

            case 0x0e:
#ifdef WRITE_LOG
                PRINT_RDP_INFO("MOVEWORD PERSPNORM: ");
                PRINT_RDP_MNEMONIC("factor: %d ($%lx)\n", rdp_reg.cmd1, rdp_reg.cmd1);
#endif
			/**
            *
            * We don't need this. This is to make multipltiplication for s15.16 values 
            * more precise. We use float values. They are precise enough!
            *
            **/
/*
                perspective_normal = ((float)rdp_reg.cmd1) / 65536.0;
*/
                break;

            default:
#ifdef WRITE_LOG
                PRINT_RDP_NOT_IMPLEMENTED("MOVEWORD ?");
#endif                
					;

        } /* switch(rdp_reg.cmd0 & 0xff) */

} /* static void rsp_uc05_moveword() */



void rsp_uc05_setothermode_l()
{
        static char *ac[] = { "none", "threshold", "?", "diter" };
        static char *zs[] = { "pixel", "prim" };
        static char *a1[] =
                {
                        "        bl_1ma (1)",
                        "        bl_a_mem (1)",
                        "        bl_1 (1)",
                        "        bl_0 (1)"
                };
        static char *b1[] =
                {
                        "        bl_clr_in (1)",
                        "        bl_clr_mem (1)",
                        "        bl_clr_bl (1)",
                        "        bl_clr_fog (1)"
                };
        static char *c1[] =
                {
                        "        bl_a_in (1)",
                        "        bl_a_fog (1)",
                        "        bl_a_shade (1)",
                        "        bl_0 (1)"
                };
        static char *d1[] =
                {
                        "        bl_1ma (1)",
                        "        bl_a_mem (1)",
                        "        bl_1 (1)",
                        "        bl_0 (1)" 
                };
        static char *a2[] =
                {
                        "        bl_1ma (2)",
                        "        bl_a_mem (2)",
                        "        bl_1 (2)",
                        "        bl_0 (2)"
                };
        static char *b2[] =
                {
                        "        bl_clr_in (2)",
                        "        bl_clr_mem (2)",
                        "        bl_clr_bl (2)",
                        "        bl_clr_fog (2)"
                };
        static char *c2[] =
                {
                        "        bl_a_in (2)",
                        "        bl_a_fog (2)",
                        "        bl_a_shade (2)",
                        "        bl_0 (2)"
                };
        static char *d2[] =
                {
                        "        bl_1ma (2)",
                        "        bl_a_mem (2)",
                        "        bl_1 (2)",
                        "        bl_0 (2)" 
                };

        switch((rdp_reg.cmd0 >> 8) & 0xff)
        {
            case 0x00:
                //PRINT_RDP("SETOTHERMODE_L ALPHACOMPARE: ");
                //PRINT_RDP("%s\n", ac[(rdp_reg.cmd1>>0x00) & 0x3]);

                rdp_reg.mode_l &= ~0x00000003;
                rdp_reg.cmd1   &=  0x00000003;
                rdp_reg.mode_l |=  rdp_reg.cmd1;
                break;

            case 0x02:
                //PRINT_RDP("SETOTHERMODE_L ZSRCSEL: ");
                //PRINT_RDP("%s\n", zs[(rdp_reg.cmd1>>0x02) & 0x1]);

                rdp_reg.mode_l &= ~0x00000004;
                rdp_reg.cmd1   &=  0x00000004;
                rdp_reg.mode_l |=  rdp_reg.cmd1;
                break;

            case 0x03:
                //PRINT_RDP("SETOTHERMODE_L RENDERMODE: ");
                /*PRINT_RDP("$%08lx:\n", rdp_reg.cmd1 & 0xfffffff8,
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n"
                        "%s\n",
                        rdp_reg.cmd1 & 0xfffffff8,
                        (rdp_reg.cmd1 & 0x00000008) ? "        anti alias\n" : "",
                        (rdp_reg.cmd1 & 0x00000010) ? "        z_cmp\n" : "",
                        (rdp_reg.cmd1 & 0x00000020) ? "        z_upd\n" : "",
                        (rdp_reg.cmd1 & 0x00000040) ? "        im_rd\n" : "",
                        (rdp_reg.cmd1 & 0x00000080) ? "        clr_on_cvg\n" : "",
                        (rdp_reg.cmd1 & 0x00000100) ? "        cvg_dst_warp\n" : "",
                        (rdp_reg.cmd1 & 0x00000200) ? "        cvg_dst_full\n" : "",
                        (rdp_reg.cmd1 & 0x00000400) ? "        z_inter\n" : "",
                        (rdp_reg.cmd1 & 0x00000800) ? "        z_xlu\n" : "",
                        (rdp_reg.cmd1 & 0x00001000) ? "        cvg_x_alpha\n" : "",
                        (rdp_reg.cmd1 & 0x00002000) ? "        alpha_cvg_sel\n" : "",
                        (rdp_reg.cmd1 & 0x00004000) ? "        force_bl\n" : "",
                        (rdp_reg.cmd1 & 0x00008000) ? "        tex_edge?\n" : "",
                        a2[(rdp_reg.cmd1>>16) & 0x3],
                        a1[(rdp_reg.cmd1>>18) & 0x3],
                        b2[(rdp_reg.cmd1>>20) & 0x3],
                        b1[(rdp_reg.cmd1>>22) & 0x3],
                        c2[(rdp_reg.cmd1>>24) & 0x3],
                        c1[(rdp_reg.cmd1>>26) & 0x3],
                        d2[(rdp_reg.cmd1>>28) & 0x3],
                        d1[(rdp_reg.cmd1>>30) & 0x3]
                        );*/
                rdp_reg.mode_l &= ~0xfffffff8;
                rdp_reg.cmd1   &=  0xfffffff8;
                rdp_reg.mode_l |=  rdp_reg.cmd1;
                break;

            case 0x16:
                //PRINT_RDP("SETOTHERMODE_L BLENDER\n");
				break;

            default:
                //PRINT_RDP("SETOTHERMODE_L ?\n");
				;

        } /* switch((rdp_reg.cmd0 >> 8) & 0xff) */

	LOG_TO_FILE("%08X: %08X %08X CMD UC5_SETOTHERMODE_L \n", ADDR, CMD0, CMD1);
}

void rsp_uc05_setothermode_h()
{
        static char *ad[] = { "pattern", "notpattern", "noise", "disable" };
        static char *rd[] = { "magicsq", "bayer", "noise", "?" };
        static char *ck[] = { "none", "key" };
        static char *tc[] = { "conv", "?", "?", "?", "?", "filtconv", "filt", "?" };
        static char *tf[] = { "point", "?", "bilerp", "average" };
        static char *tt[] = { "none", "?", "rgba16", "ia16" };
        static char *tl[] = { "tile", "lod" };
        static char *td[] = { "clamp", "sharpen", "detail", "?" };
        static char *tp[] = { "none", "persp" };
        static char *ct[] = { "1cycle", "2cycle", "copy", "fill" };
        static char *cd[] = { "disable(hw>1)", "enable(hw>1)", "disable(hw1)", "enable(hw1)" };
        static char *pm[] = { "nprimitive", "1primitive" };

        switch((rdp_reg.cmd0 >> 8) & 0xff)
        {
            case 0x00:
                //PRINT_RDP("SETOTHERMODE_H BLENDMASK - ignored\n");
                break;

            case 0x04:
                //PRINT_RDP("SETOTHERMODE_H ALPHADITHER: ");
                //PRINT_RDP("%s\n", ad[(rdp_reg.cmd1>>0x04) & 0x3]);
                rdp_reg.mode_h &= ~0x00000030;
                rdp_reg.cmd1   &=  0x00000030;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x06:
                //PRINT_RDP("SETOTHERMODE_H RGBDITHER: ");
                //PRINT_RDP("%s\n", rd[(rdp_reg.cmd1>>0x06) & 0x3]);
                rdp_reg.mode_h &= ~0x000000c0;
                rdp_reg.cmd1   &=  0x000000c0;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x08:
                //PRINT_RDP("SETOTHERMODE_H COMBINEKEY: ");
                //PRINT_RDP("%s\n", ck[(rdp_reg.cmd1>>0x08) & 0x1]);
                rdp_reg.mode_h &= ~0x00000100;
                rdp_reg.cmd1   &=  0x00000100;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x09:
                //PRINT_RDP("SETOTHERMODE_H TEXTURECONVERT: ");
                //PRINT_RDP("%s\n", tc[(rdp_reg.cmd1>>0x09) & 0x7]);
                rdp_reg.mode_h &= ~0x00000e00;
                rdp_reg.cmd1   &=  0x00000e00;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x0c:
                //PRINT_RDP("SETOTHERMODE_H TEXTUREFILTER: ");
                //PRINT_RDP("%s\n", tf[(rdp_reg.cmd1>>0x0c) & 0x3]);
                rdp_reg.mode_h &= ~0x00003000;
                rdp_reg.cmd1   &=  0x00003000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x0e:
                //PRINT_RDP("SETOTHERMODE_H TEXTURELUT: ");
                //PRINT_RDP("%s\n", tt[(rdp_reg.cmd1>>0x0e) & 0x3]);
                rdp_reg.mode_h &= ~0x0000c000;
                rdp_reg.cmd1   &=  0x0000c000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x10:
                //PRINT_RDP("SETOTHERMODE_H TEXTURELOD: ");
                //PRINT_RDP("%s\n", tl[(rdp_reg.cmd1>>0x10) & 0x1]);
                rdp_reg.mode_h &= ~0x00010000;
                rdp_reg.cmd1   &=  0x00010000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x11:
                //PRINT_RDP("SETOTHERMODE_H TEXTUREDETAIL: ");
                //PRINT_RDP("%s\n", td[(rdp_reg.cmd1>>0x11) & 0x3]);
                rdp_reg.mode_h &= ~0x00060000;
                rdp_reg.cmd1   &=  0x00060000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x13:
                //PRINT_RDP("SETOTHERMODE_H TEXTUREPERSP: ");
                //PRINT_RDP("%s\n", tp[(rdp_reg.cmd1>>0x13) & 0x1]);
                rdp_reg.mode_h &= ~0x00080000;
                rdp_reg.cmd1   &=  0x00080000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x14:
                //PRINT_RDP("SETOTHERMODE_H CYCLETYPE: ");
                //PRINT_RDP("%s\n", ct[(rdp_reg.cmd1>>0x14) & 0x3]);
                rdp_reg.mode_h &= ~0x00300000;
                rdp_reg.cmd1   &=  0x00300000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x16:
                //PRINT_RDP("SETOTHERMODE_H COLORDITHER: ");
                //PRINT_RDP("%s\n", cd[(rdp_reg.cmd1>>0x16) & 0x1]);
                rdp_reg.mode_h &= ~0x00400000;
                rdp_reg.cmd1   &=  0x00400000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            case 0x17:
                //PRINT_RDP("SETOTHERMODE_H PIPELINEMODE: ");
                //PRINT_RDP("%s\n", pm[(rdp_reg.cmd1>>0x17) & 0x1]);
                rdp_reg.mode_h &= ~0x00800000;
                rdp_reg.cmd1   &=  0x00800000;
                rdp_reg.mode_h |=  rdp_reg.cmd1;
                break;

            default:
                //PRINT_RDP("SETOTHERMODE_H\n");
				;

        } /* switch((rdp_reg.cmd0 >> 8) & 0xff) */
	LOG_TO_FILE("%08X: %08X %08X CMD UC5_SETOTHERMODE_H \n", ADDR, CMD0, CMD1);

}












void rsp_uc05_movemem()
{

        _u32 a;
        int   i;

        switch((rdp_reg.cmd0 >> 16) & 0xff)
        {
            case 0x80:
                /* we do '>> 1' here because we just need _s16's */
                a = segoffset2addr(rdp_reg.cmd1) >> 1;

                rdp_reg.vp[0] = ((float)((_s16 *)pRDRAM)[(a+0)^1]) / 4.0f;
                rdp_reg.vp[1] = ((float)((_s16 *)pRDRAM)[(a+1)^1]) / 4.0f;
                rdp_reg.vp[2] = ((float)((_s16 *)pRDRAM)[(a+2)^1]) / 4.0f;
                rdp_reg.vp[3] = ((float)((_s16 *)pRDRAM)[(a+3)^1]) / 4.0f;
                rdp_reg.vp[4] = ((float)((_s16 *)pRDRAM)[(a+4)^1]) / 4.0f;
                rdp_reg.vp[5] = ((float)((_s16 *)pRDRAM)[(a+5)^1]) / 4.0f;
                rdp_reg.vp[6] = ((float)((_s16 *)pRDRAM)[(a+6)^1]) / 4.0f;
                rdp_reg.vp[7] = ((float)((_s16 *)pRDRAM)[(a+7)^1]) / 4.0f;
#ifdef WRITE_LOG
                PRINT_RDP_INFO("MOVEMEM VIEWPORT: ");
                PRINT_RDP_MNEMONIC("addr=$%08lx (seg#%ld, offset=$%lx)\n",
                        a<<1,
                        (rdp_reg.cmd1 >> 24) & 0x0f,
                        rdp_reg.cmd1 & 0x00ffffff );
                PRINT_RDP_MNEMONIC(
                        "        scale: % 7.2f % 7.2f % 7.2f % 7.2f\n" 
                        "        trans: % 7.2f % 7.2f % 7.2f % 7.2f\n",
                        rdp_reg.vp[0],
                        rdp_reg.vp[1],
                        rdp_reg.vp[2],
                        rdp_reg.vp[3],
                        rdp_reg.vp[4],
                        rdp_reg.vp[5],
                        rdp_reg.vp[6],
                        rdp_reg.vp[7] );
#endif
                Render_viewport();
                break;

            case 0x82:
                a = segoffset2addr(rdp_reg.cmd1);

                rdp_reg.lookat_y.r         = ((float)((_u8 *)pRDRAM)[(a+ 0)^3])/255.0f;
                rdp_reg.lookat_y.g         = ((float)((_u8 *)pRDRAM)[(a+ 1)^3])/255.0f;
                rdp_reg.lookat_y.b         = ((float)((_u8 *)pRDRAM)[(a+ 2)^3])/255.0f;
                rdp_reg.lookat_y.a         = 1.0f;
                rdp_reg.lookat_y.r_copy    = ((float)((_u8 *)pRDRAM)[(a+ 4)^3])/255.0f;
                rdp_reg.lookat_y.g_copy    = ((float)((_u8 *)pRDRAM)[(a+ 5)^3])/255.0f;
                rdp_reg.lookat_y.b_copy    = ((float)((_u8 *)pRDRAM)[(a+ 6)^3])/255.0f;
                rdp_reg.lookat_y.a_copy    = 1.0f;
                rdp_reg.lookat_y.x         = ((float)((_u8 *)pRDRAM)[(a+ 8)^3])/255.0f;
                rdp_reg.lookat_y.y         = ((float)((_u8 *)pRDRAM)[(a+ 9)^3])/255.0f;
                rdp_reg.lookat_y.z         = ((float)((_u8 *)pRDRAM)[(a+10)^3])/255.0f;
                rdp_reg.lookat_y.w         = 1.0f;

#ifdef WRITE_LOG
                PRINT_RDP_INFO("MOVEMEM LOOKATY");
                PRINT_RDP_MNEMONIC("addr=$%08lx (seg#%d, offset=$%lx)\n",
                        a,
                        rdp_reg.cmd1 >> 24,
                        rdp_reg.cmd1 & 0x00ffffff );
                PRINT_RDP_MNEMONIC(
                        "        rgba=%04.2f,%04.2f,%04.2f,%04.2f xyzw=%04.2f,%04.2f,%04.2f,%04.2f\n",
                        rdp_reg.lookat_y.r,
                        rdp_reg.lookat_y.g,
                        rdp_reg.lookat_y.b,
                        rdp_reg.lookat_y.a,
                        rdp_reg.lookat_y.x,
                        rdp_reg.lookat_y.y,
                        rdp_reg.lookat_y.z,
                        rdp_reg.lookat_y.w
                        );
#endif
                Render_lookat_y();
                break;

            case 0x84:
                a = segoffset2addr(rdp_reg.cmd1);

                rdp_reg.lookat_x.r         = ((float)((_u8 *)pRDRAM)[(a+ 0)^3])/255.0f;
                rdp_reg.lookat_x.g         = ((float)((_u8 *)pRDRAM)[(a+ 1)^3])/255.0f;
                rdp_reg.lookat_x.b         = ((float)((_u8 *)pRDRAM)[(a+ 2)^3])/255.0f;
                rdp_reg.lookat_x.a         = 1.0f;
                rdp_reg.lookat_x.r_copy    = ((float)((_u8 *)pRDRAM)[(a+ 4)^3])/255.0f;
                rdp_reg.lookat_x.g_copy    = ((float)((_u8 *)pRDRAM)[(a+ 5)^3])/255.0f;
                rdp_reg.lookat_x.b_copy    = ((float)((_u8 *)pRDRAM)[(a+ 6)^3])/255.0f;
                rdp_reg.lookat_x.a_copy    = 1.0f;
                rdp_reg.lookat_x.x         = ((float)((_s8 *)pRDRAM)[(a+ 8)^3])/128.0f;
                rdp_reg.lookat_x.y         = ((float)((_s8 *)pRDRAM)[(a+ 9)^3])/128.0f;
                rdp_reg.lookat_x.z         = ((float)((_s8 *)pRDRAM)[(a+10)^3])/128.0f;
                rdp_reg.lookat_x.w         = 1.0f;

#ifdef WRITE_LOG
                PRINT_RDP_INFO("MOVEMEM LOOKATX");
                PRINT_RDP_MNEMONIC("addr=$%08lx (seg#%d, offset=$%lx)\n",
                        a,
                        rdp_reg.cmd1 >> 24,
                        rdp_reg.cmd1 & 0x00ffffff );
                PRINT_RDP_MNEMONIC(
                        "        rgba=%04.2f,%04.2f,%04.2f,%04.2f xyzw=%04.2f,%04.2f,%04.2f,%04.2f\n",
                        rdp_reg.lookat_x.r,
                        rdp_reg.lookat_x.g,
                        rdp_reg.lookat_x.b,
                        rdp_reg.lookat_x.a,
                        rdp_reg.lookat_x.x,
                        rdp_reg.lookat_x.y,
                        rdp_reg.lookat_x.z,
                        rdp_reg.lookat_x.w
                        );
#endif
                Render_lookat_x();
                break;

            case 0x86:
            case 0x88:
            case 0x8a:
            case 0x8c:
            case 0x8e:
            case 0x90:
            case 0x92:
            case 0x94:
                i = (((rdp_reg.cmd0 >> 16) & 0xff) - 0x86) >> 1;
                a = segoffset2addr(rdp_reg.cmd1);

                rdp_reg.light[i].r         = ((float)((_u8 *)pRDRAM)[(a+ 0)^3])/255.0f;
                rdp_reg.light[i].g         = ((float)((_u8 *)pRDRAM)[(a+ 1)^3])/255.0f;
                rdp_reg.light[i].b         = ((float)((_u8 *)pRDRAM)[(a+ 2)^3])/255.0f;
                rdp_reg.light[i].a         = 1.0f;
                rdp_reg.light[i].r_copy    = ((float)((_u8 *)pRDRAM)[(a+ 4)^3])/255.0f;
                rdp_reg.light[i].g_copy    = ((float)((_u8 *)pRDRAM)[(a+ 5)^3])/255.0f;
                rdp_reg.light[i].b_copy    = ((float)((_u8 *)pRDRAM)[(a+ 6)^3])/255.0f;
                rdp_reg.light[i].a_copy    = 1.0f;
                rdp_reg.light[i].x         = ((float)((_s8 *)pRDRAM)[(a+ 8)^3])/127.0f;
                rdp_reg.light[i].y         = ((float)((_s8 *)pRDRAM)[(a+ 9)^3])/127.0f;
                rdp_reg.light[i].z         = ((float)((_s8 *)pRDRAM)[(a+10)^3])/127.0f;
                rdp_reg.light[i].w         = 1.0f;

#ifdef WRITE_LOG
                PRINT_RDP_INFO("MOVEMEM LIGHT ");
                PRINT_RDP_MNEMONIC("%d addr=$%08lx (seg#%ld, offset=$%lx)\n",
                        i,
                        a,
                        rdp_reg.cmd1 >> 24,
                        rdp_reg.cmd1 & 0x00ffffff );
                PRINT_RDP_MNEMONIC(
                        "        rgba=%04.2f,%04.2f,%04.2f,%04.2f xyzw=%04.2f,%04.2f,%04.2f,%04.2f\n",
                        rdp_reg.light[i].r,
                        rdp_reg.light[i].g,
                        rdp_reg.light[i].b,
                        rdp_reg.light[i].a,
                        rdp_reg.light[i].x,
                        rdp_reg.light[i].y,
                        rdp_reg.light[i].z,
                        rdp_reg.light[i].w
                        );
#endif
                printf("MOVEMEM LIGHT ");
                printf("%d addr=$%08lx (seg#%ld, offset=$%lx)\n",
                        i,
                        a,
                        rdp_reg.cmd1 >> 24,
                        rdp_reg.cmd1 & 0x00ffffff );
                printf(
                        "        rgba=%04.2f,%04.2f,%04.2f,%04.2f xyzw=%04.2f,%04.2f,%04.2f,%04.2f\n",
                        rdp_reg.light[i].r,
                        rdp_reg.light[i].g,
                        rdp_reg.light[i].b,
                        rdp_reg.light[i].a,
                        rdp_reg.light[i].x,
                        rdp_reg.light[i].y,
                        rdp_reg.light[i].z,
                        rdp_reg.light[i].w
                        );
                Render_light(i);
                break;

            case 0x98:
#ifdef WRITE_LOG
                PRINT_RDP_NOT_IMPLEMENTED("MOVEMEM MATRIX 0");
#endif                
                break;

            case 0x9a:
#ifdef WRITE_LOG
                PRINT_RDP_NOT_IMPLEMENTED("MOVEMEM MATRIX 1");
#endif                
                break;

            case 0x9c:
#ifdef WRITE_LOG
                PRINT_RDP_NOT_IMPLEMENTED("MOVEMEM MATRIX 2");
#endif                
                break;

            case 0x9e:
#ifdef WRITE_LOG
                PRINT_RDP_NOT_IMPLEMENTED("MOVEMEM MATRIX 3");
#endif                
                break;

            default:
#ifdef WRITE_LOG
                PRINT_RDP_NOT_IMPLEMENTED("MOVEMEM ?");
#endif                
				;

        } /* switch((rdp_reg.cmd0 >> 8) & 0xffff) */

#ifdef WRITE_LOG
        PRINT_RDP_NOT_IMPLEMENTED("MOVEMEM");
#endif        


} /* static void rsp_uc05_movemem() */

void rsp_uc05_cleargeometrymode()
{
#ifdef WRITE_LOG
        PRINT_RDP_INFO("CLEARGEOMETRYMODE ");
        PRINT_RDP_MNEMONIC(
                "-$%08lx\n"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s"
                "%s",
                rdp_reg.cmd1,
                (rdp_reg.cmd1 & 0x00000001) ? "        zbuffer\n" : "",
                (rdp_reg.cmd1 & 0x00000002) ? "        texture\n" : "",
                (rdp_reg.cmd1 & 0x00000004) ? "        shade\n" : "",
                (rdp_reg.cmd1 & 0x00000200) ? "        shade smooth\n" : "",
                (rdp_reg.cmd1 & 0x00001000) ? "        cull front\n" : "",
                (rdp_reg.cmd1 & 0x00002000) ? "        cull back\n" : "",
                (rdp_reg.cmd1 & 0x00010000) ? "        fog\n" : "",
                (rdp_reg.cmd1 & 0x00020000) ? "        lightning\n" : "",
                (rdp_reg.cmd1 & 0x00040000) ? "        texture gen\n" : "",
                (rdp_reg.cmd1 & 0x00080000) ? "        texture gen lin\n" : "",
                (rdp_reg.cmd1 & 0x00100000) ? "        lod\n" : ""
                );
#endif
        rdp_reg.geometrymode &= ~rdp_reg.cmd1;

/*        if(rdp_reg.cmd1 & 0x00000002)
                rdp_reg.geometrymode_textures = 0;
*/
		if ((rdp_reg.cmd1 & 0x00020000) != 0)
				rdp_reg.useLights = 0;

        if(rdp_reg.cmd1 & 0x00000001)
                Render_geometry_zbuffer(0);


//		if (rdp_reg.geometrymode & 0x00003000) Render_geometry_cullfrontback(0);
        switch(rdp_reg.geometrymode & 0x00003000)
        {
            case 0x1000:
                Render_geometry_cullfront(0);
                break;
            case 0x2000:
                Render_geometry_cullback(0);
                break;
            case 0x3000:
                Render_geometry_cullfrontback(0);
                break;
            default:
//                Render_geometry_cullfrontback(0);
				break;
        } //** switch(rdp_reg.geometrymode & 0x00003000) 
		
} /* static void rsp_uc00_cleargeometrymode() */




//////////////////////////////////////////////////////////////////////////////
// Unimplemented functions
//////////////////////////////////////////////////////////////////////////////


void rsp_uc05_rdphalf_cont()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC5_RDPHALF_CONT NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc05_rdphalf_2()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC5_RDPHALF_2 NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc05_line3d()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC5_LINE3d NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc05_sprite2d()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC5_SPRITE2D NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc05_culldl()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC5_CULLDL NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc05_tri1()
{
	LOG_TO_FILE("%08X: %08X %08X CMD UC5_TRI1 NI\n", ADDR, CMD0, CMD1);
}

void rsp_uc05_rdphalf_1()
{
		LOG_TO_FILE("%08X: %08X %08X CMD UC5_RDPHALF_1 NI\n", ADDR, CMD0, CMD1);
}
