#ifdef __WIN32__
#include <windows.h>
#else
#include "winlnxdefs.h"
#endif
#include <GL/gl.h>
#include <GL/glu.h>

#include "rdp_registers.h"
#include "rdp_gl.h"

#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "3dmath.h"
#include "Texture.h"
//** Globals
extern char output[1024];

#define kListEndLights      1
#define kListBeginLights	9
//#define OPENGL_LIGHTS

//** for Lighting
BOOL refresh_lights = TRUE;
BOOL refresh_matrix = TRUE;
MATRIX4 view_matrix, invers;
VECTOR Light_Vector[8];




//new june 16, need this for some combine modes.
/******************************************************************************\
*                                                                              *
*   Lighting										  						   *
*                                                                              *
\******************************************************************************/

void calculate_light_vectors()
{
	unsigned int lidx;

#ifdef OPENGL_LIGHTS

	GLint lightnum;
	GLfloat tLight[4];
	GLfloat tcolor[4]={1.0,1.0,1.0,1.0};
	GLfloat tcolorz[4]={0.0,0.0,0.0,0.0};

    //glMatrixMode(GL_PROJECTION);
	//glPushMatrix();
    //glLoadIdentity();
    glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
    glLoadIdentity();
/*	tcolor[0] /= (rdp_reg.lights + 1);
	tcolor[1] /= (rdp_reg.lights + 1);
	tcolor[2] /= (rdp_reg.lights + 1);
*/
	glMaterialfv(GL_FRONT,GL_DIFFUSE,tcolor);
	glMaterialfv(GL_FRONT,GL_AMBIENT,tcolor);

	for (lidx = 0; lidx < 8; lidx++)
	{
				glDisable(GL_LIGHT0 + lidx);
	}

//	glCallList(kListBeginLights);

	for (lidx = 0; lidx < rdp_reg.lights; lidx++)
	{
		lightnum = GL_LIGHT0 + lidx;

		glEnable(lightnum);

		tLight[0] = rdp_reg.light[lidx].x;
		tLight[1] = rdp_reg.light[lidx].y;
		tLight[2] = rdp_reg.light[lidx].z;
		tLight[3] = 0;

		tcolor[0] = rdp_reg.light[lidx].r;
		tcolor[1] = rdp_reg.light[lidx].g;
		tcolor[2] = rdp_reg.light[lidx].b;
		tcolor[3] = rdp_reg.light[lidx].a;

		glLightfv(lightnum,GL_SPECULAR,tcolorz);
		glLightfv(lightnum,GL_DIFFUSE,tcolor);
		glLightfv(lightnum,GL_POSITION,tLight);

	}

	lidx = rdp_reg.lights;

	tcolor[0] = rdp_reg.light[lidx].r;
	tcolor[1] = rdp_reg.light[lidx].g;
	tcolor[2] = rdp_reg.light[lidx].b;
	tcolor[3] = rdp_reg.light[lidx].a;

	glEnable(GL_LIGHT0 + lidx);

	glLightfv(GL_LIGHT0 + lidx,GL_AMBIENT,tcolor);
	glLightfv(GL_LIGHT0 + lidx,GL_SPECULAR,tcolorz);
	glLightfv(GL_LIGHT0 + lidx,GL_DIFFUSE,tcolorz);

	//glPopAttrib();
	glPopMatrix();
    //glMatrixMode(GL_PROJECTION);
	//glPopMatrix();
#else

	for (lidx = 0; lidx < rdp_reg.lights; lidx++)
	{	
		TranformVector( &rdp_reg.light[lidx].x, Light_Vector[lidx], invers );
		NormalizeVector( Light_Vector[lidx] );
	}

#endif
	refresh_lights = FALSE;
}

#define NORMAL_LIGHTING

void math_lighting(t_vtx_tn *vtx, float color[4])
{
//	1. Inverse modelviematrix
//	2. Multiply lightvector invers-matrix
//	3. Normalize new vector
//	4. lightfactor = DotProduct ( vertex, new vector)
//	5. if new lightfactor < 0 ; new lightfactor = 0
//	6. light = light_color * lightfactor

	unsigned int lidx;
// The spot-lights ...
	for (lidx = 0;lidx < rdp_reg.lights; lidx++)
	{
		VECTOR tmp_vec1;
		float light_intensity;

#ifdef NORMAL_LIGHTING
		tmp_vec1[0] = (float)vtx->nx;
		tmp_vec1[1] = (float)vtx->ny;
		tmp_vec1[2] = (float)vtx->nz;
		NormalizeVector(tmp_vec1);
		light_intensity = DotProduct( Light_Vector[lidx], tmp_vec1 );		
#else
		VECTOR tmp1, tmp2;

		tmp_vec1[0] = (float)vtx->nx;
		tmp_vec1[1] = (float)vtx->ny;
		tmp_vec1[2] = (float)vtx->nz;

		TranformVector(tmp_vec1, tmp1, view_matrix);
		//NormalizeVector(tmp1);
		light_intensity = DotProduct( Light_Vector[lidx], tmp1 );
#endif		
		
		if (light_intensity < 0) light_intensity = 0;

						
		color[0] += rdp_reg.light[lidx].r * light_intensity;
		color[1] += rdp_reg.light[lidx].g * light_intensity;
		color[2] += rdp_reg.light[lidx].b * light_intensity;				
//		color[3] += vtx->a / 255.0f;
		color[3] = 1.0f;
	}
// We need ambient-light here ... 				
	color[0] += rdp_reg.light[rdp_reg.lights].r;
	color[1] += rdp_reg.light[rdp_reg.lights].g;
	color[2] += rdp_reg.light[rdp_reg.lights].b;
//	color[3] += vtx->a / 255.0f;
	color[3] = 1.0f;

	return;
}


