/**
 * TrueReality - N64/rdp_registers.h
 * Copyright (C) 1998, 1999 Niki W. Waibel
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Information about me (the author):
 *   Niki W. Waibel, Reichenau 20, 6890 Lustenau, Austria - EUROPE
 *   niki.waibel@gmx.net
**/





/* every 'export' in this file resides in 'rdp.c' */
/* this file could also be named as 'rdp_export.h' */




#ifndef __RDP_REGISTERS_H
#define __RDP_REGISTERS_H

#include "type_sizes.h"

#define DEFAULT						0x00
#define USE_COLOR4_PRIM				0x01
#define USE_COLOR4_VERTEX_PRIM		0x02
#define USE_COLOR3_VERTEX			0x04
#define USE_TEXTURE					0x10
#define USE_ALPHA					0x20
#define USE_FREE					0x40

#define RDPTD_LOAD_NOT_SET			-1
#define RDPTD_LOADBLOCK				1
#define RDPTD_LOADTILE				2

//**  structure vertex
typedef struct
{
	float   x, y, z;
    _u16   flags;
    float   s, t;
    _u8    r, g, b, a;
}
t_vtx;                           

typedef struct
{
	float    x, y, z;
    _u16   flags;
    float    s, t;
    _s8    nx, ny, nz;
	_u8	 a;
}
t_vtx_tn;

typedef struct
{
	float   sn1, cs1;
	float   sn2, cs2;
    float    r, g, b, a;
}
t_lightsw;                           

typedef struct
{
	float r, g, b, a;
	float r_copy, g_copy, b_copy, a_copy;
	float x, y, z, w;
} t_light;

//** first by Jeff
typedef struct
{
	_u8  fmt;			// frame format (3 bits)
	_u8  size;		// bits per pixel (2 bits)
	_u32  width;		// width of frame in pixels (12 bits)
	_u64 addr;		// RDRAM pointer to Image
	_u8 *LoadAddr;
	_u64 vaddr;
} t_ImageInfo;

typedef struct
{
//** SETTILE 
	_u8    format;
	_u8    size;
	_u16   line;
	_u16   tmem;
	_u8    palette;
	_u8     clampt;
	_u8     mirrort;
	_u8    maskt;
	_u8    shiftt;
	_u8     clamps;
	_u8     mirrors;
	_u8    masks;
	_u8    shifts;

	_s32	 Width;
	_s32	 Height;
	
	_u8    Texture_on;
	float	 SScale;
	float	 TScale;

	int		set_by;
	_u32   addr;
//** LOADBLOCK / LOADTILE
	_s16   uls; /* Upper Left Texture X-Coordinate (10.2 bits) */
	_s16   ult; /* Upper Left Texture Y-Coordinate (10.2 bits) */
	_s16   lrs; /* Lower Right Texture X-Coordinate (10.2 bits) */
	_s16   lrt; /* Lower Right Texture Y-Coordinate (10.2 bits) */
	_s16   dxt; /* Increment dxt per scanline */

//**  SETTILESIZE
	float   sts_uls; /* Upper Left Texture X-Coordinate (10.2 bits) */
	float   sts_ult; /* Upper Left Texture Y-Coordinate (10.2 bits) */
	float   sts_lrs; /* Lower Right Texture X-Coordinate (10.2 bits) */
	float   sts_lrt; /* Lower Right Texture Y-Coordinate (10.2 bits) */
	
} t_tile;

typedef struct tile_descriptor
{
    /* SETTILESIZE */
        _s16   s; /* Upper Left Texture X-Coordinate (12 bits) */
        _s16   t; /* Upper Left Texture Y-Coordinate (12 bits) */
        _s16   S; /* Lower Right Texture X-Coordinate (12 bits) */
        _s16   T; /* Lower Right Texture Y-Coordinate (12 bits) */

    /* SETTILE */
        _u8    format;
        _u8    size;
        int     line;
        int     tmem;
        _u8   palette;
        _u8   clampt;
        _u8   mirrort;
        _u8   maskt;
        _u8   shiftt;
        _u8   clamps;
        _u8   mirrors;
        _u8   masks;
        _u8   shifts;
		_u32	Width;
		_u32	Height;
		_u32	flags;

} RDPTileDesc;

typedef struct
{
	_u32    ulx;
	_u32    uly;
	_u32    lrx;
    _u32    lry;
    _u32    interlace_mode;
} t_scissor;

typedef struct 
{
        //** general 

        _u32  cmd0, cmd1;
        _u32  start, stop, curr;

        t_tile  td[8];
		int		tile;
		int		loadtile;

        //** color register 
        _u32  fillcolor;     //** memory interface: 32bit 
        _u32  primcolor;     //** color combiner: rgba 
        _u32  envcolor;      //** color combiner: rgba 
        _u32  fogcolor;      //** blender: rgba 
        _u32  blendcolor;    //** blender: rgba 

        //** This is the frame buffer location to draw into 
        //** Used by rdp_setcolorimage() 
        _u8  colorimg_fmt;          //** Frame Format (3 bits)
        _u8  colorimg_size;         //** Bits per pixel (2 bits) 
        _u16 colorimg_width;        //** width of frame in pixels (12 bits) 
        _u32  colorimg_addr;         //** RDRAM pointer to Image (32 bits) 

        //** This is the frame buffer location to draw into 
        //** Used by rdp_settextureimage() 
		t_ImageInfo TextureImage;
//** FiRES: muesste theoretisch fuer jedes der geladenen Texturen indiv.
		float m_TScale;				
		float m_SScale;
		t_tile *m_CurTile;

        //** This is the location of an 8 bit TLUT 
        //** Used by rdp_loadtlut() 
        _u8  tlut_8_fmt;   //** TLUT Format (3 bits) 
        _u8  tlut_8_size;  //** Bits per pixel (2 bits) 
        _u32  tlut_8_addr;  //** RDRAM pointer to TLUT (32 bits) 

        //** This is the location of an 4 bit TLUT 
        //** Used by rdp_loadtlut() 
        _u8  tlut_4_fmt[16];   //** TLUT Format (3 bits) 
        _u8  tlut_4_size[16];  //** Bits per pixel (2 bits) 
        _u32  tlut_4_addr[16];  //** RDRAM pointer to TLUT (32 bits) 

        t_scissor scissor;


		t_light light[8], lookat_x, lookat_y;


        /**
        *
        * This might be part of some sort of High Level Emulation (HLE).
        * HLE was first hacked out by Epsilon and RealityMan - the authors of UltraHLE.
        *
        **/

        _u32 pc[10];                            /* DL stack is 10 */
        _u32 pc_i;                              /* PC index (current DL depth) */

#define INVALID_TASK    -1
#define GFX_TASK        1
#define AUDIO_TASK      2

        int task;
        int size;   /* length of task */



        struct
        {
                _u32 mipmap_level;
                _u32 on;               /* 1: on 0: off */
                float scale_t;
                float scale_s;
        }
        texture[8];

        _u32 geometrymode;
		_u32 geometrymode_textures;
        _u32 mode_h;
        _u32 mode_l;
        _u32 lights;
        _u32 segment[16];                       /* segment pointer */

        float vp[8];                            /* viewport (scale, translate) */

        /*
        float perspective_normal;
        */

        float mtx_proj[4][4];                   /* projection matrix */

        float mtx_model[10][4][4];              /* 10 modelview matrices */

        t_vtx vtx[256];                         /* 32 vertices */

        struct
        {
                _s32   nx;
                _s32   ny;
                _s32   px;
                _s32   py;
        }
        clip;                                   /* clipping stuff */


        int halt;
		int useLights;
		int graphics_changes;
//		t_tile *m_NexTile;
//		int useT1;
        _u32  cmd2, cmd3;
} t_rdp_reg; /* struct rsp_reg */

extern t_rdp_reg rdp_reg;
extern int PaletteCRC[17];

#endif
