#ifndef __TYPE_SIZES_H
#define __TYPE_SIZES_H
#ifdef __WIN32__
#include <windows.h>
#endif

/*
 *   unsigned types
 *
 */

#ifdef __WIN32__
/* these are (very) often used */
#define _u64      unsigned __int64   /* 64 bit */
#define _u32        unsigned __int32   /* 16 bit */
#define _u16	    unsigned __int16   /* 16 bit */
#define _u8			unsigned __int8    /*  8 bit */

/* these are (very) often used */
#define _s64      __int64    /* 64 bit */
#define _s32       __int32    /* 16 bit */
#define _s16      __int16    /* 16 bit */
#define _s8      __int8	   /*  8 bit */

#else

/* these are (very) often used */
#define _u64      unsigned long long   /* 64 bit */
#define _u32        unsigned long   /* 16 bit */
#define _u16	    unsigned short   /* 16 bit */
#define _u8			unsigned char    /*  8 bit */

/* these are (very) often used */
#define _s64      long long    /* 64 bit */
#define _s32       long    /* 16 bit */
#define _s16      short    /* 16 bit */
#define _s8      char	   /*  8 bit */


#endif

#endif
