#ifndef _INITGL_H_
#define _INITGL_H_


typedef struct 
{
	HWND       hWnd;
	HINSTANCE  hInstance;
	char       *szCmdLine;
	int        Width;
	int        Height;
	int        iCmdShow;

	HDC hDC;
	HGLRC hGLRC;
	HPALETTE hPalette;

} WINDATA_T;


extern WINDATA_T WinData;
extern char szAppName[];


/*****************************************************************************/
/* Copiled Displaylists for speedup                                          */
/*****************************************************************************/
#define kListEnd2D          1
#define kListBeginLights	9
#define kListBegin2D160   160
#define kListBegin2D320   320
#define kListBegin2D640   640
#define kListBegin2D800   800
#define kListBegin2D960   960
#define kListBegin2D1024 1024
#define kListBegin2D1200 1200

BOOL CreateDisplayWindow(void);
extern BOOL WGL_Init (void);
extern void WGL_UnInit (void);

extern void WGL_RedoPalette (void);

extern BOOL WGL_IsPaletteValid (void);
extern BOOL WGL_IsGLRCValid (void);

extern void WGL_InitState(void);
extern BOOL WGL_SwapBuffers(void);

extern void WGL_SetViewport(int x, int y);

#endif
