/**
 * Mupen64 - cop1.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "ops.h"
#include "r4300.h"
#include "macros.h"
#include "exception.h"
#include "../memory/memory.h"

void CFC1()
{  
   if (rfs==31)
     {
	rrt = FCR31;
	sign_extended(rrt);
     }
   if (rfs==0)
     {
	rrt = FCR0;
	sign_extended(rrt);
     }
   PC++;
}

void CTC1()
{
   if (rfs==31)
     {
	FCR31 = rrt & 0xFFFFFFFF;
	/*if ((FCR31 & 0x20000) ||
	    ((FCR31 & 0x10800) == 0x10800) || 
	    ((FCR31 & 0x08400) == 0x08400) ||
	    ((FCR31 & 0x04200) == 0x04200) ||
	    ((FCR31 & 0x02100) == 0x02100) ||
	    ((FCR31 & 0x01080) == 0x01080))
	  {
	     printf("exception CTC1\n");
	     stop=1;
	  }*/
	if ((FCR31 & 0x104)>0)
	  {
	     printf("exception non implmente du FCR31:%x\n",
		    (unsigned int)(FCR31 & 0x104));
	  }
     }
   PC++;
}

void LWC1()
{  
   PC++;
   if (Status & 0x04000000)
     {
	printf("lwc 64 bits\n");
	stop=1;
     }
   else
     {
	unsigned long long int temp;
	address = lslfaddr;
	rdword = &temp;
	read_word_in_memory();
	reg_cop1_fgr_32[lslfft] = *rdword & 0xFFFFFFFF;
     }
}

void LDC1()
{
   PC++;
   if (Status & 0x04000000)
     {
	printf("ldc1 64 bits\n");
	stop=1;
     }
   else
     {
	unsigned long long int temp;
	address = lslfaddr;
	rdword = &temp;
	read_dword_in_memory();
	reg_cop1_fgr_32[lslfft] = *rdword & 0xFFFFFFFF;
	reg_cop1_fgr_32[lslfft+1] = (*rdword >> 32) & 0xFFFFFFFF;
     }
}

void SDC1()
{
   PC++;
   if (Status & 0x04000000)
     {
	printf("ldc1 64 bits\n");
	stop=1;
     }
   else
     {
	address = lslfaddr;
	dword = ((unsigned long long int)(reg_cop1_fgr_32[lslfft+1]) << 32)
	  | reg_cop1_fgr_32[lslfft];
	write_dword_in_memory();
     }
}

void SWC1()
{
   PC++;
   if (Status & 0x04000000)
     {
	printf("swc1 64 bits\n");
	stop=1;
     }
   else
     {
	address = lslfaddr;
	word = reg_cop1_fgr_32[lslfft];
	write_word_in_memory();
     }
}

void MTC1()
{
   if (Status & 0x04000000)
     {
	printf("MTC1 64 bits\n");
	stop=1;
     }
   else
     {
	reg_cop1_fgr_32[rfs] = rrt & 0xFFFFFFFF;
     }
   PC++;
}

void DMTC1()
{
   reg_cop1_fgr_32[rfs] = rrt & 0xFFFFFFFF;
   reg_cop1_fgr_32[rfs+1] = (rrt >> 32);
   PC++;
}

void MFC1()
{
   if (Status & 0x04000000)
     {
	printf("MFC1 64 bits\n");
	stop=1;
     }
   else
     {
	rrt = reg_cop1_fgr_32[rfs];
	sign_extended(rrt);
     }
   PC++;
}
