/**
 * Mupen64 - cop1_d.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include "r4300.h"
#include "ops.h"
#include "macros.h"

void ADD_D()
{
   *reg_cop1_double[cffd] = *reg_cop1_double[cffs] +
     *reg_cop1_double[cfft];
   PC++;
}

void MUL_D()
{
   *reg_cop1_double[cffd] = *reg_cop1_double[cffs] *
     *reg_cop1_double[cfft];
   PC++;
}

void DIV_D()
{
   if (*reg_cop1_double[cfft])
     *reg_cop1_double[cffd] = *reg_cop1_double[cffs] /
     *reg_cop1_double[cfft];
   else
     printf("div_d\n");
   PC++;
}

void SUB_D()
{
   *reg_cop1_double[cffd] = *reg_cop1_double[cffs] -
     *reg_cop1_double[cfft];
   PC++;
}

void NEG_D()
{
   *reg_cop1_double[cffd] = -(*reg_cop1_double[cffs]);
   PC++;
}

void MOV_D()
{
   *reg_cop1_double[cffd] = *reg_cop1_double[cffs];
   PC++;
}

void TRUNC_W_D()
{
   if (Status & 0x04000000)
     {
	printf("TRUNC_W_D 64 bits\n");
	stop=1;
     }
   else
     reg_cop1_fgr_32[cffd] = *reg_cop1_double[cffs];
   PC++;
}

void CVT_S_D()
{
   float f;
   f = *reg_cop1_double[cffs];
   *reg_cop1_simple[cffd] = f;
   PC++;
}

void CVT_W_D()
{
   if (Status & 0x04000000)
     {
	printf("CVT_W_D 64 bits\n");
	stop=1;
     }
   else
     reg_cop1_fgr_32[cffd] = *reg_cop1_double[cffs];
   PC++;
}

void C_LE_D()
{
   if (*reg_cop1_double[cffs] <= *reg_cop1_double[cfft])
     FCR31 |= 0x800000;
   else FCR31 &= ~0x800000;
   PC++;
}

void C_LT_D()
{
   if (*reg_cop1_double[cffs] < *reg_cop1_double[cfft])
     FCR31 |= 0x800000;
   else FCR31 &= ~0x800000;
   PC++;
}

void C_EQ_D()
{
   if (*reg_cop1_double[cffs] == *reg_cop1_double[cfft])
     FCR31 |= 0x800000;
   else FCR31 &= ~0x800000;
   PC++;
}
