/**
 * Mupen64 - gspecial.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include "../recomph.h"
#include "../recomp.h"
#include "assemble.h"
#include "../r4300.h"
#include "../ops.h"

void gendsra32()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rt)+1);
   sar_reg32_imm8(EAX, dst->f.r.sa);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gendsll32()
{
   dst->local_addr = code_length;
   mov_m32_imm32((unsigned long *)dst->f.r.rd, 0);
   mov_eax_memoffs32((unsigned long *)dst->f.r.rt);
   shl_reg32_imm8(EAX, dst->f.r.sa);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void genand()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   and_reg32_m32(EAX, (unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   and_reg32_m32(EAX, (unsigned long *)(dst->f.r.rt)+1);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void genor()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   or_reg32_m32(EAX, (unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   or_reg32_m32(EAX, (unsigned long *)(dst->f.r.rt)+1);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gennor()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   or_reg32_m32(EAX, (unsigned long *)dst->f.r.rt);
   not_reg32(EAX);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   or_reg32_m32(EAX, (unsigned long *)(dst->f.r.rt)+1);
   not_reg32(EAX);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void genxor()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   xor_reg32_m32(EAX, (unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   xor_reg32_m32(EAX, (unsigned long *)(dst->f.r.rt)+1);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void genslt()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   cmp_reg32_m32(EAX, (unsigned long *)(dst->f.r.rt)+1);
   je_rj(0x04);
   jg_rj(0x0F);
   jmp_imm_short(0x23);
   
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   cmp_reg32_m32(EAX, (unsigned long *)dst->f.r.rt);
   jb_rj(0x16);
   
   mov_m32_imm32((unsigned long *)dst->f.r.rd, 0);
   mov_m32_imm32((unsigned long *)(dst->f.r.rd)+1, 0);
   jmp_imm_short(0x14);
   
   mov_m32_imm32((unsigned long *)dst->f.r.rd, 1);
   mov_m32_imm32((unsigned long *)(dst->f.r.rd)+1, 0);
   genupdate_system(0);
}

void gensltu()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   cmp_reg32_m32(EAX, (unsigned long *)(dst->f.r.rt)+1);
   je_rj(0x04);
   ja_rj(0x0F);
   jmp_imm_short(0x23);
   
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   cmp_reg32_m32(EAX, (unsigned long *)dst->f.r.rt);
   jb_rj(0x16);
   
   mov_m32_imm32((unsigned long *)dst->f.r.rd, 0);
   mov_m32_imm32((unsigned long *)(dst->f.r.rd)+1, 0);
   jmp_imm_short(0x14);
   
   mov_m32_imm32((unsigned long *)dst->f.r.rd, 1);
   mov_m32_imm32((unsigned long *)(dst->f.r.rd)+1, 0);
   genupdate_system(0);
}

void genmfhi()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(&hi));
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   mov_eax_memoffs32((unsigned long *)(&hi)+1);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void genmthi()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   mov_memoffs32_eax((unsigned long *)(&hi));
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&hi)+1);
   genupdate_system(0);
}

void genmflo()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)(&lo));
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   mov_eax_memoffs32((unsigned long *)(&lo)+1);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void genmtlo()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   mov_memoffs32_eax((unsigned long *)(&lo));
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   mov_memoffs32_eax((unsigned long *)(&lo)+1);
   genupdate_system(0);
}

void genmult()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rt);
   imul_m32((unsigned long *)dst->f.r.rs);
   mov_memoffs32_eax((unsigned long *)(&lo));
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(&lo)+1);
   mov_m32_reg32((unsigned long *)(&hi), EDX);
   sar_reg32_imm8(EDX, 31);
   mov_m32_reg32((unsigned long *)(&hi)+1, EDX);
   genupdate_system(0);
}

void genmultu()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rt);
   mul_m32((unsigned long *)dst->f.r.rs);
   mov_memoffs32_eax((unsigned long *)(&lo));
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(&lo)+1);
   mov_m32_reg32((unsigned long *)(&hi), EDX);
   sar_reg32_imm8(EDX, 31);
   mov_m32_reg32((unsigned long *)(&hi)+1, EDX);
   genupdate_system(0);
}

void gendiv()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   cdq();
   idiv_m32((unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)(&lo));
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(&lo)+1);
   mov_m32_reg32((unsigned long *)(&hi), EDX);
   sar_reg32_imm8(EDX, 31);
   mov_m32_reg32((unsigned long *)(&hi)+1, EDX);
   genupdate_system(0);
}

void gendivu()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   mov_reg32_imm32(EDX, 0);
   div_m32((unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)(&lo));
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(&lo)+1);
   mov_m32_reg32((unsigned long *)(&hi), EDX);
   sar_reg32_imm8(EDX, 31);
   mov_m32_reg32((unsigned long *)(&hi)+1, EDX);
   genupdate_system(0);
}

void gendmultu()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   mul_m32((unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)(&lo));
   
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   mov_reg32_reg32(EBX, EDX);
   mul_m32((unsigned long *)(dst->f.r.rt)+1);
   add_reg32_reg32(EBX, EAX);
   mov_reg32_reg32(ESI, EDX);
   
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   mul_m32((unsigned long *)dst->f.r.rt);
   add_reg32_reg32(EAX, EBX);
   mov_memoffs32_eax((unsigned long *)(&lo)+1);
   add_reg32_reg32(ESI, EDX);
   
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   mul_m32((unsigned long *)(dst->f.r.rt)+1);
   add_reg32_reg32(EAX, ESI);
   mov_memoffs32_eax((unsigned long *)(&hi));
   mov_m32_reg32((unsigned long *)(&hi)+1, EDX);
   genupdate_system(0);
}

void gendmult()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   mul_m32((unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)(&lo));
   
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   mov_reg32_reg32(EBX, EDX);
   mul_m32((unsigned long *)(dst->f.r.rt)+1);
   add_reg32_reg32(EBX, EAX);
   mov_reg32_reg32(ESI, EDX);
   
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   mul_m32((unsigned long *)dst->f.r.rt);
   add_reg32_reg32(EAX, EBX);
   mov_memoffs32_eax((unsigned long *)(&lo)+1);
   add_reg32_reg32(ESI, EDX);
   
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs)+1);
   mul_m32((unsigned long *)(dst->f.r.rt)+1);
   add_reg32_reg32(EAX, ESI);
   mov_memoffs32_eax((unsigned long *)(&hi));
   mov_m32_reg32((unsigned long *)(&hi)+1, EDX);
   genupdate_system(0);
}

static unsigned long pDDIVU = (unsigned long)(DDIVU);
void genddivu()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pDDIVU));
   genupdate_system(0);
}

static unsigned long pDDIV = (unsigned long)(DDIV);
void genddiv()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   call_m32((unsigned long *)(&pDDIV));
   genupdate_system(0);
}

void genadd()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   add_reg32_m32(EAX, (unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void genaddu()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   add_reg32_m32(EAX, (unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gensubu()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   sub_reg32_m32(EAX, (unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gensub()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rs);
   sub_reg32_m32(EAX, (unsigned long *)dst->f.r.rt);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gensll()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rt);
   shl_reg32_imm8(EAX, dst->f.r.sa);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gensrl()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rt);
   shr_reg32_imm8(EAX, dst->f.r.sa);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gensra()
{
   dst->local_addr = code_length;
   mov_eax_memoffs32((unsigned long *)dst->f.r.rt);
   sar_reg32_imm8(EAX, dst->f.r.sa);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gensllv()
{
   dst->local_addr = code_length;
   mov_reg32_m32(ECX, (unsigned long *)dst->f.r.rs);
   mov_eax_memoffs32((unsigned long *)dst->f.r.rt);
   shl_reg32_cl(EAX);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gensrlv()
{
   dst->local_addr = code_length;
   mov_reg32_m32(ECX, (unsigned long *)dst->f.r.rs);
   mov_eax_memoffs32((unsigned long *)dst->f.r.rt);
   shr_reg32_cl(EAX);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gensrav()
{
   dst->local_addr = code_length;
   mov_reg32_m32(ECX, (unsigned long *)dst->f.r.rs);
   mov_eax_memoffs32((unsigned long *)dst->f.r.rt);
   sar_reg32_cl(EAX);
   mov_memoffs32_eax((unsigned long *)dst->f.r.rd);
   sar_reg32_imm8(EAX, 31);
   mov_memoffs32_eax((unsigned long *)(dst->f.r.rd)+1);
   genupdate_system(0);
}

void gendsra()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(DSRA));
   call_reg32(EAX);
   genupdate_system(0);
}

void gendsll()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(DSLL));
   call_reg32(EAX);
   genupdate_system(0);
}

void gendsrav()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(DSRAV));
   call_reg32(EAX);
   genupdate_system(0);
}

void gendsrlv()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(DSRLV));
   call_reg32(EAX);
   genupdate_system(0);
}

void gendsllv()
{
   dst->local_addr = code_length;
   mov_m32_imm32((void *)(&PC), (unsigned long)(dst));
   mov_reg32_imm32(EAX, (unsigned long)(DSLLV));
   call_reg32(EAX);
   genupdate_system(0);
}

void cjr()
{
   jump_to(local_rs);
}

static unsigned long taille_precomp_instr;
//static unsigned long pupdate_system = (unsigned long)(update_system);
static unsigned long pcjr = (unsigned long)(cjr);
static unsigned long pjump_code = (unsigned long)(jump_code);
void genjr()
{   
   unsigned long diff = (unsigned long)(&dst->local_addr) - (unsigned long)(dst);
   taille_precomp_instr = sizeof(precomp_instr);
   dst->local_addr = code_length;
   recomp_jump = 0;
   
   mov_eax_memoffs32((unsigned long *)(dst->f.i.rs));
   mov_memoffs32_eax((unsigned long *)(&local_rs));
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(0);
   mov_eax_memoffs32((unsigned long *)(&local_rs));
   mov_memoffs32_eax((void *)(&delay_slot));
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   mov_eax_memoffs32((unsigned long *)(&local_rs));
   cmp_reg32_m32(EAX, (unsigned long *)(&(dst_block->start)));
   jl_rj(8);
   cmp_reg32_m32(EAX, (unsigned long *)(&(dst_block->end)));
   jl_rj(12);
   
   call_m32((unsigned long *)(&pcjr));
   jmp_m32((unsigned long *)(&pjump_code));
   
   sub_eax_imm32(dst_block->start);
   shr_reg32_imm8(EAX, 2);
   mul_m32((unsigned long *)(&taille_precomp_instr));
   mov_reg32_preg32pimm32(EAX, EAX, (unsigned long)(dst_block->block)+diff);
   add_reg32_m32(EAX, (unsigned long *)(&dst_block->code));
   
   jmp_reg32(EAX);
}

void genjalr()
{
   unsigned long diff = (unsigned long)(&dst->local_addr) - (unsigned long)(dst);
   taille_precomp_instr = sizeof(precomp_instr);
   dst->local_addr = code_length;
   recomp_jump = 0;
   
   mov_eax_memoffs32((unsigned long *)(dst->f.r.rs));
   mov_memoffs32_eax((unsigned long *)(&local_rs));
   
   mov_m32_imm32((void *)(&delay_slot), 1);
   genupdate_system(0);
   mov_eax_memoffs32((unsigned long *)(&local_rs));
   mov_memoffs32_eax((void *)(&delay_slot));
   recompile_opcode();
   mov_m32_imm32((void *)(&delay_slot), 0);
   
   mov_m32_imm32((unsigned long *)((dst-1)->f.r.rd), dst->addr + 4);
   if (((dst->addr + 4) & 0x80000000))
     mov_m32_imm32((unsigned long *)((dst-1)->f.r.rd)+1, 0xFFFFFFFF);
   else
     mov_m32_imm32((unsigned long *)((dst-1)->f.r.rd)+1, 0);
   
   mov_eax_memoffs32((unsigned long *)(&local_rs));
   cmp_reg32_m32(EAX, (unsigned long *)(&dst_block->start));
   jl_rj(8);
   cmp_reg32_m32(EAX, (unsigned long *)(&dst_block->end));
   jl_rj(12);
   
   call_m32((unsigned long *)(&pcjr));
   jmp_m32((unsigned long *)(&pjump_code));
   
   sub_eax_imm32(dst_block->start);
   shr_reg32_imm8(EAX, 2);
   mul_m32((unsigned long *)(&taille_precomp_instr));
   mov_reg32_preg32pimm32(EAX, EAX, (unsigned long)(dst_block->block)+diff);
   add_reg32_m32(EAX, (unsigned long *)(&dst_block->code));
   
   jmp_reg32(EAX);
}
