/**
 * Mupen64 - sound.c
 * Copyright (C) 2002 Hacktarux
 *
 * Mupen64 homepage: http://mupen64.emulation64.com
 * email address: hacktarux@yahoo.fr
 * 
 * If you want to contribute to the project please contact
 * me first (maybe someone is already making what you are
 * planning to do).
 *
 *
 * This program is free software; you can redistribute it and/
 * or modify it under the terms of the GNU General Public Li-
 * cence as published by the Free Software Foundation; either
 * version 2 of the Licence, or any later version.
 *
 * This program is distributed in the hope that it will be use-
 * ful, but WITHOUT ANY WARRANTY; without even the implied war-
 * ranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public Licence for more details.
 *
 * You should have received a copy of the GNU General Public
 * Licence along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
**/

#include <stdio.h>
#include "../../r4300/r4300.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <linux/soundcard.h>
#include <sys/ioctl.h>
#include "../../memory/memory.h"
#include "../sound.h"
#include <pthread.h>
#include "../../r4300/interupt.h"

int dsp, longueur = 0;
int old_depth = 0, old_rate = 0;

int sound_init()
{
   int i;
   dsp = open("/dev/dsp", O_RDWR);
   if (dsp == -1) return 1;
   if (ioctl(dsp, SNDCTL_DSP_RESET) == -1) return 1;
   i=1;
   if (ioctl(dsp, SNDCTL_DSP_STEREO, &i) == -1)
     printf("errerur d'initialisation stro\n");
   return 0;
}

void free_sound()
{
   ioctl(dsp, SNDCTL_DSP_SYNC);
   close(dsp);
}

#define VI_NTSC_CLOCK 48681812
#define VI_PAL_CLOCK 49656530

pthread_t my_thread;

void *sound_thread(void *p)
{
   longueur = ai_register.ai_len;
   ai_register.ai_len /=2;
   ai_register.ai_status |= 0x40000000;
   write(dsp,
	 (char *)(&rdram[(ai_register.ai_dram_addr & 0xFFFFF8)/4]),
	 longueur);
   while ((ai_register.ai_status & 0x80000001)>0)
     {
	ai_register.ai_status &= ~0x80000001;
	/*MI_register.mi_intr_reg |= 0x04;
	gen_mi();*/
	
	longueur = ai_register.ai_len;
	ai_register.ai_len /=2;
	write(dsp,
	      (char *)(&rdram[(ai_register.ai_dram_addr & 0xFFFFF8)/4]),
	      longueur);
     }
   ai_register.ai_status &= ~0x40000000;
   ai_register.ai_len = 0;
   return 0;
}

void send_sound()
{
   int rate, depth, i;
   rate = VI_NTSC_CLOCK/(ai_register.ai_dacrate+1);
   depth = ai_register.ai_bitrate+1;
   
   if (rate != old_rate)
     {
	if (ioctl(dsp, SNDCTL_DSP_SPEED, &rate) == -1)
	  printf("erreur d'intialisation frequence\n");
	old_rate = rate;
     }
   
   switch(depth)
     {
      case 16:
	if (depth != old_depth)
	  {
	     i = AFMT_S16_LE;
	     if (ioctl(dsp, SNDCTL_DSP_SAMPLESIZE, &i) == -1)
	       printf("erreur d'initialisation taille sample\n");
	     old_depth = depth;
	  }
	break;
      case 8:
	printf("son 8 bits\n");
	stop=1;
	break;
     }
   
   if (ai_register.ai_status == 0)
     pthread_create(&my_thread, NULL, sound_thread, NULL);
   else
     ai_register.ai_status |= 0x80000001;
}
