
#include <Roster.h>
#include <Application.h>
#include <Window.h>
#include <DirectWindow.h>
#include <Alert.h>
#include <View.h>
#include <Box.h>
#include <Dragger.h>
#include <TextView.h>
#include <Menu.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include <String.h>
#include <Entry.h>
#include <Path.h>
#include <FilePanel.h>
#include <Screen.h>
#include <FindDirectory.h>
#include <Messenger.h>

#include "SoundBeOS.h"
#include "Event.hxx"
#include "Console.hxx"

class STellaWindow;
class STellaFilePanel;
class STellaGameInfoView;
class MFocusView;

// ********************************************************************

struct game_info
{
	BString name;			// "Cartridge.Name"
	BString manufacturer;	// "Cartridge.Manufacturer"
	BString rarity;			// "Cartridge.Rarity"
	BString note;			// "Cartridge.Note"
	BString format;			// "Display.Format"
	int		width;			// "Display.Width"
	int		height;			// "Display.Height"
};


// ********************************************************************


class STellaApplication : public BApplication
{
public:
			STellaApplication();
	virtual ~STellaApplication();
	virtual void AboutRequested(void);

	virtual void ArgvReceived(int32 argc, char **argv);
	virtual void RefsReceived(BMessage *msg);
	virtual void ReadyToRun(void);

private:
	void open_stella_window(void);

private:
	STellaWindow *fStellaWindow;

public:
	static const char *fApplicationSignature;
};


// ********************************************************************


_EXPORT class STellaView : public BView, public BLocker
{
public:
	enum controller_t
	{ // The value is the index in the menu
		JOYSTICK=0,
		BOOSTER_GRIP=1,
		DRIVING=2,
		PADDLE=3,
		KEYBOARD=4,
		LIGHTGUN=5,
		MINDLINK=6
	};

public:
			STellaView(BRect frame);
			STellaView(BMessage *archive);
	virtual ~STellaView();
	
	virtual void MessageReceived(BMessage *m);
	virtual void MouseMoved(BPoint point, uint32 transit, const BMessage *m);
	virtual void MouseDown(BPoint point);
	virtual void MouseUp(BPoint point);
	virtual void KeyDown(const char *bytes, int32 numBytes);
	virtual void KeyUp(const char *bytes, int32 numBytes);
	virtual void AttachedToWindow();
	virtual void Draw(BRect frame);
	virtual void FrameResized(float width, float height);
	virtual	void GetPreferredSize(float *width, float *height);
	virtual void MakeFocus(bool focus = true);

	virtual status_t Archive(BMessage *archive, bool deep = true) const;
	static BArchivable *Instantiate(BMessage *archive);

			status_t InsertCartridge(const char *file);
			void RemoveCartridge();
			void PauseGame();
			void ResumeGame();
			bool IsPaused() {return fPauseIndicator; }
			void UpdateScreen(bool redraw_entire_frame);
			void DrawScreen(bool directmode);
			void DrawFPS();
			void ShowFps(bool show = true);
			bool IsFpsShowing();
			void ResizeToConsole(float f = 1.0f);
			void ResizeToFitWindow();
			status_t GetGameInfo(game_info *gameInfo);
			void RefsReceived(BMessage *msg);
			void SetFocusView(MFocusView *view);
			void SetLeftController(controller_t controller)	{fLeftController = controller; }
			void SetRightController(controller_t controller) {fRightController = controller; }
			int32 GetLeftController() const {return fLeftController; }
			int32 GetRightController() const {return fRightController; } 
			
			void SetDirectWindow(bool mode)	{ fDirectWindowMode = mode; }
			bool GetDirectWindow() const {return fDirectWindowMode; }	
			void DirectConnected(direct_buffer_info *info);
			void DirectFillRect(BRect r, rgb_color c);
			void SetHOffset(int h);
	
private:
	static int32 _ComputeThread(void *user)	{return ((STellaView *)user)->ComputeThread();}
			int32 ComputeThread();
	static int32 _DrawThread(void *user)	{return ((STellaView *)user)->DrawThread();}
			int32 DrawThread();

	void dropped_files(const BMessage *msg);
	void handle_key(const char *bytes, int32 numBytes, int32 value);
	void setupProperties(PropertiesSet& set);
	void get_game_info();

	void fill_rect_32(int x, int y, int w, int h, uint32 color);
	void fill_rect_16(int x, int y, int w, int h, uint16 color);
	void fill_rect_8(int x, int y, int w, int h, uint8 color);
	
private:

	int			fNbRectangles;

	struct rectangle_t
	{
		BRect r;
		rgb_color c;	
	} *fRectangles;

	Console 	*fConsole;			// Pointer to the console object or the null pointer
	SoundBeOS 	fSound;				// Create a sound object for use with the console
	Event 		fEvent;				// Event object to use
	bool 		fQuitIndicator;		// Indicates if the user wants to quit
	bool 		fPauseIndicator;	// Indicates if the user wants to pause the game
	uInt32		fDesiredPaddle;		// Indidctes which paddle the mouse should be mapped to
	PropertiesSet *fPropertiesSet;
	uint32		fHeight;
	uint32		fWidth;
	thread_id	fComputeThreadID;
	thread_id	fDrawThreadID;
	rgb_color	fPalette[256];
	float		fFramePerSecond;
	bool		fShowFPS;
	float		fFpsDisplayHeight;
	uint32		fNumberOfFrames;
	bigtime_t 	fTimeFrameRate;
	BString		fGameName;
	bool		fIsReplicant;
	MFocusView	*fFocusView;
	int			fCurrentFrameBufferIndex;
	uint8		*fConsummerFrameBuffer[2];
	uint8		*fProducerFrameBuffer;
	sem_id		fDrawSemID;
	int32		fLeftController;
	int32		fRightController;
	float		fFrameDuration;
	game_info	fGameInfo;
	bool		fDirectWindowMode;
	bool		fEventDirectDraw;
	bool		fEventDraw;

	bool			fConnected;
	void			*fWindowBits;
	int				fBytesPerLine;
	int				fNbBitsPerPixel;
	color_space		fColorSpace;
	clipping_rect	*fClipList;
	clipping_rect	fClipBounds;
	clipping_rect	fOldClipBounds;
	int				fNumClipRects;
	int				fMenuBarHeight;
	int				fOriginX;
	int				fOriginY;
	int				fDirectWidth;
	int				fDirectHeight;
};

// ********************************************************************


class STellaWindow : public BDirectWindow
{
friend class STellaApplication;

public:

enum
{
	MSG_OPEN = 1000,
	MSG_FULLSCREEN,
	MSG_RESOLUTION,
	MSG_SHOW_FPS,
	MSG_PREVMSG,
	MSG_NEXTMSG,
	MSG_GAMEINFO,
	MSG_GAME_STARTED,
	MSG_SELECT_CONTROLLER,
	MSG_DIRECT_WINDOW,
	MSG_PAUSE_GAME
};

public:
			STellaWindow(BRect r);
	virtual ~STellaWindow();
	virtual bool QuitRequested();
	virtual void WindowActivated(bool active);
	virtual void MessageReceived(BMessage *m);
	virtual void MenusBeginning(void);
	virtual void MenusEnded(void);
	virtual void FrameResized(float width, float height);
	virtual void DirectConnected(direct_buffer_info *info);
	
			void Play();
			void ShowInfoWindow();
			void DisplayMainMenu();
			void SetDisplaySize(void);

			void SetTrackerSelection(entry_ref *ref);
			bool GetTrackerWindowFile(entry_ref *ref, bool next) const;

private:
	BRect fOldFrame;
	STellaView *fStellaView;
	BMenuBar *fKeyMenuBar;
	BMenu *fOpenSubmenu;
	BMenuItem *fFpsMenuItem;
	BMenuItem *fPauseMenuItem;
	BMenuItem *fDirectWindowMenuItem;
	BMenuItem *fPreviousMenuItem;
	BMenuItem *fNextMenuItem;
	BMenuItem *fInfoMenuItem;
	BMenu *fFileMenu;
	BMenu *fViewMenu;
	BMenu *fLeftControlMenu;
	BMenu *fRightControlMenu;
	STellaFilePanel *fFilePanel;
	float fKeyMenuBarHeight;
	BMessenger fTrackerMessenger;
	entry_ref fRef;
	BDragger *fDragger;
	BView *fBackGround;
	bool fIsPaused;
	
	BWindow *fInfoWindow;
	STellaGameInfoView *fInfoView;
};


// ********************************************************************

class STellaFilePanel : public BFilePanel
{
public:
			STellaFilePanel();
	virtual ~STellaFilePanel();

	virtual void SelectionChanged();
	virtual void WasHidden();

private:
	void LoadPanelDirectory();
	void SavePanelDirectory();

private:
	STellaView *fStellaView;
	STellaGameInfoView *fStellaInfoView;
	entry_ref fOldRef;
};

// ********************************************************************

class STellaGameInfoView : public BView
{
public:
			STellaGameInfoView(BRect r);
	virtual ~STellaGameInfoView();
	virtual void AttachedToWindow(void);
	virtual void Draw(BRect frame);
	virtual void FrameResized(float w, float h);
	virtual	void GetPreferredSize(float *width, float *height);

	void Update(const game_info *info);

private:
	void DrawTitle(int line, const char *s);
	void DrawText(int line, const char *s);

	game_info fGameInfo;
	bool fInitOk;

	const char *fInputTitles[6];
	char *fTruncatedStrings[6];
	const char *fInputStrings[6];
	BString fResolution;
	float fTextHPos;
	float fTextVPos;
	float fTextHeight;
};

// ********************************************************************

class MFocusView : public BView
{
public:
			MFocusView(BRect r, const char *name, uint32 resizingMode);
	virtual ~MFocusView();

	virtual void Draw(BRect frame);
	virtual void AttachedToWindow();
	virtual void WindowActivated(bool activated);
	virtual void FocusChanging(bool focus);

private:
	void draw_focus(bool focus);
	bool fIsFocus;
	bool fWindowActivated;
	rgb_color fLowColor;
};


