#include "s9x_key.h"

static struct key_ret
{
	const char *name;
} key_list[] = {
	{"Nothing"},
	{"Escape"},
	{"F1"},
	{"F2"},
	{"F3"},
	{"F4"},
	{"F5"},
	{"F6"},
	{"F7"},
	{"F8"},
	{"F9"},
	{"F10"},
	{"F11"},
	{"F12"},
	{"Print Screen"},
	{"Scroll Lock"},
	{"Pause"},
	{"Tilde"},
	{"1"},
	{"2"},
	{"3"},
	{"4"},
	{"5"},
	{"6"},
	{"7"},
	{"8"},
	{"9"},
	{"0"},
	{"-"},
	{"="},
	{"Backspace"},
	{"Insert"},
	{"Home"},
	{"Page Up"},
	{"Numlock"},
	{"Num /"},
	{"Num *"},
	{"Num -"},
	{"Tab"},
	{"Q"},
	{"W"},
	{"E"},
	{"R"},
	{"T"},
	{"Y"},
	{"U"},
	{"I"},
	{"O"},
	{"P"},
	{"["},
	{"]"},
	{"#"},
	{"Delete"},
	{"End"},
	{"Page Down"},
	{"Num 7"},
	{"Num 8"},
	{"Num 9"},
	{"Num +"},
	{"Caps Lock"},
	{"A"},
	{"S"},
	{"D"},
	{"F"},
	{"G"},
	{"H"},
	{"J"},
	{"K"},
	{"L"},
	{";"},
	{"'"},
	{"Return"},
	{"Num 4"},
	{"Num 5"},
	{"Num 6"},
	{"Left Shift"},
	{"Z"},
	{"X"},
	{"C"},
	{"V"},
	{"B"},
	{"N"},
	{"M"},
	{","},
	{"."},
	{"/"},
	{"Right Shift"},
	{"Up"},
	{"Num 1"},
	{"Num 2"},
	{"Num 3"},
	{"Num Enter"},
	{"Left Ctrl"},
	{"Left Alt"},
	{"Space"},
	{"Right Alt"},
	{"Right Ctrl"},
	{"Left"},
	{"Down"},
	{"Right"},
	{"Num 0"},
	{"Num ."},
	{"Left Win"},
	{"Right Win"},
	{"Right Menu"},
	{"\\"}
};

const char *key_name(unsigned int i)
{
	if((i > S9X_LSLASH) || (i > sizeof(key_list) / sizeof(key_list[0])))
		return "unknown key";
	return key_list[i].name;
}
