#!/bin/sh

# installer for intelliUSB
# jim mussared - jim@mussared.ii.net
# Michael Davidson - slaad@bong.com.au
# v1.1  december 2002


#!/bin/sh
msg=$'This will install the intelliUSB driver v1.0 for USB mice.\n'
msg="$msg"$'This will disable support for PS/2 mice on your system. Make sure you have read the ReadMe.html file\n'
msg="$msg"$'Are you sure you wish to continue?'

folder=`dirname "$0"`
if [ `alert "$msg" "No" "Yes"` = "Yes" ]; then

	if [ -e /boot/home/config/add-ons/input_server/devices/intelliUSB ]; then
		alert "It looks like you're upgrading. Skipping probing for mouse." "Ok"
	else
		alert "Now we're probing to make sure that your mouse is compatible. Make sure the mouse is plugged into a USB port and click Ok" "Ok"
				
		if [ `"$folder/Files/probe"` = "yes" ]; then
			alert "Compatible mouse found" "Yay!"
           copyattr --data "$folder/Files/intelliMouse.cfg" "/boot/home/config/settings/intelliMouse"
		else
			alert "Your mouse is not supported by this driver... :(" "Sorry"
			exit
		fi
	fi
	
	copyattr --data "$folder/Files/intelliUSB" /boot/home/config/add-ons/input_server/devices/
	copyattr --data "$folder/Files/intelliMouse" /boot/preferences/
	rm -f /boot/beos/system/add-ons/input_server/devices/mouse
	
	msg=$'Would you like to create a link to the preferences program in your Be Preferencs Menu?\n'
	msg="$msg"$'Note: It is already in /boot/preferences'
	if [ `alert "$msg" "No" "Yes"` = "Yes" ]; then
		ln -s /boot/preferences/intelliMouse /boot/home/config/be/Preferences/intelliMouse
	fi
	
	alert "The input server will now restart. Make sure you have read the ReadMe.html file so you know what to do if something goes wrong." "Ok"
	/system/servers/input_server -q
	
	sleep 2
	
	msg=$'Installation complete. Your mouse should be working now, with wheel support and you will be able to configure the extra buttons in the preferences app.\n'
	msg="$msg"$'If its not working, then use tab to select "No" below and press space.\n'
	msg="$msg"$'Is your mouse working?'
	
	if [ `alert "$msg" "No..." "Yes!"` = "No..." ]; then
	echo hello
		sh "$folder/uninstall.sh"
	fi

fi