#ifndef BJC_H
#define BJC_H

#include <AppKit.h>
#include <InterfaceKit.h>

#include "PrinterDriver.h"

#define SCALE 8.3333f
#define SCREEN 72.0f
#define LETTER_WIDTH 8.5
#define LETTER_HEIGHT 11

class BJC : public PrinterDriver
	{
	public:
		// constructors / destructor
		BJC();
		~BJC();
		
		// public methods
		status_t 			PrintPage(int32 page_number, int32 page_count);

		status_t			InitPrinter();
		status_t			ExitPrinter();
		status_t			BeginPage();
		status_t			EndPage();
		
		status_t 			AdvancePaper(int count);
		status_t			AdvanceHead(int count);
		
	private:
		int 				CompressPlane(const uint8 * frame, uint32 width, uint8 * compressed);
		
		status_t			WriteCommand(uint8 command, int length = 0, const void * data = NULL);
		status_t			WriteHiLo(int value);
		status_t			WriteLoHi(int value);
	};

#endif	// #if BJC_H
