#ifndef BJ130E_H
#define BJ130E_H

#include <AppKit.h>
#include <InterfaceKit.h>

#include "PrinterDriver.h"

class BJ130e : public PrinterDriver
	{
	public:
		// constructors / destructor
		BJ130e();
		~BJ130e();
		
		// public methods
		status_t 			PrintPage(int32 page_number, int32 page_count);

	private:
		status_t			InitPrinter();
		status_t			ExitPrinter();
		status_t			BeginPage();
		status_t			EndPage();

		status_t 			AddToSwipe(uint8 * in, uint32 w, uint32	nozzle, uint8 *	swipe);
		status_t 			WriteSwipe(uint8 * in, uint32 w);

		status_t 			AdvancePaper(int count);
		status_t			AdvanceHead(int count);
		
		status_t			WriteCommand(uint8 command, int length = 0, const void * data = NULL);
		status_t			WriteHiLo(int value);
		status_t			WriteLoHi(int value);

		int					m_head_nb_nozzles;
		int					m_head_nb_bytes;
		uint8				m_graphic_mode;
	};

#endif	// #if BJ130E_H

