#include <stdio.h>

#include "BitmapTools.h"


uint8 index_for_color
	(
	const color_map *	cm,
	rgb_color			color
	)
{
	// returns the index for a color into the system clut 
	return cm->index_map[ 	((color.red & 0xf8) << 7) |
							((color.green & 0xf8) << 2 ) |
							((color.blue & 0xf8) >> 3) ];
}


status_t dither_bitmap
	(
	BBitmap * 	bitmap,
	color_space	space
	)
{
	const color_map *	colors;
	rgb_color			white = {255, 255, 255, 255};
	rgb_color			black = {0, 0, 0, 255};
	uint8 				white_index;
	uint8				black_index;
	char				text[128];
	BAlert *			alert;

	if ( space != B_GRAY1 )
		return B_ERROR;
		
	colors = system_colors();
	
	white_index = index_for_color(colors, white);
	black_index	= index_for_color(colors, black);
	
	sprintf(text, "white index = %d, black index = %d", white_index, black_index);
	alert = new BAlert("dither_bitmap", text, "Ok");
	alert->Go();
	
	return B_OK;
}

/*
#if 0


The index_map maps every RGB combination that can be expressed in 15 bits (5 bits per component) to a single color_list index 
that best approximates the original RGB data. The following example demonstrates how to squeeze 24-bit RGB data into a 15-bit 
number that can be used as an index into the index_map: 
   long rgb15 = ( ((red & 0xf8) << 7) | 
                  ((green & 0xf8) << 2) | 
                  ((blue & 0xf8) >> 3) );
Most applications won't need to use the index map directly; the IndexForColor() function performs the same conversion with less 
fuss (no masking and shifting required). However, applications that implement repetitive graphic operations, such as dithering, may 
want to access the index map themselves, and thus avoid the overhead of an additional function call. 

static void do_line(byte * in, byte * out, int32 len, int32 row);
static int8 min(int8 c, int8 y, int8 m);



void dither(byte * in, int32 bpr, int32 rows, byte * out)
{
	int32 row;
	
	for (row = 0; row < rows; row++)
		do_line(in + (row * bpr), out + (row * (int)ceil(bpr / 8)), bpr, row);
}


//	Dithering routine borrowed from obsolete HP Driver.

#define	K	8
long	magic[4][4] = {
		{300/K,2100/K,3000/K,5100/K},
		{3600/K,4200/K,900/K,1500/K},
		{2400/K,600/K,4650/K,2700/K},
		{3900/K,3300/K,1800/K,1200/K}
};

void do_line(byte * in, byte * out, int32 len, int32 ypos)
{
	long		i, k;
	long		intensity;	
	rgb_color	c;
	const color_map 	*system_map;
	uchar		cur;	
	long		xx;

	system_map = system_colors();

	ypos &= 0x03;
	xx = 0;
	for (i = 0; i < len/8; i++) {
		cur = 0;
		for (k = 0; k < 8; k++) {
			xx++;
			c = system_map->color_list[*in++];
			intensity = c.red + c.green + c.blue;
		
			if (intensity < magic[ypos][xx&0x03])
				cur |= (0x80 >> k);
		}
		out[i] = cur;
	}
}

void rotate(byte * in, int32 bpr, int32 rows, byte * out)
{
	int32 row;
	int32 col;
	int32 offset;
	
	for (col = 0; col < bpr; col++)
	{
		offset = col * rows - 1;	
		for (row = rows	- 1; row >= 0; row--)
		{
			out[offset + rows - row]
				= in[(bpr * row) + col];
		}
	}
}

void RGBtoCYMK(byte * in, int32 bpr, int32 rows,
					byte * c, byte * y, byte * m, byte * k)
{
	int32 row;
	int32 col;
	int8 cd, md, yd;
	int32 offset;

	const color_map * system_map;
	
	system_map = system_colors();
	
	for (row = 0; row < rows; row++)
	{
		offset = bpr * row;
		for (col = 0; col < bpr; col += 4)
		{
			cd = 255 - system_map->color_list[in[offset + col]].red;
			md = 255 - system_map->color_list[in[offset + col]].blue;
			yd = 255 - system_map->color_list[in[offset + col]].green;
			k[offset + col] = min(cd, md, yd);
			c[offset + col] = cd - k[offset + col];
			m[offset + col] = md - k[offset + col];
			c[offset + col] = yd - k[offset + col];
		}
	}
}


//	Let's make this as hard to read as possible. C is fun!

int8 min(int8 c, int8 y, int8 m)
{
	return (c<y)?((c<m)?c:m):((y<m)?y:m);
}

#endif
*/
