#!/bin/sh
# This install-shell installs the 3C509 network add-on
#
alert --info "Do you wish to install the 3C509 driver from folder `dirname $0`?" Install Abort 

if [ $? = 1 ]
then
	alert --stop "Installation aborted!" Quit
	exit 1
else
	DRDIR=`dirname $0`
	mkdir -p ~/config/add-ons/kernel/drivers/bin
	mkdir -p ~/config/add-ons/kernel/drivers/dev/net

	cp $DRDIR/3c509/obj.x86/3c509 ~/config/add-ons/kernel/drivers/bin/3c509
	ln -s ~/config/add-ons/kernel/drivers/bin/3c509 ~/config/add-ons/kernel/drivers/dev/net/3c509

	~/config/be/Preferences/Network &
	sleep 1
	alert --stop "Now you have to add the \"Etherlink II/16 (ISA)\" in Network preferences.  Fill in the correct values and save the Network settings. Don't restart networking.  Keep the Preferences/Network window open!  Do this and then press \"Done\"" "Done"
	chmod 440 $DRDIR/network.sample
	StyledEdit ~/config/settings/network $DRDIR/network.sample &
	sleep 1
	alert --stop "Now you must edit the file \"network\". Look at the \"network.sample\" file and in your \"network\" file change the DEVICEPORT, DEVICEIRQ, DEVICEMEM numbers to the correct numbers for your machine, and change DEVICELINK to the value mentioned in the network.sample file.  Do this and then press \"Done\"" "Done"
	alert --stop "Save your network file and press Restart Networking in Preferences/Network.  Do this and then press \"Done\"" "Done"
fi
alert --info "You reached the end of the installation routine.  If you have any problems, feel free to send an e-mail to \"michael@augusta.de\"" "OK"

