#include <KernelExport.h>
#include <Drivers.h>
#include "generic_wrapper.h"
#include <stdio.h>
#include <fcntl.h>

static char *ec9xx_name[] = { "net/3c509", NULL };

int32	api_version = B_CUR_DRIVER_API_VERSION;

static device_hooks ec9xx_device =  {
	generic_open, 		/* -> open entry point */
	generic_close,		/* -> close entry point */
	generic_free,			/* -> free entry point */
	generic_control, 		/* -> control entry point */
	generic_read,			/* -> read entry point */
	generic_write,			/* -> write entry point */
	NULL,
	NULL
};

_EXPORT const char **
publish_devices(void)
{
	return ec9xx_name;
}

_EXPORT device_hooks *
find_device(const char *name)
{
	return &ec9xx_device;
}
