//
//
//	Open GL configuration view
//
//


#include <stdio.h>
#include <string.h>
#include <PopUpMenu.h>
#include <MenuItem.h>
#include <MenuField.h>
#include <CheckBox.h>
#include <Message.h>

#include "AmachiDefs.h"
#include "AmachiGLConfig.h"



AmachiGLConfig::AmachiGLConfig(BRect frm, const char* n, uint32 rmode, uint32 f)
:BView(frm, n, rmode, f)
{
	BuildView();
	SetEnabled(false);
}


AmachiGLConfig::~AmachiGLConfig()
{
}


void
AmachiGLConfig::BuildView()
{
	rgb_color			c;
	BMessage*			msg;
	BRect				fr = Bounds();
	fr.SetRightBottom(BPoint(fr.left + fr.Width()*0.5, fr.top + 20.0));

	c.red = 220;		c.green = 220;		c.blue = 220;
	SetViewColor(c);

	// projection
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_PROJECTION);
	projection = new BCheckBox(fr, "projection", "perspective", msg);
	AddChild(projection);

	// shading
	fr.OffsetBy(0.0, fr.Height()-2.0);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_SHADING);
	shading = new BCheckBox(fr, "shading", "smooth shading", msg);
	AddChild(shading);

	// transparency
	fr.OffsetBy(0.0, fr.Height()-2.0);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_TRANSPARENCY);
	transparency = new BCheckBox(fr, "transparency", "transparency", msg);
	AddChild(transparency);

	// zbuffer
	fr.OffsetBy(0.0, fr.Height()-2.0);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_ZBUFFER);
	zbuffer = new BCheckBox(fr, "zbuffer", "Z-buffer", msg);
	AddChild(zbuffer);

	// lighting
	fr.OffsetBy(0.0, fr.Height()-2.0);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_LIGHTING);
	lighting = new BCheckBox(fr, "lighting", "lighting", msg);
	AddChild(lighting);

	fr.OffsetBy(20.0, fr.Height()-4.0);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_LIGHTING);
	lighting_local = new BCheckBox(fr, "lighting_local", "local viewer", msg);
	AddChild(lighting_local);

	fr.OffsetBy(0.0, fr.Height()-4.0);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_LIGHTING);
	lighting_2sides = new BCheckBox(fr, "lighting_2sides", "2 sides", msg);
	AddChild(lighting_2sides);


	fr = Bounds();
	fr.SetRightBottom(BPoint(fr.left + fr.Width()*0.5, fr.top + 20.0));
	fr.OffsetBy(fr.Width(), 0.0);

	// fullscreen & auto rotate
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_FULLSCREEN);
	fullscreen = new BCheckBox(fr, "fullscreen", "fullscreen", msg);
	AddChild(fullscreen);

	fr.OffsetBy(0.0, fr.Height() - 4.0);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_MOTION);
	motion = new BCheckBox(fr, "motion", "manual", msg);
	AddChild(motion);

	// front_faces
	fr.OffsetBy(0.0, fr.Height() + 5.0);
	BPopUpMenu*			popup_menu;
	popup_menu = new BPopUpMenu("front_faces", true, true, B_ITEMS_IN_COLUMN);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_FRONT_RENDERING);
	front_dots = new BMenuItem("dots", msg);
	front_dots->SetMarked(true);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_FRONT_RENDERING);
	front_lines = new BMenuItem("lines", msg);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_FRONT_RENDERING);
	front_filled = new BMenuItem("filled", msg);
	popup_menu->AddItem(front_dots);
	popup_menu->AddItem(front_lines);
	popup_menu->AddItem(front_filled);

	front_faces = new BMenuField(fr, "front_faces", "front faces: ", popup_menu,
								B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
	front_faces->SetAlignment(B_ALIGN_RIGHT);
	AddChild(front_faces);

	// back faces
	popup_menu = new BPopUpMenu("back_faces", true, true, B_ITEMS_IN_COLUMN);
/*	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_BACK_RENDERING);
	back_dots = new BMenuItem("dots", msg);
	back_dots->SetMarked(true);
*/	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_BACK_RENDERING);
	back_lines = new BMenuItem("lines", msg);
	back_lines->SetMarked(true);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_BACK_RENDERING);
	back_filled = new BMenuItem("filled", msg);
//	popup_menu->AddItem(back_dots);
	popup_menu->AddItem(back_lines);
	popup_menu->AddItem(back_filled);

	fr.OffsetBy(0.0, fr.Height() + 5.0);
	back_faces = new BMenuField(fr, "back_faces", "back faces: ", popup_menu,
								B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
	back_faces->SetAlignment(B_ALIGN_RIGHT);
	AddChild(back_faces);

	// culling
	popup_menu = new BPopUpMenu("culling", true, true, B_ITEMS_IN_COLUMN);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_CULLING);
	culling_off = new BMenuItem("off", msg);
	culling_off->SetMarked(true);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_CULLING);
	culling_cw = new BMenuItem("clockwise", msg);
	msg = new BMessage(AMACHI_SET_GLPARAM);
	msg->AddInt32("mode", AMACHI_CULLING);
	culling_ccw = new BMenuItem("counter-clockwise", msg);
	popup_menu->AddItem(culling_off);
	popup_menu->AddItem(culling_cw);
	popup_menu->AddItem(culling_ccw);

	fr.OffsetBy(0.0, fr.Height() + 5.0);
	culling = new BMenuField(fr, "culling", "culling: ", popup_menu,
								B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
	culling->SetAlignment(B_ALIGN_RIGHT);
	AddChild(culling);


	fr = ChildAt(0)->Frame();
	for (int32 i = 1; i < CountChildren(); i++)
		fr = fr | ChildAt(i)->Frame();
	ResizeTo(fr.Width(), fr.Height());
}


void
AmachiGLConfig::ReadProjection(GLconfig& c)
{
	c.modes[AMACHI_PROJECTION] = (projection->Value() == B_CONTROL_ON)
								? AMACHI_PERSPECTIVE_PROJECTION
								: AMACHI_ORTHOGRAPHIC_PROJECTION;
//printf("ReadProjection: %x\n", c.modes[AMACHI_PROJECTION]);
}


void
AmachiGLConfig::ReadShading(GLconfig& c)
{
	c.modes[AMACHI_SHADING] = (shading->Value() == B_CONTROL_ON)
								? AMACHI_SMOOTH_SHADING
								: AMACHI_FLAT_SHADING;
//printf("ReadShading: %x\n", c.modes[AMACHI_SHADING]);
}


void
AmachiGLConfig::ReadTransparency(GLconfig& c)
{
	c.modes[AMACHI_TRANSPARENCY] = (transparency->Value() == B_CONTROL_ON)
									? AMACHI_USE_TRANSPARENCY
									: AMACHI_NO_TRANSPARENCY;
//printf("ReadTransparency: %x\n", c.modes[AMACHI_TRANSPARENCY]);
}


void
AmachiGLConfig::ReadZbuffer(GLconfig& c)
{
	c.modes[AMACHI_ZBUFFER] = (zbuffer->Value() == B_CONTROL_ON)
								? AMACHI_USE_ZBUFFER
								: AMACHI_NO_ZBUFFER;
//printf("ReadZbuffer: %x\n", c.modes[AMACHI_ZBUFFER]);
}


void
AmachiGLConfig::ReadLighting(GLconfig& c)
{
	c.modes[AMACHI_LIGHTING] = (lighting->Value() == B_CONTROL_ON)
								? AMACHI_USE_LIGHTING
								: AMACHI_NO_LIGHTING;
	if (lighting_local->Value() == B_CONTROL_ON)
		c.modes[AMACHI_LIGHTING] |= AMACHI_LOCAL_VIEWER_LIGHTING;
	if (lighting_2sides->Value() == B_CONTROL_ON)
		c.modes[AMACHI_LIGHTING] |= AMACHI_TWO_SIDES_LIGHTING;
//printf("ReadLighting: %x\n", c.modes[AMACHI_LIGHTING]);
}


void
AmachiGLConfig::ReadFrontFace(GLconfig& c)
{
	const char*			marked_label;
	marked_label = front_faces->Menu()->FindMarked()->Label();
	if (!strcmp(marked_label, "dots"))
		c.modes[AMACHI_FRONT_RENDERING] = AMACHI_DOTS_RENDERING;
	else if (!strcmp(marked_label, "lines"))
		c.modes[AMACHI_FRONT_RENDERING] = AMACHI_LINES_RENDERING;
	else
		c.modes[AMACHI_FRONT_RENDERING] = AMACHI_FILLED_RENDERING;
//printf("ReadFrontFace: %x\n", c.modes[AMACHI_FRONT_RENDERING]);
}


void
AmachiGLConfig::ReadBackFace(GLconfig& c)
{
	const char*			marked_label;
	marked_label = back_faces->Menu()->FindMarked()->Label();
/*	if (!strcmp(marked_label, "dots"))
		c.modes[AMACHI_BACK_RENDERING] = AMACHI_DOTS_RENDERING;
	else
*/	if (!strcmp(marked_label, "lines"))
		c.modes[AMACHI_BACK_RENDERING] = AMACHI_LINES_RENDERING;
	else
		c.modes[AMACHI_BACK_RENDERING] = AMACHI_FILLED_RENDERING;
//printf("ReadBackFace: %x\n", c.modes[AMACHI_BACK_RENDERING]);
}


void
AmachiGLConfig::ReadCulling(GLconfig& c)
{
	const char*			marked_label;
	marked_label = culling->Menu()->FindMarked()->Label();
	if (!strcmp(marked_label, "off"))
		c.modes[AMACHI_CULLING] = AMACHI_NO_CULLING;
	else if (!strcmp(marked_label, "clockwise"))
		c.modes[AMACHI_CULLING] = AMACHI_CW_CULLING;
	else
		c.modes[AMACHI_CULLING] = AMACHI_CCW_CULLING;
//printf("ReadCulling: %x\n", c.modes[AMACHI_CULLING]);
}


void
AmachiGLConfig::ReadFullscreen(GLconfig& c)
{
	c.modes[AMACHI_FULLSCREEN] = (fullscreen->Value() == B_CONTROL_ON)
								? AMACHI_USE_FULLSCREEN
								: AMACHI_NO_FULLSCREEN;
//printf("ReadFullscreen: %x\n", c.modes[AMACHI_FULLSCREEN]);
}


void
AmachiGLConfig::ReadMotion(GLconfig& c)
{
	c.modes[AMACHI_MOTION] = (motion->Value() == B_CONTROL_ON)
								? AMACHI_MANUAL_MOTION
								: AMACHI_AUTO_MOTION;
//printf("ReadMotion: %x\n", c.modes[AMACHI_MOTION]);
}


void
AmachiGLConfig::ReadFrom(GLconfig& conf)
{
	WriteProjection(conf);
	WriteShading(conf);
	WriteTransparency(conf);
	WriteZbuffer(conf);
	WriteLighting(conf);
	WriteFrontFace(conf);
	WriteBackFace(conf);
	WriteCulling(conf);
	WriteFullscreen(conf);
	WriteMotion(conf);
}


void
AmachiGLConfig::ReadFrom(BMessage* msg)
{
	GLconfig		conf;
	conf.ReadFrom(msg);
	ReadFrom(conf);
}


void
AmachiGLConfig::WriteProjection(GLconfig& c)
{
	projection->SetValue(	(c.modes[AMACHI_PROJECTION] == AMACHI_PERSPECTIVE_PROJECTION)
							? B_CONTROL_ON
							: B_CONTROL_OFF);
}


void
AmachiGLConfig::WriteShading(GLconfig& c)
{
	shading->SetValue(	(c.modes[AMACHI_SHADING] == AMACHI_SMOOTH_SHADING)
						? B_CONTROL_ON
						: B_CONTROL_OFF);
}


void
AmachiGLConfig::WriteTransparency(GLconfig& c)
{
	transparency->SetValue(	(c.modes[AMACHI_TRANSPARENCY] == AMACHI_USE_TRANSPARENCY)
							? B_CONTROL_ON
							: B_CONTROL_OFF);
}


void
AmachiGLConfig::WriteZbuffer(GLconfig& c)
{
	zbuffer->SetValue(	(c.modes[AMACHI_ZBUFFER] == AMACHI_USE_ZBUFFER)
						? B_CONTROL_ON
						: B_CONTROL_OFF);
}


void
AmachiGLConfig::WriteLighting(GLconfig& c)
{
	lighting->SetValue((c.modes[AMACHI_LIGHTING] & AMACHI_USE_LIGHTING)
						? B_CONTROL_ON
						: B_CONTROL_OFF);
	lighting_local->SetEnabled(c.modes[AMACHI_LIGHTING] & AMACHI_USE_LIGHTING);
	lighting_local->SetValue((c.modes[AMACHI_LIGHTING] & AMACHI_LOCAL_VIEWER_LIGHTING)
							? B_CONTROL_ON
							: B_CONTROL_OFF);

	lighting_2sides->SetEnabled(c.modes[AMACHI_LIGHTING] & AMACHI_USE_LIGHTING);
	lighting_2sides->SetValue((c.modes[AMACHI_LIGHTING] & AMACHI_TWO_SIDES_LIGHTING)
								? B_CONTROL_ON
								: B_CONTROL_OFF);
}


void
AmachiGLConfig::WriteFrontFace(GLconfig& c)
{
	if (c.modes[AMACHI_FRONT_RENDERING] == AMACHI_DOTS_RENDERING)
		front_dots->SetMarked(true);
	else if (c.modes[AMACHI_FRONT_RENDERING] == AMACHI_LINES_RENDERING)
		front_lines->SetMarked(true);
	else
		front_filled->SetMarked(true);
}


void
AmachiGLConfig::WriteBackFace(GLconfig& c)
{
/*	if (c.modes[AMACHI_BACK_RENDERING] == AMACHI_DOTS_RENDERING)
		back_dots->SetMarked(true);
	else
*/	if (c.modes[AMACHI_BACK_RENDERING] == AMACHI_LINES_RENDERING)
		back_lines->SetMarked(true);
	else
		back_filled->SetMarked(true);
}


void
AmachiGLConfig::WriteCulling(GLconfig& c)
{
	if (c.modes[AMACHI_CULLING] == AMACHI_NO_CULLING)
		culling_off->SetMarked(true);
	else if (c.modes[AMACHI_CULLING] == AMACHI_CW_CULLING)
		culling_cw->SetMarked(true);
	else
		culling_ccw->SetMarked(true);
}


void
AmachiGLConfig::WriteFullscreen(GLconfig& c)
{
	fullscreen->SetValue(	(c.modes[AMACHI_FULLSCREEN] == AMACHI_USE_FULLSCREEN)
						? B_CONTROL_ON
						: B_CONTROL_OFF);
}


void
AmachiGLConfig::WriteMotion(GLconfig& c)
{
	motion->SetValue(	(c.modes[AMACHI_MOTION] == AMACHI_MANUAL_MOTION)
						? B_CONTROL_ON
						: B_CONTROL_OFF);
}


void
AmachiGLConfig::WriteTo(GLconfig& conf)
{
	ReadProjection(conf);
	ReadShading(conf);
	ReadTransparency(conf);
	ReadZbuffer(conf);
	ReadLighting(conf);
	ReadFrontFace(conf);
	ReadBackFace(conf);
	ReadCulling(conf);
	ReadFullscreen(conf);
	ReadMotion(conf);
}


void
AmachiGLConfig::WriteTo(BMessage* msg)
{
	GLconfig		conf;
	WriteTo(conf);
	conf.WriteTo(msg);
}


void
AmachiGLConfig::EnableAll()
{
	SetEnabled(true);
	lighting->SetEnabled(true);
	lighting_local->SetEnabled(true);
	lighting_2sides->SetEnabled(true);
	transparency->SetEnabled(true);
}


void
AmachiGLConfig::SetEnabled(bool b)
{
	projection->SetEnabled(b);
	shading->SetEnabled(b);
	transparency->SetEnabled(b);
	zbuffer->SetEnabled(b);
	lighting->SetEnabled(b);
	if (b)
	{
		lighting_local->SetEnabled(lighting->Value() == B_CONTROL_ON);
		lighting_2sides->SetEnabled(lighting->Value() == B_CONTROL_ON);
	}
	else
	{
		lighting_local->SetEnabled(false);
		lighting_2sides->SetEnabled(false);
	}
	front_faces->SetEnabled(b);
	back_faces->SetEnabled(b);
	culling->SetEnabled(b);
	fullscreen->SetEnabled(b);
	motion->SetEnabled(b);
}


void
AmachiGLConfig::EnableTransparency(bool b)
{
	transparency->SetEnabled(b);
}


void
AmachiGLConfig::SetTarget(BHandler* target)
{
	BLooper*			wnd = target->Looper();

	projection->SetTarget(target, wnd);
	shading->SetTarget(target, wnd);
	transparency->SetTarget(target, wnd);
	zbuffer->SetTarget(target, wnd);
	lighting->SetTarget(target, wnd);
	lighting_local->SetTarget(target, wnd);
	lighting_2sides->SetTarget(target, wnd);
	front_dots->SetTarget(target, wnd);
	front_lines->SetTarget(target, wnd);
	front_filled->SetTarget(target, wnd);
//	back_dots->SetTarget(target, wnd);
	back_lines->SetTarget(target, wnd);
	back_filled->SetTarget(target, wnd);
	culling_off->SetTarget(target, wnd);
	culling_cw->SetTarget(target, wnd);
	culling_ccw->SetTarget(target, wnd);
	fullscreen->SetTarget(target, wnd);
	motion->SetTarget(target, wnd);
}


void
AmachiGLConfig::AttachedToWindow()
{
	SetTarget(this);
}
