//
//
//	Am@chi OpenGL window
//
//											(C) JoOl 1998


#include "AmachiGLWindow.h"
#include "AmachiGLView.h"
#include "AmachiDefs.h"
#include "SceneItem.h"
#include "AmachiApp.h"


AmachiGLWindow::AmachiGLWindow(BRect frame, const char* name, window_look look,
								window_feel feel, uint32 flags, uint32 wkspaces)
: BDirectWindow(frame, name, look, feel, flags | B_OUTLINE_RESIZE, wkspaces)
{
	BRect			fr;

	// window's background view
	fr = Bounds();
	glview = new AmachiGLView(fr, "OpenGLview", B_FOLLOW_ALL,
								B_WILL_DRAW | B_FRAME_EVENTS,
								BGL_RGB | BGL_DEPTH | BGL_DOUBLE);
	this->AddChild(glview);

	BScreen			screen(B_MAIN_SCREEN_ID);
	SetSizeLimits(	100.0, screen.Frame().Width()-10.0,
					100.0, screen.Frame().Height()-0.0);
}


AmachiGLWindow::~AmachiGLWindow()
{
}


bool
AmachiGLWindow::QuitRequested()
{
	if (!IsHidden())
		Hide();
	return false;
}


void
AmachiGLWindow::MessageReceived(BMessage* msg)
{
	if (msg->HasRef("refs"))
	{
		be_app->RefsReceived(msg);
		return;
	}

	SceneItem*			sceneItem = NULL;

	switch (msg->what)
	{
		case AMACHI_RENDER_SCENE:
			msg->FindPointer("sceneItem", &sceneItem);
			if (sceneItem)
			{
				SetTitle(sceneItem->GetLabel());
				if (IsHidden())
					Show();
				else
					Activate(true);
				glview->SetTo(	sceneItem->GetScene(),
								sceneItem->GetConfig(),
								sceneItem->GetConfigView());
			}
			break;

		default:
			BWindow::MessageReceived(msg);
			break;
	}

	BWindow::MessageReceived(msg);
}


void
AmachiGLWindow::DirectConnected(direct_buffer_info* info)
{
	glview->DirectConnected(info);
}


AmachiGLView*
AmachiGLWindow::GetGLView() const
{
	return glview;
}
