//
//
//	Am@chi
//
//											(C) JoOl 1998

#include <FindDirectory.h>
#include <TranslationUtils.h>
#include "AmachiDefs.h"
#include "AmachiApp.h"
#include "RstringItem.h"
#include "RiconedStringItem.h"
#include "AmachiAddOn.h"
#include "LAPerrors.h"


extern int main();
int
main()
{
	AmachiApp			app;
	app.Run();

	return 0;
}



AmachiApp::AmachiApp()
: BApplication(APP_SIGNATURE),
  parserBlockSize(2048)
{
	// Determine the directory of the application
	app_info			appInfo;
	GetAppInfo(&appInfo);
	BEntry				appEntry(&appInfo.ref, true);
	appEntry.GetPath(&appPath);
	appPath.GetParent(&appPath);
	defaultRenderParams.SetDefault();

	// main window
	BRect				fr;

	fr.Set(0.0, 0.0, 199.0, 149.0);
	fr.OffsetBy(270.0, 380.0);
	infoWin = new AmachiInfoWindow(fr, "About Am@chi...", B_TITLED_WINDOW_LOOK,
								B_NORMAL_WINDOW_FEEL,
								B_NOT_ZOOMABLE | B_NOT_RESIZABLE,
								B_CURRENT_WORKSPACE);

	fr.Set(0.0, 0.0, 300.0, 330.0);
	fr.OffsetBy(270.0, 380.0);

	// amachi window
	amachiWin = new AmachiWindow(fr, "Am@chi", B_TITLED_WINDOW_LOOK,
								B_NORMAL_WINDOW_FEEL,
								B_NOT_ZOOMABLE | B_NOT_V_RESIZABLE,
								B_CURRENT_WORKSPACE);

	// messages window
	fr = amachiWin->Frame();
	fr.OffsetBy(fr.Width() + 10.0, 0.0);
	fr.SetRightBottom(BPoint(fr.left + 350.0, fr.top + 250.0));
	messagesWin = new MessagesWindow(fr, "Am@chi messages", B_TITLED_WINDOW_LOOK,
									B_NORMAL_WINDOW_FEEL, 0, B_CURRENT_WORKSPACE);

	// loaders window
	fr = amachiWin->Frame();
	fr.OffsetBy(-260.0, 0.0);
	fr.SetRightBottom(BPoint(fr.left + 250.0, fr.top + 180.0));
	loadersWin = new LoadersWindow(fr, "Am@chi loaders", B_TITLED_WINDOW_LOOK,
									B_NORMAL_WINDOW_FEEL,
									B_NOT_RESIZABLE,
									B_CURRENT_WORKSPACE);

	// setup window
	fr = amachiWin->Frame();
	fr.OffsetBy(fr.Width() + 10.0, 0.0);
	fr.SetRightBottom(BPoint(fr.left + 400.0, fr.top + 300.0));
	setupWin = new SetupWindow(fr, "Am@chi setup", B_TITLED_WINDOW_LOOK,
								B_NORMAL_WINDOW_FEEL,
								B_NOT_RESIZABLE | B_NOT_ZOOMABLE,
								B_CURRENT_WORKSPACE);

	// OpenGL window
	fr = amachiWin->Frame();
	fr.OffsetBy(fr.Width() + 10.0, 0.0);
	fr.SetRightBottom(BPoint(fr.left + 255.0, fr.top + 255.0));
	glWin = new AmachiGLWindow(fr, AMACHI_WINDOW_TITLE, B_TITLED_WINDOW_LOOK,
								B_NORMAL_WINDOW_FEEL, 0, B_CURRENT_WORKSPACE);
	amachiWin->SetGLWindow(glWin);

	LoadIcons();
	ReadPrefs();

	infoWin->Run();
	amachiWin->Show();
	messagesWin->Run();
	setupWin->Run();
	loadersWin->Run();
	glWin->Run();


	// messages output
	BMessage			msgMsg(AMACHI_NEW_MESSAGE);
	messagesOutput = new LAPtracer(256, LAP_BUFFER_GROW_ON_OVERFLOW,
								LAP_BUFFER_NO_OUTPUT);
	messagesOutput->SetBHandlerOutput(NULL, messagesWin, &msgMsg);

	// retrieve useful pointers
	messagesRoster = messagesWin->GetMessagesRoster();
	addonsRoster = setupWin->GetAddOnsRoster();
	scenesRoster = amachiWin->GetScenesRoster();
	loadersRoster = loadersWin->GetLoadersRoster();

	// load add-ons
	if (setupWin->Lock())
	{
		int32			addonsCount;
		BPath			addonsPath(appPath);
		addonsPath.Append("add-ons");
		addonsCount = setupWin->LoadAddons(addonsPath.Path());

		setupWin->Unlock();
	}

	if (setupWin->Lock())
	{
		setupWin->ReadFrom(defaultRenderParams);
		setupWin->Unlock();
	}

}


AmachiApp::~AmachiApp()
{
	if (messagesOutput)
		delete messagesOutput;
}


void
AmachiApp::ReadPrefs()
{
	BMessage				prefMsg(AMACHI_PREFS_MSG);

	BPath					prefPath;
	if (find_directory(B_COMMON_SETTINGS_DIRECTORY, &prefPath) == B_NO_ERROR)
	{
		BFile				prefFile;

		prefPath.Append(APP_PREFS_FILENAME);
		if (prefFile.SetTo(prefPath.Path(), B_READ_ONLY) == B_NO_ERROR)
		{
			prefMsg.Unflatten(&prefFile);
			prefFile.Unset();

			UsePrefs(prefMsg);
		}
	}
}


void
AmachiApp::WritePrefs()
{
	BMessage				prefMsg(AMACHI_PREFS_MSG);
	prefMsg.AddInt32("version", 'v001');
	prefMsg.AddRect("main",		amachiWin->Frame());
	prefMsg.AddRect("loaders",	loadersWin->Frame());
	prefMsg.AddRect("setup",	setupWin->Frame());
	prefMsg.AddRect("messages",	messagesWin->Frame());
	prefMsg.AddRect("gl",		glWin->Frame());
	defaultRenderParams.WriteTo(&prefMsg);

	BPath					prefPath;

	if (find_directory(B_COMMON_SETTINGS_DIRECTORY, &prefPath) == B_NO_ERROR)
	{
		BFile				prefFile;

		prefPath.Append(APP_PREFS_FILENAME);
		if (prefFile.SetTo(prefPath.Path(), B_WRITE_ONLY | B_CREATE_FILE) == B_NO_ERROR)
		{
			prefMsg.Flatten(&prefFile);
			prefFile.Unset();
		}
	}
}


void
AmachiApp::UsePrefs(BMessage& msg)
{
	BRect		frame;
	int32		version;

	msg.FindInt32("version",	&version);
	if (msg.FindRect("main", &frame) == B_NO_ERROR)
		SetFrame(amachiWin, frame);
	if (msg.FindRect("loaders", &frame) == B_NO_ERROR)
		SetFrame(loadersWin, frame);
	if (msg.FindRect("setup", &frame) == B_NO_ERROR)
		SetFrame(setupWin, frame);
	if (msg.FindRect("messages", &frame) == B_NO_ERROR)
		SetFrame(messagesWin, frame);
	if (msg.FindRect("gl", &frame) == B_NO_ERROR)
		SetFrame(glWin, frame);

	int32			n;
	if (msg.FindInt32("parserBlockSize", &n) == B_NO_ERROR)
		parserBlockSize = n;
	if (msg.FindInt32("maxRunningParsers", &n) == B_NO_ERROR)
	{
		if (loadersRoster->LockLooper())
		{
			loadersRoster->SetMaxRunningParsers(n);
			loadersRoster->UnlockLooper();
		}
	}

	defaultRenderParams.ReadFrom(&msg);
}


void
AmachiApp::SetFrame(BWindow* win, const BRect& frame)
{
	win->MoveTo(frame.LeftTop());
	win->ResizeTo(frame.Width(), frame.Height());
}


void
AmachiApp::ShowWindow(int32 winId) const
{
	BWindow*			win = NULL;

	switch (winId)
	{
		case AMACHI_INFO_WINDOW:
			win = infoWin;
			break;

		case AMACHI_MESSAGES_WINDOW:
			win = messagesWin;
			break;

		case AMACHI_SETUP_WINDOW:
			win = setupWin;
			break;

		case AMACHI_OPENGL_WINDOW:
			win = glWin;
			break;

		case AMACHI_LOADERS_WINDOW:
			win = loadersWin;
			break;

		default:
			break;
	}

	if (win)
	{
		BScreen			screen(amachiWin);
		screen_id		sid = screen.ID();

		win->SetWorkspaces(sid.id);
		if (win->Lock())
		{
			if (win->IsHidden())
				win->Show();
			else
				win->Activate(true);
			win->Unlock();
		}
	}
}


void
AmachiApp::ShowAllWindows() const
{
	ShowWindow(AMACHI_INFO_WINDOW);
	ShowWindow(AMACHI_MESSAGES_WINDOW);
	ShowWindow(AMACHI_SETUP_WINDOW);
	ShowWindow(AMACHI_OPENGL_WINDOW);
	ShowWindow(AMACHI_LOADERS_WINDOW);
}


void
AmachiApp::HideWindow(int32 winId) const
{
	BWindow*			win = NULL;

	switch (winId)
	{
		case AMACHI_INFO_WINDOW:
			win = infoWin;
			break;

		case AMACHI_MESSAGES_WINDOW:
			win = messagesWin;
			break;

		case AMACHI_SETUP_WINDOW:
			win = setupWin;
			break;

		case AMACHI_OPENGL_WINDOW:
			win = glWin;
			break;

		case AMACHI_LOADERS_WINDOW:
			win = loadersWin;
			break;

		default:
			break;
	}

	if (win)
	{
		if (win->Lock())
		{
			if (!win->IsHidden())
				win->Hide();
			win->Unlock();
		}
	}
}


void
AmachiApp::HideAllWindows() const
{
	HideWindow(AMACHI_INFO_WINDOW);
	HideWindow(AMACHI_MESSAGES_WINDOW);
	HideWindow(AMACHI_SETUP_WINDOW);
	HideWindow(AMACHI_OPENGL_WINDOW);
	HideWindow(AMACHI_LOADERS_WINDOW);
}


void
AmachiApp::QuitWindow(BWindow* w)
{
	while (w->IsLocked())
		w->Unlock();
	w->Lock();
	w->Quit();
}


void
AmachiApp::LoadIcons()
{
	BPath			iconPath;
	BBitmap*		err;
	BBitmap*		wrn;
	BBitmap*		inf;

	iconPath.SetTo(appPath.Path());
	iconPath.Append("art/error16x16.gif");
	err = BTranslationUtils::GetBitmapFile(iconPath.Path());

	iconPath.SetTo(appPath.Path());
	iconPath.Append("art/warning16x16.gif");
	wrn = BTranslationUtils::GetBitmapFile(iconPath.Path());

	iconPath.SetTo(appPath.Path());
	iconPath.Append("art/info16x16.gif");
	inf = BTranslationUtils::GetBitmapFile(iconPath.Path());

	messagesWin->SetMessageIcons(err, wrn, inf);
}


bool
AmachiApp::QuitRequested()
{
	if (loadersWin->Lock())
	{
		int32			n = loadersRoster->CountItems();
		loadersWin->Unlock();
		if (n > 1)
		{
			*messagesOutput << errmsg << "Can't quit Amachi, " << n
							<< " parsers are still running" << flush;
			return false;
		}
	}
	WritePrefs();
//	loadersWin->StopLoaders();

	QuitWindow(glWin);

	QuitWindow(amachiWin);
	QuitWindow(loadersWin);
	QuitWindow(setupWin);

	return true;
}


void
AmachiApp::MessageReceived(BMessage* msg)
{
	if (msg->HasRef("refs"))
	{
		this->RefsReceived(msg);
		return;
	}

	SceneItem*			sceneItem = NULL;
	int32				itemIndex = -1;
	int32				winId = -1;

	switch(msg->what)
	{
		case AMACHI_NEW_SCENE:
			msg->FindPointer("sceneItem", &sceneItem);
			if (sceneItem)
			{
				sceneItem->SetConfig(defaultRenderParams);
				amachiWin->PostMessage(msg);
			}
			break;

		case AMACHI_SHOW_WINDOW:
			msg->FindInt32("winId", &winId);
			ShowWindow(winId);
			break;

		case AMACHI_SHOW_ALL_WINDOWS:
			ShowAllWindows();
			break;

		case AMACHI_HIDE_ALL_WINDOWS:
			HideAllWindows();
			break;

		case B_NODE_MONITOR:
			setupWin->PostMessage(msg);
			break;

		case AMACHI_PREFS_MSG:
			UsePrefs(*msg);
			break;

		case AMACHI_ABOUT_MSG:
			ShowWindow(AMACHI_INFO_WINDOW);
			break;

		default:
			BApplication::MessageReceived(msg);
			break;
	}
}


void
AmachiApp::RefsReceived(BMessage* msg)
{
	uint32				type;
	int32				nbRefs;
	entry_ref			ref;

	msg->GetInfo("refs", &type, &nbRefs);
	if (type != B_REF_TYPE)
		return ;

	for (int32 i = 0; i < nbRefs; i++)
	{
		if (msg->FindRef("refs", i, &ref) == B_OK)
		{
			// traverse if symbolic link
			entry_ref		tref;
			struct stat		st;
			BEntry			e(&ref, true);
			if (e.InitCheck() != B_NO_ERROR)
				continue;
			e.GetRef(&tref);

			// check for a file
			if ((e.GetStat(&st) != B_NO_ERROR)
				|| !S_ISREG(st.st_mode))
				continue;

			bool			sceneExists = false;
			if (amachiWin->Lock())
			{
				sceneExists = scenesRoster->Exists(tref);
				amachiWin->Unlock();
			}
			if (sceneExists)
			{
//				printf("%s has already been loaded\n", tref.name);
*messagesOutput << infomsg;
*messagesOutput << tref.name << " has already been loaded" << flush;
				continue;
			}

			bool			loaderExists = false;
			if (loadersWin->Lock())
			{
				loaderExists = loadersRoster->Exists(tref);
				loadersWin->Unlock();
			}
			if (loaderExists)
			{
//				printf("%s is already loading\n", tref.name);
*messagesOutput << infomsg;
*messagesOutput << tref.name << " is already loading" << flush;
				continue ;
			}

			VloaderItem*		li = FindHandlerFor(ref);
			if (!li)
			{
				printf("no handler found for '%s'\n", ref.name);
				continue;
			}

			// add new loader
			if (loadersWin->Lock())
			{
				loadersRoster->AddItem(li);
				loadersWin->Unlock();
			}
		}
	}
}


VloaderItem*
AmachiApp::FindHandlerFor(entry_ref r)
{
	AmachiAddOn*		aao = (AmachiAddOn* )addonsRoster->Filter(AddonCanHandleFile, &r);
	if (!aao)
		return NULL;
//printf("load %s with '%s'\n", r.name, aao->GetId());

	VloaderItem*		li;
//	LAPparser*			prs = aao->GetConstructor()(parserBlockSize, errorOutput);
	LAPparser*			prs = aao->GetConstructor()(parserBlockSize, messagesOutput);
	li = new VloaderItem(prs, r, loadersRoster);
//	prs->GetTraceOutput()->SetNoOutput();
	return li;
}


bool
AmachiApp::AddonCanHandleFile(PlainAddOn* ao, void* r)
{
	ParserConstructor	pc = ((AmachiAddOn* )ao)->GetConstructor();
	LAPparser*			p = pc(1024, NULL);
	bool				out = p->SetInput(*(entry_ref* )r, LAP_NO_TRACE) == LAP_NO_ERROR;
	p->Terminate();
	delete p;
	return out;
}
