//
//
//	Am@chi OpenGL view
//
//


#ifndef _AMACHI_OPENGL_VIEW_H_
#define _AMACHI_OPENGL_VIEW_H_


#include <GL/glut.h>
#include <GLView.h>

#include "PierrotColor.h"
#include "PierrotScene.h"
#include "AmachiGLConfig.h"


class					AmachiGLView : public BGLView
{
	enum
	{
		AMACHI_RENDER_ONLY_OPAQUE_FACES,
		AMACHI_RENDER_ONLY_TRANSPARENT_FACES,
		AMACHI_RENDER_ALL_FACES_AS_OPAQUE
	};

	// specific OpenGL implementation
	int32				maxLightNumber;
/*	const uchar*		vendor;
	const uchar*		renderer;
	const uchar*		version;
	const uchar*		extensions;
*/

protected:
	pSpectra			black;
	pSpectra*			bgColor;

	float				hwRatio;
	float				depthOfView;
	pVector3			tStep;
	pVector3			rStep;

	pScene*				scene;
	pViewSys			viewsys;
	pViewSys			oldViewsys;

	GLconfig*			current;
	GLconfig			previous;
	AmachiGLConfig*		configView;

	bool				EnforceGLstate();
	void				DeclareLights();
	void				SetProjection(float , int16 );
/*	void				ReadConfig();
	void				WriteConfig();
*/
	void				DoClear();
	void				DoRender();
	void				DoRenderObjectDots(pObject* );
	void				DoRenderObject(pObject* , uint8 );

	virtual void		AttachedToWindow();
	virtual void		DetachedFromWindow();
	virtual void		WindowActivated(bool );
	virtual void		MessageReceived(BMessage* );
	virtual void		KeyDown(const char* , int32 );
	virtual void		FrameResized(float , float );
	virtual void		Draw(BRect );

	// the renderer runs in a separate thread
	thread_id			rendererThread;
	static int32		renderer(void* );

public:
	sem_id				renderSem;
	sem_id				quitSem;
	bool				exitRenderThread;
	bool				manualMotion;


						AmachiGLView(BRect, char* , uint32 , uint32 , uint32);
	virtual				~AmachiGLView();

	void				SetTo(pScene* , GLconfig* , AmachiGLConfig* );
	bool				NeedsUpdate();

	void				Render();
	void				Clear();
	void				Spin();
};


#endif	/* _AMACHI_OPENGL_VIEW_H_ */
