//
//
//	View loader item
//
//											(C) JoOl 1998


#ifndef _VLIST_LOADER_ITEM_H_
#define _VLIST_LOADER_ITEM_H_


#include "Vitem.h"
#include "LAPparser.h"
#include "CdButton.h"
#include "LAPappliInterface.h"
#include "SceneItem.h"



class						VloaderItem : public Vitem, public LAPappliInterface
{
	BHandler*				msgTarget;

	// GUI elements
	BStringView*			label;
	BStatusBar*				statusBar;
//	CdButton*				stopButton;
	void					BuildView();

	// parsing stuff
	enum
	{
		AMACHI_LOADER_WAITING	= 0x10,		// status when object constructed
		AMACHI_LOADER_READY,				// thread spawned
		AMACHI_LOADER_PAUSED,				// thread spawned & suspended
		AMACHI_LOADER_STOPPED,				// thread spawned & stopped
		AMACHI_LOADER_RUNNING,				// thread spawned & running
		AMACHI_LOADER_DONE					// thread done
	};

	uint16					loaderStatus;
	entry_ref				ref;
	LAPparser*				parser;
	uint32					parserReturnStatus;

	thread_id				loaderThread;
	bool					LaunchLoader();
	static int32			LoaderEntry(void* );
	int32					Load();

	float					prevTime;
	float					prevRate;

public:
							VloaderItem(LAPparser* , entry_ref& , BHandler* ,
										uint32 = B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,
										uint32 = B_WILL_DRAW);
	virtual					~VloaderItem();

	entry_ref				GetRef() const;
	inline uint16			GetStatus() const
	{ return loaderStatus; };

	virtual void			AttachedToWindow();

	bool					IsWaiting() const;
	bool					IsActive() const;
	bool					IsReady() const;
	bool					IsPaused() const;
	bool					IsStopped() const;
	bool					IsRunning() const;

	bool					Run();
	bool					Play();
	bool					Pause();
	bool					Stop();

	// part of LAPappliInterface
	virtual status_t		ReportProgress(float , float , float );
};


#endif /* _VLIST_LOADER_ITEM_H_ */

