//
//
//	View loader item
//
//											(C) JoOl 1998


#include <stdio.h>
#include <StringView.h>
#include <StatusBar.h>

#include "AmachiDefs.h"
#include "LAPerrors.h"
#include "VloaderItem.h"
#include "PierrotScene.h"



VloaderItem::VloaderItem(LAPparser* p, entry_ref& r, BHandler* target, uint32 rmode, uint32 flgs)
: Vitem(BRect(0.0, 0.0, 10.0, 10.0), "", rmode, flgs),
  msgTarget(target),
  loaderStatus(AMACHI_LOADER_WAITING),
  ref(r),
  parser(p),
  parserReturnStatus(LAP_NO_ERROR),
  loaderThread(-1),
  prevTime(0.0),
  prevRate(0.0)
{
	BPath			path;
	BEntry			entry(&ref, true);
	entry.GetPath(&path);

	SetId((char* )path.Path());

	BuildView();

	// reset view size
	BRect			fr(0.0, 0.0, 0.0, 0.0);
	for (int32 i = 0; i < CountChildren(); i++)
		fr = fr | ChildAt(i)->Frame();
	fr.bottom += 5.0;
	ResizeTo(2.0 + fr.Width() + 2.0, fr.Height() + 2.0);
}


VloaderItem::~VloaderItem()
{
	if (parser)
		delete parser;
}


entry_ref
VloaderItem::GetRef() const
{
	return ref;
}


void
VloaderItem::BuildView()
{
	char*				nam = new char[strlen(Name()) + 10 + 1];

	BFont				font;
	GetFont(&font);

	// build label
	BRect				fr(0.0, 0.0, 1.0+font.StringWidth(ref.name)+1.0, 1.0+font.Size()+1.0);
	fr.OffsetBy(4.0, 4.0);
	sprintf(nam, "%s_label", Name());
	label = new BStringView(fr, nam, ref.name, B_FOLLOW_LEFT | B_FOLLOW_TOP,
							B_WILL_DRAW);
	label->SetHighColor(200, 0, 0, 0);
	AddChild(label);

	// build buttons
	BMessage*			mon;
	BMessage*			moff;
/*
	fr.OffsetBy(16.0, fr.Height() + 7.0);
	fr.SetRightBottom(BPoint(fr.left + 25.0, fr.top + 18.0));

	sprintf(nam, "%s_stop", Name());
	stopButton = new CdStopButton(fr, nam);
	AddChild(stopButton);

	mon = new BMessage(AMACHI_STOP_LOADER);
	moff = new BMessage(AMACHI_STOP_LOADER);
	mon->AddPointer("source", this);
	moff->AddPointer("source", this);
	stopButton->SetMessages(mon, moff, msgTarget);
*/
	// build status bar
	fr.Set(0.0, 0.0, 150.0, 20.0);
	fr.OffsetBy(70.0, label->Frame().bottom + 2.0);
	sprintf(nam, "%s_sbar", Name());
	statusBar = new BStatusBar(fr, nam, NULL, NULL);
	statusBar->SetBarHeight(8.0);
	statusBar->SetText("waiting...");
	AddChild(statusBar);

	delete[] nam;
}


void
VloaderItem::AttachedToWindow()
{
	statusBar->SetMaxValue(1.0);
	ResizeTo(Parent()->Bounds().Width(), Bounds().Height());
}


bool
VloaderItem::IsWaiting() const
{
	return (loaderStatus == AMACHI_LOADER_WAITING);
}


bool
VloaderItem::IsActive() const
{
	return (loaderThread >= 0);
}


bool
VloaderItem::IsReady() const
{
	return IsActive() && (loaderStatus == AMACHI_LOADER_READY);
}


bool
VloaderItem::IsPaused() const
{
	return IsActive() && (loaderStatus == AMACHI_LOADER_PAUSED);
}


bool
VloaderItem::IsStopped() const
{
	return IsActive() && (loaderStatus == AMACHI_LOADER_STOPPED);
}


bool
VloaderItem::IsRunning() const
{
	return IsActive() && (loaderStatus == AMACHI_LOADER_RUNNING);
}


bool
VloaderItem::Run()
{
	if (loaderStatus != AMACHI_LOADER_WAITING)
		return false;

	if (parser->SetInput(ref, LAP_NO_TRACE) != LAP_NO_ERROR)
	{
		parser->Terminate();
		delete parser;
		parser = NULL;
		loaderStatus = AMACHI_LOADER_DONE;
		return false;
	}
	parser->SetAppliInterface(this);

	char*			nam = new char[1+strlen(ref.name) + 2];
	sprintf(nam, "_%s", ref.name);
	loaderThread = spawn_thread(LoaderEntry, nam, B_NORMAL_PRIORITY, this);
	delete[] nam;

	if (loaderThread < 0)
		return false;

	statusBar->SetText("ready...");

	loaderStatus = AMACHI_LOADER_RUNNING;
	resume_thread(loaderThread);
	return true;
}

/*
bool
VloaderItem::Play()
{
	if (IsWaiting())
		return Run();

	if (IsReady() || IsPaused())
	{
		while (parser->IsLocked())
			parser->UnlockNoThrow();
		loaderStatus = AMACHI_LOADER_RUNNING;
		return true;
	}
	return false;
}


bool
VloaderItem::Pause()
{
	if (IsRunning())
	{
		parser->LockNoThrow();
		loaderStatus = AMACHI_LOADER_PAUSED;
		return true;
	}
	return false;
}
*/

bool
VloaderItem::Stop()
{
	statusBar->SetText("aborting...");

	// if thread not already spawned, simply send "done" message
	if (!IsActive())
	{
//		stopButton->SetEnabled(false);

		BMessage		msg(AMACHI_DONE_LOADER);
		msg.AddPointer("source", this);
		msg.AddPointer("scene", NULL);
		msgTarget->Looper()->PostMessage(&msg, msgTarget);

		loaderStatus = AMACHI_LOADER_STOPPED;
		parserReturnStatus = LAP_LOAD_ABORTED;
//printf("stop> status=%d\n", loaderStatus);
		return true;
	}

	if (IsPaused() || IsRunning())
	{
//		stopButton->SetEnabled(false);
		parser->Abort();
		loaderStatus = AMACHI_LOADER_STOPPED;
		parserReturnStatus = LAP_LOAD_ABORTED;
printf("stop> status=%d\n", loaderStatus);
		return true;
	}
	return false;
}


int32
VloaderItem::LoaderEntry(void* o)
{
	return ((VloaderItem* )o)->Load();
}


int32
VloaderItem::Load()
{
	statusBar->SetText("parsing...");
printf("parsing %s...\n", GetId());
	parserReturnStatus = parser->Parse();
printf("done %s\n", GetId());
	loaderStatus = AMACHI_LOADER_DONE;
	loaderThread = -1;

	pScene*			scene = NULL;
	if (parserReturnStatus == LAP_NO_ERROR)
	{
		// retrieve 3d data from the parser
		scene = (pScene* )parser->DetachData();
	}

	// send "done" message
	BMessage		msg(AMACHI_DONE_LOADER);
	msg.AddPointer("source", this);
	msg.AddPointer("scene", scene);
	msgTarget->Looper()->PostMessage(&msg, msgTarget);

	return parserReturnStatus;
}


status_t
VloaderItem::ReportProgress(float current, float total, float time)
{
	// no update when loader is being stopped
	if (loaderStatus == AMACHI_LOADER_STOPPED)
		return LAP_NO_ERROR;

	float				rate = current / total;
	float				speed = current / time;
	float				time_left = (1.0 - rate) * total / speed;

	if ((time - prevTime < 1.0) && (rate - prevRate < 0.05) && (rate < 1.0))
		return LAP_NO_ERROR;
	prevTime = time;
	prevRate = rate;

	if (LockLooper())
	{
		statusBar->Update(rate - statusBar->CurrentValue());

		if (prevRate >= 1.0)
		{
//			stopButton->SetEnabled(false);

			rgb_color			c;
			c.red = 255;
			c.green = c.blue = 0;
			prevTime = 0.0;
			prevRate = 0.0;

			statusBar->Reset();
			statusBar->SetBarColor(c);
			statusBar->SetMaxValue(1.0);
			statusBar->SetText("processing...");
		}
		UnlockLooper();
	}

	return LAP_NO_ERROR;
}

